/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.DataBuilder;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserOperatingSystemMapping;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.Device;
import net.sf.uadetector.internal.data.domain.DevicePattern;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlDataHandler
extends DefaultHandler {
    private static final String CHARSET = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(XmlDataHandler.class);
    protected static final String UASDATA_DEF = "uadetector/uasxmldata.dtd";
    protected static final String UASDATA_DEF_URL = "http://user-agent-string.info/rpc/uasxmldata.dtd";
    private Browser.Builder browserBuilder = new Browser.Builder();
    private Device.Builder deviceBuilder = new Device.Builder();
    private BrowserOperatingSystemMapping.Builder browserOsMappingBuilder = new BrowserOperatingSystemMapping.Builder();
    private BrowserPattern.Builder browserPatternBuilder = new BrowserPattern.Builder();
    private DevicePattern.Builder devicePatternBuilder = new DevicePattern.Builder();
    private BrowserType.Builder browserTypeBuilder = new BrowserType.Builder();
    private StringBuilder buffer = new StringBuilder();
    private Tag currentTag = null;
    @Nonnull
    private final DataBuilder dataBuilder;
    private boolean error = false;
    private boolean isBrowser = false;
    private boolean isBrowserOsMapping = false;
    private boolean isBrowserPattern = false;
    private boolean isBrowserType = false;
    private boolean isDevice = false;
    private boolean isDevicePattern = false;
    private boolean isOperatingSystem = false;
    private boolean isOperatingSystemPattern = false;
    private boolean isRobot = false;
    private OperatingSystem.Builder operatingSystemBuilder = new OperatingSystem.Builder();
    private OperatingSystemPattern.Builder operatingSystemPatternBuilder = new OperatingSystemPattern.Builder();
    private Robot.Builder robotBuilder = new Robot.Builder();
    private boolean warning = false;

    protected static void logParsingIssue(String prefix, SAXParseException e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        buffer.append(" while reading UAS data: ");
        buffer.append(e.getMessage());
        buffer.append(" (line: ");
        buffer.append(e.getLineNumber());
        if (e.getSystemId() != null) {
            buffer.append(" uri: ");
            buffer.append(e.getSystemId());
        }
        buffer.append(")");
        LOG.warn(buffer.toString());
    }

    public XmlDataHandler(@Nonnull DataBuilder builder) {
        Check.notNull((Object)builder, (String)"builder");
        this.dataBuilder = builder;
    }

    private void addToBrowserBuilder() {
        if (this.isBrowser) {
            if (this.currentTag == Tag.ID) {
                this.browserBuilder.setId(this.buffer.toString());
            } else if (this.currentTag == Tag.BROWSER_TYPE_ID) {
                this.browserBuilder.setTypeId(this.buffer.toString());
            } else if (this.currentTag == Tag.NAME) {
                this.browserBuilder.setFamilyName(this.buffer.toString());
            } else if (this.currentTag == Tag.URL) {
                this.browserBuilder.setUrl(this.buffer.toString());
            } else if (this.currentTag == Tag.COMPANY) {
                this.browserBuilder.setProducer(this.buffer.toString());
            } else if (this.currentTag == Tag.COMPANY_URL) {
                this.browserBuilder.setProducerUrl(this.buffer.toString());
            } else if (this.currentTag == Tag.ICON) {
                this.browserBuilder.setIcon(this.buffer.toString());
            } else if (this.currentTag == Tag.BROWSER_INFO_URL) {
                this.browserBuilder.setInfoUrl(this.buffer.toString());
            }
        }
    }

    private void addToBrowserOsMappingBuilder() {
        if (this.isBrowserOsMapping && this.currentTag == Tag.BROWSER_ID) {
            this.browserOsMappingBuilder.setBrowserId(this.buffer.toString());
        } else if (this.isBrowserOsMapping && this.currentTag == Tag.OPERATING_SYSTEM_ID) {
            this.browserOsMappingBuilder.setOperatingSystemId(this.buffer.toString());
        }
    }

    private void addToBrowserPatternBuilder() {
        if (this.isBrowserPattern && this.currentTag == Tag.PATTERN_ORDER) {
            this.browserPatternBuilder.setPosition(this.buffer.toString());
        } else if (this.isBrowserPattern && this.currentTag == Tag.BROWSER_ID) {
            this.browserPatternBuilder.setId(this.buffer.toString());
        } else if (this.isBrowserPattern && this.currentTag == Tag.PATTERN_REGEX) {
            this.browserPatternBuilder.setPerlRegularExpression(this.buffer.toString());
        }
    }

    private void addToBrowserTypeBuilder() {
        if (this.isBrowserType && this.currentTag == Tag.ID) {
            this.browserTypeBuilder.setId(this.buffer.toString());
        } else if (this.isBrowserType && this.currentTag == Tag.BROWSER_TYPE_ID) {
            this.browserTypeBuilder.setName(this.buffer.toString());
        }
    }

    private void addToDeviceBuilder() {
        if (this.isDevice) {
            if (this.currentTag == Tag.ID) {
                this.deviceBuilder.setId(this.buffer.toString());
            } else if (this.currentTag == Tag.NAME) {
                this.deviceBuilder.setName(this.buffer.toString());
            } else if (this.currentTag == Tag.ICON) {
                this.deviceBuilder.setIcon(this.buffer.toString());
            } else if (this.currentTag == Tag.DEVICE_INFO_URL) {
                this.deviceBuilder.setInfoUrl(this.buffer.toString());
            }
        }
    }

    private void addToDevicePatternBuilder() {
        if (this.isDevicePattern && this.currentTag == Tag.PATTERN_ORDER) {
            this.devicePatternBuilder.setPosition(this.buffer.toString());
        } else if (this.isDevicePattern && this.currentTag == Tag.DEVICE_ID) {
            this.devicePatternBuilder.setId(this.buffer.toString());
        } else if (this.isDevicePattern && this.currentTag == Tag.PATTERN_REGEX) {
            this.devicePatternBuilder.setPerlRegularExpression(this.buffer.toString());
        }
    }

    private void addToOperatingSystemBuilder() {
        if (this.isOperatingSystem) {
            if (this.currentTag == Tag.ID) {
                this.operatingSystemBuilder.setId(this.buffer.toString());
            } else if (this.currentTag == Tag.FAMILY) {
                this.operatingSystemBuilder.setFamily(this.buffer.toString());
            } else if (this.currentTag == Tag.NAME) {
                this.operatingSystemBuilder.setName(this.buffer.toString());
            } else if (this.currentTag == Tag.URL) {
                this.operatingSystemBuilder.setUrl(this.buffer.toString());
            } else if (this.currentTag == Tag.COMPANY) {
                this.operatingSystemBuilder.setProducer(this.buffer.toString());
            } else if (this.currentTag == Tag.COMPANY_URL) {
                this.operatingSystemBuilder.setProducerUrl(this.buffer.toString());
            } else if (this.currentTag == Tag.ICON) {
                this.operatingSystemBuilder.setIcon(this.buffer.toString());
            } else if (this.currentTag == Tag.OPERATING_SYSTEM_INFO_URL) {
                this.operatingSystemBuilder.setInfoUrl(this.buffer.toString());
            }
        }
    }

    private void addToOperatingSystemPatternBuilder() {
        if (this.isOperatingSystemPattern) {
            if (this.currentTag == Tag.PATTERN_ORDER) {
                this.operatingSystemPatternBuilder.setPosition(this.buffer.toString());
            } else if (this.currentTag == Tag.OPERATING_SYSTEM_ID) {
                this.operatingSystemPatternBuilder.setId(this.buffer.toString());
            } else if (this.currentTag == Tag.PATTERN_REGEX) {
                this.operatingSystemPatternBuilder.setPerlRegularExpression(this.buffer.toString());
            }
        }
    }

    private void addToRobotBuilder() {
        if (this.isRobot) {
            if (this.currentTag == Tag.ID) {
                this.robotBuilder.setId(this.buffer.toString());
            } else if (this.currentTag == Tag.USERAGENT) {
                this.robotBuilder.setUserAgentString(this.buffer.toString());
            } else if (this.currentTag == Tag.FAMILY) {
                this.robotBuilder.setFamilyName(this.buffer.toString());
            } else if (this.currentTag == Tag.NAME) {
                this.robotBuilder.setName(this.buffer.toString());
            } else if (this.currentTag == Tag.COMPANY) {
                this.robotBuilder.setProducer(this.buffer.toString());
            } else if (this.currentTag == Tag.COMPANY_URL) {
                this.robotBuilder.setProducerUrl(this.buffer.toString());
            } else if (this.currentTag == Tag.ICON) {
                this.robotBuilder.setIcon(this.buffer.toString());
            } else if (this.currentTag == Tag.ROBOT_INFO_URL) {
                this.robotBuilder.setInfoUrl(this.buffer.toString());
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(new String(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String tagName) throws SAXException {
        this.transferToSpecificBuilderAndReset();
        if (Tag.isRobotTag(tagName)) {
            this.saveAndResetRobotBuilder();
            this.isRobot = false;
        } else if (Tag.isBrowserTag(tagName)) {
            this.saveAndResetBrowserBuilder();
            this.isBrowser = false;
        } else if (Tag.isOperatingSystemTag(tagName)) {
            this.saveAndResetOperatingSystemBuilder();
            this.isOperatingSystem = false;
        } else if (Tag.isBrowserTypeTag(tagName)) {
            this.saveAndResetBrowserTypeBuilder();
            this.isBrowserType = false;
        } else if (Tag.isBrowserPatternTag(tagName)) {
            this.saveAndResetBrowserPatternBuilder();
            this.isBrowserPattern = false;
        } else if (Tag.isBrowserOsMappingTag(tagName)) {
            this.saveAndResetBrowserOperatingSystemMapping();
            this.isBrowserOsMapping = false;
        } else if (Tag.isOperatingSystemPatternTag(tagName)) {
            this.saveAndResetOperatingSystemPatternBuilder();
            this.isOperatingSystemPattern = false;
        } else if (Tag.isDeviceTag(tagName)) {
            this.saveAndResetDeviceBuilder();
            this.isDevice = false;
        } else if (Tag.isDevicePatternTag(tagName)) {
            this.saveAndResetDevicePatternBuilder();
            this.isDevicePattern = false;
        }
        this.currentTag = null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.error = true;
        XmlDataHandler.logParsingIssue("Error", e);
        super.fatalError(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        XmlDataHandler.logParsingIssue("Fatal error", e);
        super.fatalError(e);
    }

    public boolean hasError() {
        return this.error;
    }

    public boolean hasWarning() {
        return this.warning;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (UASDATA_DEF_URL.equals(systemId)) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(UASDATA_DEF);
            return new InputSource(new InputStreamReader(stream, CHARSET));
        }
        throw new SAXException("unable to resolve remote entity, systemId = " + systemId);
    }

    private void saveAndResetBrowserBuilder() {
        this.dataBuilder.appendBrowserBuilder(this.browserBuilder);
        this.browserBuilder = new Browser.Builder();
    }

    private void saveAndResetBrowserOperatingSystemMapping() {
        this.dataBuilder.appendBrowserOperatingSystemMapping(this.browserOsMappingBuilder.build());
        this.browserOsMappingBuilder = new BrowserOperatingSystemMapping.Builder();
    }

    private void saveAndResetBrowserPatternBuilder() {
        try {
            this.dataBuilder.appendBrowserPattern(this.browserPatternBuilder.build());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Can not append browser pattern: " + e.getLocalizedMessage());
        }
        this.browserPatternBuilder = new BrowserPattern.Builder();
    }

    private void saveAndResetBrowserTypeBuilder() {
        this.dataBuilder.appendBrowserType(this.browserTypeBuilder.build());
        this.browserTypeBuilder = new BrowserType.Builder();
    }

    private void saveAndResetDeviceBuilder() {
        this.dataBuilder.appendDeviceBuilder(this.deviceBuilder);
        this.deviceBuilder = new Device.Builder();
    }

    private void saveAndResetDevicePatternBuilder() {
        try {
            this.dataBuilder.appendDevicePattern(this.devicePatternBuilder.build());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Can not append device pattern: " + e.getLocalizedMessage());
        }
        this.devicePatternBuilder = new DevicePattern.Builder();
    }

    private void saveAndResetOperatingSystemBuilder() {
        this.dataBuilder.appendOperatingSystemBuilder(this.operatingSystemBuilder);
        this.operatingSystemBuilder = new OperatingSystem.Builder();
    }

    private void saveAndResetOperatingSystemPatternBuilder() {
        try {
            this.dataBuilder.appendOperatingSystemPattern(this.operatingSystemPatternBuilder.build());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Can not append OS pattern: " + e.getLocalizedMessage());
        }
        this.operatingSystemPatternBuilder = new OperatingSystemPattern.Builder();
    }

    private void saveAndResetRobotBuilder() {
        this.dataBuilder.appendRobot(this.robotBuilder.build());
        this.robotBuilder = new Robot.Builder();
    }

    @Override
    public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
        if (Tag.isRobotTag(tagName)) {
            this.isRobot = true;
        } else if (Tag.isBrowserTag(tagName)) {
            this.isBrowser = true;
        } else if (Tag.isOperatingSystemTag(tagName)) {
            this.isOperatingSystem = true;
        } else if (Tag.isBrowserTypeTag(tagName)) {
            this.isBrowserType = true;
        } else if (Tag.isBrowserPatternTag(tagName)) {
            this.isBrowserPattern = true;
        } else if (Tag.isBrowserOsMappingTag(tagName)) {
            this.isBrowserOsMapping = true;
        } else if (Tag.isOperatingSystemPatternTag(tagName)) {
            this.isOperatingSystemPattern = true;
        } else if (Tag.isDeviceTag(tagName)) {
            this.isDevice = true;
        } else if (Tag.isDevicePatternTag(tagName)) {
            this.isDevicePattern = true;
        }
        this.currentTag = Tag.evaluate(tagName);
    }

    private void transferToSpecificBuilderAndReset() {
        if (this.currentTag == Tag.VERSION) {
            this.dataBuilder.setVersion(this.buffer.toString());
        }
        this.addToRobotBuilder();
        this.addToBrowserBuilder();
        this.addToOperatingSystemBuilder();
        this.addToBrowserPatternBuilder();
        this.addToBrowserTypeBuilder();
        this.addToBrowserOsMappingBuilder();
        this.addToOperatingSystemPatternBuilder();
        this.addToDeviceBuilder();
        this.addToDevicePatternBuilder();
        this.buffer = new StringBuilder();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.warning = true;
        XmlDataHandler.logParsingIssue("Warning", e);
        super.warning(e);
    }

    public static enum Tag {
        BROWSER("browser"),
        BROWSER_ID("browser_id"),
        BROWSER_INFO_URL("browser_info_url"),
        BROWSER_OS_MAPPING("browser_os"),
        BROWSER_PATTERN("browser_reg"),
        BROWSER_TYPE("browser_type"),
        BROWSER_TYPE_ID("type"),
        COMPANY("company"),
        COMPANY_URL("url_company"),
        DEVICE("device"),
        DEVICE_ID("device_id"),
        DEVICE_INFO_URL("device_info_url"),
        DEVICE_PATTERN("device_reg"),
        DEVICES("devices"),
        DEVICES_PATTERN("devices_reg"),
        FAMILY("family"),
        ICON("icon"),
        ID("id"),
        NAME("name"),
        OPERATING_SYSTEM("os"),
        OPERATING_SYSTEM_ID("os_id"),
        OPERATING_SYSTEM_INFO_URL("os_info_url"),
        OPERATING_SYSTEM_PATTERN("operating_system_reg"),
        PATTERN_ORDER("order"),
        PATTERN_REGEX("regstring"),
        ROBOT("robot"),
        ROBOT_INFO_URL("bot_info_url"),
        URL("url"),
        USERAGENT("useragent"),
        VERSION("version");

        @Nonnull
        private String tagName;

        public static Tag evaluate(@Nonnull String tagName) {
            Check.notNull((Object)tagName, (String)"tagName");
            Tag result = null;
            for (Tag tag : Tag.values()) {
                if (!tag.getTagName().equalsIgnoreCase(tagName)) continue;
                result = tag;
                break;
            }
            return result;
        }

        public static boolean isBrowserOsMappingTag(String tagName) {
            return BROWSER_OS_MAPPING.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isBrowserPatternTag(String tagName) {
            return BROWSER_PATTERN.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isBrowserTag(String tagName) {
            return BROWSER.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isBrowserTypeTag(String tagName) {
            return BROWSER_TYPE.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isDevicePatternTag(String tagName) {
            return DEVICE_PATTERN.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isDeviceTag(String tagName) {
            return DEVICE.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isIdTag(String tagName) {
            return ID.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isOperatingSystemPatternTag(String tagName) {
            return OPERATING_SYSTEM_PATTERN.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isOperatingSystemTag(String tagName) {
            return OPERATING_SYSTEM.getTagName().equalsIgnoreCase(tagName);
        }

        public static boolean isRobotTag(String tagName) {
            return ROBOT.getTagName().equalsIgnoreCase(tagName);
        }

        private Tag(String tagName) {
            this.tagName = tagName;
        }

        @Nonnull
        public String getTagName() {
            return this.tagName;
        }
    }
}

