/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.rundata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.parser.CookieParser;
import org.apache.fulcrum.parser.DefaultCookieParser;
import org.apache.fulcrum.parser.DefaultParameterParser;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.fulcrum.parser.ParserService;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.DefaultTurbineRunData;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;

public class TurbineRunDataService
extends TurbineBaseService
implements RunDataService {
    private static final String DEFAULT_RUN_DATA = DefaultTurbineRunData.class.getName();
    private static final String DEFAULT_PARAMETER_PARSER = DefaultParameterParser.class.getName();
    private static final String DEFAULT_COOKIE_PARSER = DefaultCookieParser.class.getName();
    private final Map<String, Object> configurations = new HashMap<String, Object>();
    private PoolService pool = null;
    private ParserService parserService = null;

    @Override
    public void init() throws InitializationException {
        String[] def = new String[]{DEFAULT_RUN_DATA, DEFAULT_PARAMETER_PARSER, DEFAULT_COOKIE_PARSER};
        this.configurations.put("default", def.clone());
        Configuration conf = this.getConfiguration();
        if (conf != null) {
            String[] plist = new String[]{"run.data", "parameter.parser", "cookie.parser"};
            Iterator i = conf.getKeys();
            block0: while (i.hasNext()) {
                String key = (String)i.next();
                String value = conf.getString(key);
                for (int j = 0; j < plist.length; ++j) {
                    if (!key.endsWith(plist[j]) || key.length() <= plist[j].length() + 1) continue;
                    String[] config = (String[])this.configurations.get(key = key.substring(0, key.length() - plist[j].length() - 1));
                    if (config == null) {
                        config = (String[])def.clone();
                        this.configurations.put(key, config);
                    }
                    config[j] = value;
                    continue block0;
                }
            }
        }
        this.pool = (PoolService)TurbineServices.getInstance().getService(PoolService.ROLE);
        if (this.pool == null) {
            throw new InitializationException("RunData Service requires configured Pool Service!");
        }
        this.parserService = (ParserService)TurbineServices.getInstance().getService(ParserService.ROLE);
        if (this.parserService == null) {
            throw new InitializationException("RunData Service requires configured Parser Service!");
        }
        this.setInit(true);
    }

    @Override
    public RunData getRunData(HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException {
        return this.getRunData("default", req, res, config);
    }

    @Override
    public RunData getRunData(String key, HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException, IllegalArgumentException {
        TurbineRunData data;
        HashMap<Class, Object> pipelineDataMap = new HashMap<Class, Object>();
        if (req == null || res == null || config == null) {
            throw new IllegalArgumentException("HttpServletRequest, HttpServletResponse or ServletConfig was null.");
        }
        String[] cfg = (String[])this.configurations.get(key);
        if (cfg == null) {
            throw new TurbineException("RunTime configuration '" + key + "' is undefined");
        }
        try {
            Class<?> runDataClazz = Class.forName(cfg[0]);
            Class<?> parameterParserClazz = Class.forName(cfg[1]);
            Class<?> cookieParserClazz = Class.forName(cfg[2]);
            data = (TurbineRunData)this.pool.getInstance(runDataClazz);
            ParameterParser pp = (ParameterParser)this.parserService.getParser(parameterParserClazz);
            data.setParameterParser(pp);
            CookieParser cp = (CookieParser)this.parserService.getParser(cookieParserClazz);
            data.setCookieParser(cp);
            pipelineDataMap.put(ParameterParser.class, pp);
            pipelineDataMap.put(CookieParser.class, cp);
            Locale locale = req.getLocale();
            if (locale == null) {
                locale = data.getLocale();
            }
            data.setLocale(locale);
        }
        catch (PoolException pe) {
            throw new TurbineException("RunData configuration '" + key + "' is illegal caused a pool exception", pe);
        }
        catch (ClassNotFoundException x) {
            throw new TurbineException("RunData configuration '" + key + "' is illegal", x);
        }
        catch (ClassCastException x) {
            throw new TurbineException("RunData configuration '" + key + "' is illegal", x);
        }
        catch (InstantiationException e) {
            throw new TurbineException("RunData configuration '" + key + "' is illegal", e);
        }
        data.setRequest(req);
        data.setResponse(res);
        pipelineDataMap.put(HttpServletRequest.class, req);
        pipelineDataMap.put(HttpServletResponse.class, res);
        data.setServletConfig(config);
        pipelineDataMap.put(ServletConfig.class, config);
        ServerData sd = new ServerData(req);
        data.setServerData(sd);
        pipelineDataMap.put(ServerData.class, sd);
        data.put(Turbine.class, pipelineDataMap);
        return data;
    }

    @Override
    public boolean putRunData(RunData data) {
        if (data instanceof TurbineRunData) {
            this.parserService.putParser((ValueParser)((TurbineRunData)data).getParameterParser());
            this.parserService.putParser((ValueParser)((TurbineRunData)data).getCookieParser());
            return this.pool.putInstance((Object)data);
        }
        return false;
    }
}

