/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.jamon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.reflection.Clazz;
import org.apache.fulcrum.yaafi.interceptor.baseservice.BaseInterceptorServiceImpl;
import org.apache.fulcrum.yaafi.interceptor.jamon.JamonInterceptorService;
import org.apache.fulcrum.yaafi.interceptor.jamon.JamonPerformanceMonitor;

public class JamonInterceptorServiceImpl
extends BaseInterceptorServiceImpl
implements JamonInterceptorService,
Reconfigurable,
ThreadSafe,
Disposable,
Initializable {
    private boolean isJamonAvailable;
    private File reportFile;
    private long reportTimeout;
    private boolean reportOnExit;
    private long nextReportTimestamp;
    private String performanceMonitorClassName;
    private Class performanceMonitorClass;
    private static final String MONITORFACTORY_CLASSNAME = "com.jamonapi.MonitorFactory";
    private static final String DEFAULT_PERFORMANCEMONITOR_CLASSNAME = "org.apache.fulcrum.yaafi.interceptor.jamon.Jamon1PerformanceMonitorImpl";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.reportTimeout = configuration.getChild("reportTimeout").getValueAsLong(0L);
        this.performanceMonitorClassName = configuration.getChild("performanceMonitorClassName").getValue(DEFAULT_PERFORMANCEMONITOR_CLASSNAME);
        String reportFileName = configuration.getChild("reportFile").getValue("./jamon.html");
        this.reportFile = this.makeAbsoluteFile(reportFileName);
        this.nextReportTimestamp = System.currentTimeMillis() + this.reportTimeout;
        this.reportOnExit = configuration.getChild("reportOnExit").getValueAsBoolean(false);
    }

    public void initialize() throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        if (!Clazz.hasClazz(classLoader, MONITORFACTORY_CLASSNAME)) {
            String msg = "The JamonInterceptorService is disabled since the JAMON classes are not found in the classpath";
            this.getLogger().warn(msg);
            this.isJamonAvailable = false;
            return;
        }
        if (!Clazz.hasClazz(classLoader, this.performanceMonitorClassName)) {
            String msg = "The JamonInterceptorService is disabled since the performance monitor class is not found in the classpath";
            this.getLogger().warn(msg);
            this.isJamonAvailable = false;
            return;
        }
        this.performanceMonitorClass = Clazz.getClazz(this.getClassLoader(), this.performanceMonitorClassName);
        JamonPerformanceMonitor testMonitor = this.createJamonPerformanceMonitor(null, null, true);
        if (testMonitor == null) {
            String msg = "The JamonInterceptorService is disabled since the performance monitor can't be instantiated";
            this.getLogger().warn(msg);
            this.isJamonAvailable = false;
            return;
        }
        this.getLogger().debug("The JamonInterceptorService is enabled");
        this.isJamonAvailable = true;
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        super.reconfigure(configuration);
        this.configure(configuration);
    }

    public void dispose() {
        if (this.reportOnExit) {
            this.run();
        }
        this.reportFile = null;
    }

    public void onEntry(AvalonInterceptorContext interceptorContext) {
        if (this.isJamonAvailable()) {
            this.writeReport();
            String serviceShortHand = interceptorContext.getServiceShorthand();
            Method serviceMethod = interceptorContext.getMethod();
            boolean isEnabled = this.isServiceMonitored(interceptorContext);
            JamonPerformanceMonitor monitor = this.createJamonPerformanceMonitor(serviceShortHand, serviceMethod, isEnabled);
            monitor.start();
            interceptorContext.getRequestContext().put(this.getServiceName(), monitor);
        }
    }

    public void onExit(AvalonInterceptorContext interceptorContext, Object result) {
        if (this.isJamonAvailable()) {
            JamonPerformanceMonitor monitor = (JamonPerformanceMonitor)interceptorContext.getRequestContext().remove(this.getServiceName());
            monitor.stop();
        }
    }

    public void onError(AvalonInterceptorContext interceptorContext, Throwable t) {
        if (this.isJamonAvailable()) {
            JamonPerformanceMonitor monitor = (JamonPerformanceMonitor)interceptorContext.getRequestContext().remove(this.getServiceName());
            monitor.stop(t);
        }
    }

    public void run() {
        this.writeReport(this.reportFile);
    }

    protected final boolean isJamonAvailable() {
        return this.isJamonAvailable;
    }

    protected JamonPerformanceMonitor createJamonPerformanceMonitor(String serviceName, Method method, boolean isEnabled) {
        JamonPerformanceMonitor result = null;
        try {
            Class[] signature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JamonInterceptorServiceImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = JamonInterceptorServiceImpl.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method, class$java$lang$Boolean == null ? (class$java$lang$Boolean = JamonInterceptorServiceImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean};
            Object[] args = new Object[]{serviceName, method, isEnabled ? Boolean.TRUE : Boolean.FALSE};
            result = (JamonPerformanceMonitor)Clazz.newInstance(this.performanceMonitorClass, signature, args);
            return result;
        }
        catch (Exception e) {
            String msg = "Failed to create a performance monitor instance : " + this.performanceMonitorClassName;
            this.getLogger().error(msg, (Throwable)e);
            return result;
        }
    }

    protected void writeReport() {
        long currTimestamp;
        if (this.reportTimeout > 0L && (currTimestamp = System.currentTimeMillis()) > this.nextReportTimestamp) {
            this.nextReportTimestamp = currTimestamp + this.reportTimeout;
            this.writeReport(this.reportFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeReport(File reportFile) {
        PrintWriter printWriter = null;
        if (this.isJamonAvailable()) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Writing JAMOM report to " + reportFile.getAbsolutePath());
                }
                FileOutputStream fos = new FileOutputStream(reportFile);
                printWriter = new PrintWriter(fos);
                JamonPerformanceMonitor monitor = this.createJamonPerformanceMonitor(null, null, true);
                String report = monitor.createReport();
                printWriter.write(report);
                printWriter.close();
            }
            catch (Throwable t) {
                String msg = "Generating the JAMON report failed for " + reportFile.getAbsolutePath();
                this.getLogger().error(msg, t);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

