/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public abstract class SecuritySet<T>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = -1315871299888969431L;
    protected Map<String, T> nameMap = new TreeMap<String, T>();
    protected Map<Integer, T> idMap = new TreeMap<Integer, T>();

    public Set<? extends T> getSet() {
        return new HashSet<T>(this.nameMap.values());
    }

    public Set<String> getNames() {
        return this.nameMap.keySet();
    }

    public Set<Integer> getIds() {
        return this.idMap.keySet();
    }

    public void clear() {
        this.nameMap.clear();
        this.idMap.clear();
    }

    public boolean containsName(String name) {
        return StringUtils.isNotEmpty((String)name) ? this.nameMap.containsKey(name) : false;
    }

    public boolean containsId(int id) {
        return id == 0 ? false : this.idMap.containsKey(new Integer(id));
    }

    @Override
    public Iterator<T> iterator() {
        return this.nameMap.values().iterator();
    }

    public int size() {
        return this.nameMap.size();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(12 * this.size());
        Iterator<String> it = this.nameMap.keySet().iterator();
        while (it.hasNext()) {
            sbuf.append(it.next());
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }
}

