/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class LocalizationTool
implements ApplicationTool {
    private static Log log = LogFactory.getLog(LocalizationTool.class);
    private LocalizationService localizationService;
    protected Locale locale;

    public LocalizationService getLocalizationService() {
        if (this.localizationService == null) {
            try {
                this.localizationService = (LocalizationService)TurbineServices.getInstance().getService(LocalizationService.ROLE);
            }
            catch (Exception e) {
                throw new InstantiationException("Problem looking up Localization Service:" + e.getMessage());
            }
        }
        return this.localizationService;
    }

    public LocalizationTool() {
        this.refresh();
    }

    public String get(String key) {
        try {
            return this.getLocalizationService().getString(this.getBundleName(null), this.getLocale(), key);
        }
        catch (MissingResourceException noKey) {
            log.error((Object)noKey);
            return null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getBundleName(Object data) {
        return this.getLocalizationService().getDefaultBundleName();
    }

    public String format(String key, Object arg1) {
        return this.getLocalizationService().format(this.getBundleName(null), this.getLocale(), key, arg1);
    }

    public String format(String key, Object arg1, Object arg2) {
        return this.getLocalizationService().format(this.getBundleName(null), this.getLocale(), key, arg1, arg2);
    }

    public String format(String key, Object[] args) {
        return this.getLocalizationService().format(this.getBundleName(null), this.getLocale(), key, args);
    }

    @Override
    public void init(Object data) {
        if (data instanceof RunData) {
            this.locale = this.getLocalizationService().getLocale(((RunData)data).getRequest());
        }
    }

    @Override
    public void refresh() {
        this.locale = null;
    }
}

