/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.query.QueryByExample;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.SequenceEntry;
import ojb.broker.util.SequenceManager;

public class SequenceManagerDefaultImpl
implements SequenceManager {
    private PersistenceBrokerImpl broker;
    private static SequenceManagerDefaultImpl _instance;

    public SequenceManagerDefaultImpl(PersistenceBrokerImpl broker) {
        this.broker = broker;
    }

    private int getMaxIdForClass(ClassDescriptor cld, String fieldName) {
        try {
            String table = cld.getTableName();
            String schema = cld.getScheme();
            if (schema != null) {
                table = schema + "." + table;
            }
            String column = cld.getFieldDescriptorByName(fieldName).getColumnName();
            String sql = "SELECT MAX(" + column + ") FROM " + table;
            Statement stmt = this.broker.getStatementManager().getGenericStatement(cld);
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            int result = rs.getInt(1);
            rs.close();
            stmt.close();
            return result;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private synchronized int getNextId(Class clazz, String fieldName) {
        try {
            SequenceEntry tmp = new SequenceEntry();
            tmp.setClassname(clazz.getName());
            tmp.setFieldname(fieldName);
            SequenceEntry entry = (SequenceEntry)this.broker.getObjectByQuery(new QueryByExample(tmp));
            if (entry == null) {
                int lastId = this.getMaxForExtent(clazz, fieldName);
                entry = new SequenceEntry(clazz.getName(), fieldName, lastId);
            }
            int nextId = entry.getCurrent() + 1;
            entry.setCurrent(nextId);
            this.broker.store(entry);
            return nextId;
        }
        catch (PersistenceBrokerException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public int getUniqueId(Class clazz, String fieldName) {
        return this.getNextId(clazz, fieldName);
    }

    private int getMaxForExtent(Class clazz, String fieldName) throws ClassNotPersistenceCapableException {
        int tmp;
        int max = 0;
        ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(clazz);
        if (!cld.isInterface() && (tmp = this.getMaxIdForClass(cld, fieldName)) > max) {
            max = tmp;
        }
        if (cld.isExtent()) {
            Vector extentClasses = cld.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                cld = DescriptorRepository.getInstance().getDescriptorFor(ec);
                int tmp2 = this.getMaxIdForClass(cld, fieldName);
                if (tmp2 > max) {
                    max = tmp2;
                }
                ++i;
            }
        }
        return max;
    }

    public String getUniqueString(Class clazz, String fieldName) {
        return Integer.toString(this.getUniqueId(clazz, fieldName));
    }
}

