/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;

public class IndirectionHandler
implements InvocationHandler {
    private PersistenceBroker broker = null;
    private Object realSubject = null;
    private Identity id = null;

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class[] carr = this.buildClassArray(args);
        Object subject = this.getRealSubject();
        Method m = subject.getClass().getMethod(method.getName(), carr);
        return m.invoke(subject, args);
    }

    private Class[] buildClassArray(Object[] args) {
        if (args != null) {
            Class[] result = new Class[args.length];
            int i = 0;
            while (i < result.length) {
                result[i] = args[i].getClass();
                ++i;
            }
            return result;
        }
        return null;
    }

    public IndirectionHandler(Identity oid) {
        this.id = oid;
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this.realSubject == null) {
            this.materializeSubject();
        }
        return this.realSubject;
    }

    private synchronized void materializeSubject() throws PersistenceBrokerException {
        this.realSubject = this.broker.getObjectByIdentity(this.id);
    }

    public boolean alreadyMaterialized() {
        return this.realSubject != null;
    }
}

