/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.store.imap.connection;

import jakarta.mail.MessagingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.mail.store.imap.connection.IMAPBody;
import org.apache.geronimo.mail.store.imap.connection.IMAPBodySection;
import org.apache.geronimo.mail.store.imap.connection.IMAPBodyStructure;
import org.apache.geronimo.mail.store.imap.connection.IMAPEnvelope;
import org.apache.geronimo.mail.store.imap.connection.IMAPFetchDataItem;
import org.apache.geronimo.mail.store.imap.connection.IMAPFlags;
import org.apache.geronimo.mail.store.imap.connection.IMAPInternalDate;
import org.apache.geronimo.mail.store.imap.connection.IMAPInternetHeader;
import org.apache.geronimo.mail.store.imap.connection.IMAPMessageSize;
import org.apache.geronimo.mail.store.imap.connection.IMAPMessageText;
import org.apache.geronimo.mail.store.imap.connection.IMAPResponseTokenizer;
import org.apache.geronimo.mail.store.imap.connection.IMAPUid;
import org.apache.geronimo.mail.store.imap.connection.IMAPUntaggedResponse;

public class IMAPFetchResponse
extends IMAPUntaggedResponse {
    protected List dataItems = new ArrayList();
    public int sequenceNumber;

    public IMAPFetchResponse(int sequenceNumber, byte[] data, IMAPResponseTokenizer source) throws MessagingException {
        super("FETCH", data);
        this.sequenceNumber = sequenceNumber;
        source.checkLeftParen();
        while (source.notListEnd()) {
            String itemName = source.readAtom(true).toUpperCase();
            if (itemName.equals("ENVELOPE")) {
                this.dataItems.add(new IMAPEnvelope(source));
                continue;
            }
            if (itemName.equals("BODYSTRUCTURE")) {
                this.dataItems.add(new IMAPBodyStructure(source));
                continue;
            }
            if (itemName.equals("FLAGS")) {
                this.dataItems.add(new IMAPFlags(source));
                continue;
            }
            if (itemName.equals("INTERNALDATE")) {
                this.dataItems.add(new IMAPInternalDate(source));
                continue;
            }
            if (itemName.equals("UID")) {
                this.dataItems.add(new IMAPUid(sequenceNumber, source));
                continue;
            }
            if (itemName.equals("RFC822")) {
                itemName = source.readAtom(false).toUpperCase();
                if (itemName.equals(".SIZE")) {
                    this.dataItems.add(new IMAPMessageSize(source));
                    continue;
                }
                if (itemName.equals(".HEADER")) {
                    this.dataItems.add(new IMAPInternetHeader(source.readByteArray()));
                    continue;
                }
                if (!itemName.equals(".TEXT")) continue;
                this.dataItems.add(new IMAPMessageText(source.readByteArray()));
                continue;
            }
            if (!itemName.equals("BODY")) continue;
            IMAPBodySection section = new IMAPBodySection(source);
            switch (section.section) {
                case 0: {
                    this.dataItems.add(new IMAPBody(section, source.readByteArray()));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.dataItems.add(new IMAPInternetHeader(section, source.readByteArray()));
                    break;
                }
                case 4: {
                    this.dataItems.add(new IMAPMessageText(section, source.readByteArray()));
                }
            }
        }
        source.checkRightParen();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getCount() {
        return this.dataItems.size();
    }

    public List getDataItems() {
        return this.dataItems;
    }

    public IMAPFetchDataItem getDataItem(int type) {
        for (int i = 0; i < this.dataItems.size(); ++i) {
            IMAPFetchDataItem item = (IMAPFetchDataItem)this.dataItems.get(i);
            if (!item.isType(type)) continue;
            return item;
        }
        return null;
    }
}

