/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.api.models.security.OAuthFlowImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.security.OAuthScopeIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.jboss.jandex.AnnotationInstance;

public class OAuthFlowIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<OAuthFlow, V, A, O, AB, OB> {
    private static final String PROP_SCOPES = "scopes";
    private static final String PROP_REFRESH_URL = "refreshUrl";
    private static final String PROP_TOKEN_URL = "tokenUrl";
    private static final String PROP_AUTHORIZATION_URL = "authorizationUrl";
    private final OAuthScopeIO<V, A, O, AB, OB> oauthScopeIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    protected OAuthFlowIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.OAUTH_FLOW, Names.create(OAuthFlow.class));
        this.oauthScopeIO = new OAuthScopeIO<V, A, O, AB, OB>(context);
        this.extensionIO = extensionIO;
    }

    @Override
    public OAuthFlow read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@OAuthFlow");
        OAuthFlowImpl flow = new OAuthFlowImpl();
        flow.setAuthorizationUrl((String)this.value(annotation, PROP_AUTHORIZATION_URL));
        flow.setTokenUrl((String)this.value(annotation, PROP_TOKEN_URL));
        flow.setRefreshUrl((String)this.value(annotation, PROP_REFRESH_URL));
        flow.setScopes(this.oauthScopeIO.readMap(annotation.value(PROP_SCOPES)));
        flow.setExtensions(this.extensionIO.readExtensible(annotation));
        return flow;
    }

    @Override
    public OAuthFlow readObject(O node) {
        IoLogging.logger.singleJsonObject("OAuthFlow");
        OAuthFlowImpl flow = new OAuthFlowImpl();
        flow.setAuthorizationUrl(this.jsonIO().getString(node, PROP_AUTHORIZATION_URL));
        flow.setTokenUrl(this.jsonIO().getString(node, PROP_TOKEN_URL));
        flow.setRefreshUrl(this.jsonIO().getString(node, PROP_REFRESH_URL));
        flow.setScopes(this.oauthScopeIO.readMap(this.jsonIO().getValue(node, PROP_SCOPES)));
        flow.setExtensions(this.extensionIO.readMap(node));
        return flow;
    }

    @Override
    public Optional<O> write(OAuthFlow model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_AUTHORIZATION_URL, this.jsonIO().toJson(model.getAuthorizationUrl()));
            this.setIfPresent(node, PROP_TOKEN_URL, this.jsonIO().toJson(model.getTokenUrl()));
            this.setIfPresent(node, PROP_REFRESH_URL, this.jsonIO().toJson(model.getRefreshUrl()));
            this.setIfPresent(node, PROP_SCOPES, this.oauthScopeIO.write(model.getScopes()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

