/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.ContentReference;

public class SignatureImpl
extends AbstractXMLObject
implements Signature {
    @Nullable
    private String canonicalizationAlgorithm;
    @Nullable
    private String signatureAlgorithm;
    @Nullable
    private Integer hmacOutputLength;
    @Nullable
    private Credential signingCredential;
    @Nullable
    private KeyInfo keyInfo;
    @Nonnull
    private List<ContentReference> contentReferences = new LinkedList<ContentReference>();
    @Nullable
    private XMLSignature xmlSignature;

    protected SignatureImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public String getCanonicalizationAlgorithm() {
        return this.canonicalizationAlgorithm;
    }

    public void setCanonicalizationAlgorithm(@Nullable String newAlgorithm) {
        this.canonicalizationAlgorithm = this.prepareForAssignment(this.canonicalizationAlgorithm, newAlgorithm);
    }

    @Nullable
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(@Nullable String newAlgorithm) {
        this.signatureAlgorithm = this.prepareForAssignment(this.signatureAlgorithm, newAlgorithm);
    }

    @Nullable
    public Integer getHMACOutputLength() {
        return this.hmacOutputLength;
    }

    public void setHMACOutputLength(@Nullable Integer length) {
        this.hmacOutputLength = (Integer)this.prepareForAssignment(this.hmacOutputLength, length);
    }

    @Nullable
    public Credential getSigningCredential() {
        return this.signingCredential;
    }

    public void setSigningCredential(@Nullable Credential newCredential) {
        this.signingCredential = (Credential)this.prepareForAssignment(this.signingCredential, newCredential);
    }

    @Nullable
    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(@Nullable KeyInfo newKeyInfo) {
        this.keyInfo = (KeyInfo)this.prepareForAssignment((XMLObject)this.keyInfo, (XMLObject)newKeyInfo);
    }

    @Nonnull
    @Live
    public List<ContentReference> getContentReferences() {
        return this.contentReferences;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public List<XMLObject> getOrderedChildren() {
        return null;
    }

    public void releaseDOM() {
        super.releaseDOM();
        this.xmlSignature = null;
        if (this.keyInfo != null) {
            this.keyInfo.releaseChildrenDOM(true);
            assert (this.keyInfo != null);
            this.keyInfo.releaseDOM();
        }
    }

    @Nullable
    public XMLSignature getXMLSignature() {
        return this.xmlSignature;
    }

    public void setXMLSignature(@Nullable XMLSignature signature) {
        this.xmlSignature = (XMLSignature)this.prepareForAssignment(this.xmlSignature, signature);
    }
}

