/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.api.RateLimitException;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitEvents;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitLogger;
import io.smallrye.faulttolerance.core.rate.limit.TimeWindow;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.Preconditions;

public class RateLimit<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final String description;
    final TimeWindow timeWindow;

    public RateLimit(FaultToleranceStrategy<V> delegate, String description, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis, RateLimitType type, Stopwatch stopwatch) {
        this.delegate = Preconditions.checkNotNull(delegate, "Rate limit delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Rate limit description must be set");
        Preconditions.checkNotNull(type, "Rate limit type must be set");
        Preconditions.check(maxInvocations, maxInvocations > 0, "Max invocations must be > 0");
        Preconditions.check(timeWindowInMillis, timeWindowInMillis > 0L, "Time window length must be > 0");
        Preconditions.check(minSpacingInMillis, minSpacingInMillis >= 0L, "Min spacing must be >= 0");
        Preconditions.checkNotNull(stopwatch, "Stopwatch must be set");
        if (type == RateLimitType.FIXED) {
            this.timeWindow = TimeWindow.createFixed(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
        } else if (type == RateLimitType.ROLLING) {
            this.timeWindow = TimeWindow.createRolling(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
        } else if (type == RateLimitType.SMOOTH) {
            this.timeWindow = TimeWindow.createSmooth(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
        } else {
            throw new IllegalArgumentException("Unknown rate limit type: " + String.valueOf(type));
        }
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        RateLimitLogger.LOG.trace("RateLimit started");
        try {
            V v = this.doApply(ctx);
            return v;
        }
        finally {
            RateLimitLogger.LOG.trace("RateLimit finished");
        }
    }

    private V doApply(InvocationContext<V> ctx) throws Exception {
        long retryAfter = this.timeWindow.record();
        if (retryAfter == 0L) {
            RateLimitLogger.LOG.trace("Task permitted by rate limit");
            ctx.fireEvent(RateLimitEvents.DecisionMade.PERMITTED);
            return this.delegate.apply(ctx);
        }
        RateLimitLogger.LOG.debugf("%s rate limit exceeded", this.description);
        ctx.fireEvent(RateLimitEvents.DecisionMade.REJECTED);
        throw new RateLimitException(retryAfter, this.description + " rate limit exceeded");
    }
}

