import { RemoteConnection } from '../driver/remote-connection.js';
import { GraphTraversalSource, GraphTraversal } from './graph-traversal.js';
/**
 * Provides a unified way to construct a <code>TraversalSource</code> from the perspective of the traversal. In this
 * syntax the user is creating the source and binding it to a reference which is either an existing <code>Graph</code>
 * instance or a <code>RemoteConnection</code>.
 */
export default class AnonymousTraversalSource {
    readonly traversalSourceClass?: typeof GraphTraversalSource | undefined;
    readonly traversalClass?: typeof GraphTraversal | undefined;
    /**
     * Creates a new instance of {@code AnonymousTraversalSource}.
     * @param {Function} [traversalSourceClass] Optional {@code GraphTraversalSource} constructor.
     * @param {Function} [traversalClass] Optional {@code GraphTraversal} constructor.
     */
    constructor(traversalSourceClass?: typeof GraphTraversalSource | undefined, traversalClass?: typeof GraphTraversal | undefined);
    /**
     * Constructs an {@code AnonymousTraversalSource} which will then be configured to spawn a
     * {@link GraphTraversalSource}.
     * @param {Function} [traversalSourceClass] Optional {@code GraphTraversalSource} constructor.
     * @param {Function} [traversalClass] Optional {@code GraphTraversalSource} constructor.
     * @returns {AnonymousTraversalSource}.
     */
    static traversal(traversalSourceClass?: typeof GraphTraversalSource, traversalClass?: typeof GraphTraversal): AnonymousTraversalSource;
    /**
     * Creates a {@link GraphTraversalSource} binding a {@link RemoteConnection} to a remote {@link Graph} instances as its
     * reference so that traversals spawned from it will execute over that reference.
     * @param {RemoteConnection} connection
     * @return {GraphTraversalSource}
     */
    with_(connection: RemoteConnection): GraphTraversalSource;
    /**
     * Creates a {@link GraphTraversalSource} binding a {@link RemoteConnection} to a remote {@link Graph} instances as its
     * reference so that traversals spawned from it will execute over that reference.
     * @param {RemoteConnection} remoteConnection
     * @return {GraphTraversalSource}
     * @deprecated As of release 4.0.0, prefer {@link with_}.
     */
    withRemote(remoteConnection: RemoteConnection): GraphTraversalSource;
}
