/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.extendable.DefaultExtendableItem;

public class Configuration
extends DefaultExtendableItem
implements InheritableItem {
    private String name;
    private String description;
    private Set<String> extendsFrom;
    private Visibility visibility;
    private boolean transitive = true;
    private String deprecated;
    private ModuleRevisionId sourceModule;

    public static Collection<Configuration> findConfigurationExtending(String conf, Configuration[] confs) {
        ArrayList<Configuration> extendingConfs = new ArrayList<Configuration>();
        for (Configuration cf : confs) {
            if (cf == null || !Arrays.asList(cf.getExtends()).contains(conf)) continue;
            extendingConfs.add(cf);
            extendingConfs.addAll(Configuration.findConfigurationExtending(cf.getName(), confs));
        }
        return extendingConfs;
    }

    public Configuration(String name) {
        this(name, Visibility.PUBLIC, null, null, true, null);
    }

    public Configuration(Configuration source, ModuleRevisionId sourceModule) {
        this(source.getAttributes(), source.getQualifiedExtraAttributes(), source.getName(), source.getVisibility(), source.getDescription(), source.getExtends(), source.isTransitive(), source.getDeprecated(), sourceModule);
    }

    public Configuration(String name, Visibility visibility, String description, String[] ext, boolean transitive, String deprecated) {
        this(null, null, name, visibility, description, ext, transitive, deprecated, null);
    }

    private Configuration(Map<String, String> attributes, Map<String, String> extraAttributes, String name, Visibility visibility, String description, String[] exts, boolean transitive, String deprecated, ModuleRevisionId sourceModule) {
        super(attributes, extraAttributes);
        if (name == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this.name = name;
        this.visibility = visibility;
        this.description = description;
        if (exts == null) {
            this.extendsFrom = Collections.emptySet();
        } else {
            this.extendsFrom = new LinkedHashSet<String>();
            for (String ext : exts) {
                this.extendsFrom.add(ext.trim());
            }
        }
        this.transitive = transitive;
        this.deprecated = deprecated;
        this.sourceModule = sourceModule;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtends() {
        return this.extendsFrom.toArray(new String[this.extendsFrom.size()]);
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public final boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof Configuration && ((Configuration)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void replaceWildcards(ModuleDescriptor md) {
        if (this != md.getConfiguration(this.name)) {
            throw new IllegalArgumentException("The given ModuleDescriptor doesn't own this configuration!");
        }
        Configuration[] configs = md.getConfigurations();
        LinkedHashSet<String> newExtends = new LinkedHashSet<String>();
        Iterator<String> iterator = this.extendsFrom.iterator();
        block10: while (iterator.hasNext()) {
            String extend;
            switch (extend = iterator.next()) {
                case "*": {
                    this.addOther(configs, null, newExtends);
                    continue block10;
                }
                case "*(public)": {
                    this.addOther(configs, Visibility.PUBLIC, newExtends);
                    continue block10;
                }
                case "*(private)": {
                    this.addOther(configs, Visibility.PRIVATE, newExtends);
                    continue block10;
                }
            }
            newExtends.add(extend);
        }
        this.extendsFrom = newExtends;
    }

    private void addOther(Configuration[] allConfigs, Visibility visibility, Set<String> configs) {
        for (Configuration allConfig : allConfigs) {
            String currentName = allConfig.getName();
            if (this.name.equals(currentName) || visibility != null && !visibility.equals(allConfig.getVisibility())) continue;
            configs.add(currentName);
        }
    }

    public static final class Visibility {
        public static final Visibility PUBLIC = new Visibility("public");
        public static final Visibility PRIVATE = new Visibility("private");
        private String name;

        public static Visibility getVisibility(String name) {
            switch (name) {
                case "private": {
                    return PRIVATE;
                }
                case "public": {
                    return PUBLIC;
                }
            }
            throw new IllegalArgumentException("unknown visibility " + name);
        }

        private Visibility(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

