/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.executable;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UniversalExecutableParser
implements Parser {
    private static final long serialVersionUID = 1L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("x-mach-o-universal"));
    private static final int MAX_ARCHS_COUNT = 1000;
    private static final int MAX_ARCH_SIZE = 500000000;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext arg0) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        byte[] first4 = new byte[4];
        IOUtils.readFully(stream, first4);
        if ((first4[0] == -65 || first4[0] == -66) && first4[1] == -70 && first4[2] == -2 && first4[3] == -54) {
            this.parseMachO(xhtml, extractor, metadata, stream, first4);
        } else if (first4[0] == -54 && first4[1] == -2 && first4[2] == -70 && (first4[3] == -65 || first4[3] == -66)) {
            this.parseMachO(xhtml, extractor, metadata, stream, first4);
        } else {
            throw new UnsupportedFormatException("Not a universal executable file");
        }
        xhtml.endDocument();
    }

    public void parseMachO(XHTMLContentHandler xhtml, EmbeddedDocumentExtractor extractor, Metadata metadata, InputStream stream, byte[] first4) throws IOException, SAXException, TikaException {
        int archIndex;
        int archsCount;
        long currentOffset = first4.length;
        boolean isLE = first4[3] == -54;
        boolean is64 = first4[isLE ? 0 : 3] == -65;
        int archStructSize = 8 + (is64 ? 24 : 12);
        int n = archsCount = isLE ? EndianUtils.readIntLE(stream) : EndianUtils.readIntBE(stream);
        if (archsCount < 1) {
            throw new TikaException("Invalid number of architectures: " + archsCount);
        }
        if (archsCount > 1000) {
            throw new TikaException("Number of architectures=" + archsCount + " greater than max allowed=1000");
        }
        currentOffset += 4L;
        long archsSize = (long)archsCount * (long)archStructSize;
        boolean unsortedOffsets = false;
        Pair[] offsetAndSizePerArch = new Pair[archsCount];
        for (archIndex = 0; archIndex < archsCount; ++archIndex) {
            long size;
            long offset;
            IOUtils.skipFully(stream, 8L);
            long l = is64 ? (isLE ? EndianUtils.readLongLE(stream) : EndianUtils.readLongBE(stream)) : (offset = (long)(isLE ? EndianUtils.readIntLE(stream) : EndianUtils.readIntBE(stream)));
            if (offset < 8L + archsSize) {
                throw new TikaException("Invalid offset: " + offset);
            }
            if (!unsortedOffsets && archIndex > 0 && offset < (Long)offsetAndSizePerArch[archIndex - 1].getLeft()) {
                unsortedOffsets = true;
            }
            long l2 = is64 ? (isLE ? EndianUtils.readLongLE(stream) : EndianUtils.readLongBE(stream)) : (size = (long)(isLE ? EndianUtils.readIntLE(stream) : EndianUtils.readIntBE(stream)));
            if (size < 0L || size > 500000000L) {
                throw new TikaException("Arch size=" + size + " must be > 0 and < 500000000");
            }
            offsetAndSizePerArch[archIndex] = Pair.of(offset, size);
            if (is64) {
                IOUtils.skipFully(stream, 8L);
            } else {
                IOUtils.skipFully(stream, 4L);
            }
            currentOffset += (long)archStructSize;
        }
        if (unsortedOffsets) {
            Arrays.sort(offsetAndSizePerArch, Comparator.comparingLong(entry -> (Long)entry.getLeft()));
        }
        for (archIndex = 0; archIndex < archsCount; ++archIndex) {
            long skipUntilStart = (Long)offsetAndSizePerArch[archIndex].getLeft() - currentOffset;
            IOUtils.skipFully(stream, skipUntilStart);
            currentOffset += skipUntilStart;
            long sz = (Long)offsetAndSizePerArch[archIndex].getRight();
            byte[] perArchMachO = new byte[(int)sz];
            IOUtils.readFully(stream, perArchMachO);
            currentOffset += (long)perArchMachO.length;
            Metadata perArchMetadata = new Metadata();
            TikaInputStream tikaInputStream = TikaInputStream.get(perArchMachO, perArchMetadata);
            if (!extractor.shouldParseEmbedded(perArchMetadata)) continue;
            extractor.parseEmbedded(tikaInputStream, xhtml, perArchMetadata, true);
        }
    }
}

