/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.exceptions;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ExceptionReportWriter;
import org.apache.tapestry5.services.ExceptionReporter;
import org.slf4j.Logger;

public class ExceptionReporterImpl
implements ExceptionReporter {
    @Inject
    @Symbol(value="tapestry.exception-reports-dir")
    private File logDir;
    @Inject
    @Symbol(value="tapestry.restrictive-environment")
    private boolean restrictive;
    private final AtomicInteger uid = new AtomicInteger();
    @Inject
    private Logger logger;
    @Inject
    private ExceptionReportWriter exceptionReportWriter;

    @Override
    public void reportException(Throwable exception) {
        Date date = new Date();
        String fileName = String.format("exception-%tY%<tm%<td-%<tH%<tM%<tS-%<tL.%d.txt", date, this.uid.getAndIncrement());
        File folder = this.getOutputFolder(date);
        try {
            if (!this.restrictive) {
                folder.mkdirs();
            }
            File log = new File(folder, fileName);
            this.writeExceptionToFile(exception, log);
            this.logger.warn(String.format("Wrote exception report to %s", this.toURI(log)));
        }
        catch (Exception ex) {
            this.logger.error(String.format("Unable to write exception report %s at %s: %s", fileName, folder.getAbsolutePath(), ExceptionUtils.toMessage((Throwable)ex)));
            this.logger.error("Original exception:", exception);
        }
    }

    private File getOutputFolder(Date date) {
        if (this.restrictive) {
            return this.logDir;
        }
        String folderName = String.format("%tY-%<tm-%<td/%<tH/%<tM", date);
        return new File(this.logDir, folderName);
    }

    private String toURI(File file) {
        try {
            return file.toURI().toString();
        }
        catch (Exception e) {
            return file.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExceptionToFile(Throwable exception, File log) throws IOException {
        log.createNewFile();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(log);
            this.exceptionReportWriter.writeReport(writer, exception);
        }
        catch (Throwable throwable) {
            InternalUtils.close(writer);
            throw throwable;
        }
        InternalUtils.close((Closeable)writer);
    }
}

