/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CaseInsensitiveMap;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.MultiKey;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry5.internal.services.ClassNameHolder;
import org.apache.tapestry5.internal.services.MapMessages;
import org.apache.tapestry5.internal.services.MessagesBundle;
import org.apache.tapestry5.internal.services.MessagesSource;
import org.apache.tapestry5.internal.services.MessagesTrackingInfo;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.messages.PropertiesFileParser;
import org.apache.tapestry5.services.pageload.ComponentResourceLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public class MessagesSourceImpl
extends InvalidationEventHubImpl
implements MessagesSource {
    private final URLChangeTracker<MessagesTrackingInfo> tracker;
    private final PropertiesFileParser propertiesFileParser;
    private final ComponentResourceLocator resourceLocator;
    private final ComponentClassResolver componentClassResolver;
    private final boolean multipleClassLoaders;
    private final Logger logger;
    private final Map<MultiKey, Messages> messagesByBundleIdAndSelector = CollectionFactory.newConcurrentMap();
    private final Map<MultiKey, Map<String, String>> cookedProperties = CollectionFactory.newConcurrentMap();
    private final Map<Resource, Map<String, String>> rawProperties = CollectionFactory.newConcurrentMap();
    private final Map<String, String> emptyMap = Collections.emptyMap();

    public MessagesSourceImpl(boolean productionMode, boolean multipleClassLoaders, URLChangeTracker tracker, ComponentResourceLocator resourceLocator, PropertiesFileParser propertiesFileParser, ComponentClassResolver componentClassResolver, Logger logger) {
        super(productionMode, logger);
        this.tracker = tracker;
        this.propertiesFileParser = propertiesFileParser;
        this.resourceLocator = resourceLocator;
        this.logger = logger;
        this.componentClassResolver = componentClassResolver;
        this.multipleClassLoaders = multipleClassLoaders;
    }

    public void checkForUpdates() {
        if (this.tracker != null) {
            Set changedResources = this.tracker.getChangedResourcesInfo();
            if (!changedResources.isEmpty() && this.logger.isInfoEnabled()) {
                this.logger.info("Changed message file(s): {}", (Object)changedResources.stream().map(MessagesTrackingInfo::getResource).map(Object::toString).collect(Collectors.joining(", ")));
            }
            boolean applicationLevelChange = false;
            for (MessagesTrackingInfo info : changedResources) {
                String className = info.getClassName();
                if (className == null || !this.multipleClassLoaders) {
                    this.invalidate();
                    applicationLevelChange = true;
                    break;
                }
                Iterator<Map.Entry<MultiKey, Messages>> messagesByBundleIdAndSelectorIterator = this.messagesByBundleIdAndSelector.entrySet().iterator();
                while (messagesByBundleIdAndSelectorIterator.hasNext()) {
                    Map.Entry<MultiKey, Messages> entry = messagesByBundleIdAndSelectorIterator.next();
                    if (!className.equals(entry.getKey().getValues()[0])) continue;
                    messagesByBundleIdAndSelectorIterator.remove();
                }
                Iterator<Map.Entry<MultiKey, Map<String, String>>> cookedPropertiesIterator = this.cookedProperties.entrySet().iterator();
                while (cookedPropertiesIterator.hasNext()) {
                    Map.Entry<MultiKey, Map<String, String>> entry = cookedPropertiesIterator.next();
                    if (!className.equals(entry.getKey().getValues()[0])) continue;
                    cookedPropertiesIterator.remove();
                }
                String resourceFile = info.getResource().getFile();
                Iterator<Map.Entry<Resource, Map<String, String>>> rawPropertiesIterator = this.rawProperties.entrySet().iterator();
                while (rawPropertiesIterator.hasNext()) {
                    Map.Entry<Resource, Map<String, String>> entry = rawPropertiesIterator.next();
                    if (!resourceFile.equals(entry.getKey().getFile())) continue;
                    rawPropertiesIterator.remove();
                }
            }
            if (!changedResources.isEmpty() && !applicationLevelChange) {
                this.fireInvalidationEvent(changedResources.stream().filter(Objects::nonNull).map(ClassNameHolder::getClassName).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
    }

    public void invalidate() {
        this.messagesByBundleIdAndSelector.clear();
        this.cookedProperties.clear();
        this.rawProperties.clear();
        this.tracker.clear();
        this.fireInvalidationEvent();
    }

    @Override
    public Messages getMessages(MessagesBundle bundle, ComponentResourceSelector selector) {
        MultiKey key = new MultiKey(new Object[]{bundle.getId(), selector});
        Messages result = this.messagesByBundleIdAndSelector.get(key);
        if (result == null) {
            result = this.buildMessages(bundle, selector);
            this.messagesByBundleIdAndSelector.put(key, result);
        }
        return result;
    }

    private Messages buildMessages(MessagesBundle bundle, ComponentResourceSelector selector) {
        Map<String, String> properties = this.findBundleProperties(bundle, selector);
        return new MapMessages(selector.locale, properties);
    }

    private Map<String, String> findBundleProperties(MessagesBundle bundle, ComponentResourceSelector selector) {
        if (bundle == null) {
            return this.emptyMap;
        }
        MultiKey key = new MultiKey(new Object[]{bundle.getId(), selector});
        Map<String, String> existing = this.cookedProperties.get(key);
        if (existing != null) {
            return existing;
        }
        Resource propertiesResource = bundle.getBaseResource().withExtension("properties");
        List<Resource> localizations = this.resourceLocator.locateMessageCatalog(propertiesResource, selector);
        Map<String, String> previous = this.findBundleProperties(bundle.getParent(), selector);
        for (Resource localization : (Flow)F.flow(localizations).reverse()) {
            Map<String, String> rawProperties = this.getRawProperties(localization, bundle);
            previous = this.extend(previous, rawProperties);
        }
        this.cookedProperties.put(key, previous);
        return previous;
    }

    private Map<String, String> extend(Map<String, String> base, Map<String, String> rawProperties) {
        if (rawProperties.isEmpty()) {
            return base;
        }
        CaseInsensitiveMap result = new CaseInsensitiveMap(base);
        result.putAll(rawProperties);
        return result;
    }

    private Map<String, String> getRawProperties(Resource localization, MessagesBundle bundle) {
        Map<String, String> result = this.rawProperties.get(localization);
        if (result == null) {
            result = this.readProperties(localization, bundle);
            this.rawProperties.put(localization, result);
        }
        return result;
    }

    private Map<String, String> readProperties(Resource resource, MessagesBundle bundle) {
        if (!resource.exists()) {
            return this.emptyMap;
        }
        if (this.tracker != null) {
            MessagesTrackingInfo info = new MessagesTrackingInfo(resource, bundle != null ? bundle.getId() : bundle, this.getClassName(bundle));
            this.tracker.add(resource.toURL(), (Object)info);
        }
        try {
            return this.propertiesFileParser.parsePropertiesFile(resource);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to read message catalog from %s: %s", resource, ex), ex);
        }
    }

    private String getClassName(MessagesBundle bundle) {
        String path;
        String className = null;
        if (bundle != null && bundle.getBaseResource().getPath() != null && (path = bundle.getBaseResource().getPath()).endsWith(".class") && !this.componentClassResolver.isPage(className = path.replace('/', '.').replace(".class", ""))) {
            className = null;
        }
        return className;
    }
}

