/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api.mlcontext;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.mllib.util.MLUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.sysds.api.mlcontext.Frame;
import org.apache.sysds.api.mlcontext.FrameFormat;
import org.apache.sysds.api.mlcontext.FrameMetadata;
import org.apache.sysds.api.mlcontext.MLContext;
import org.apache.sysds.api.mlcontext.MLContextConversionUtil;
import org.apache.sysds.api.mlcontext.MLContextException;
import org.apache.sysds.api.mlcontext.Matrix;
import org.apache.sysds.api.mlcontext.MatrixFormat;
import org.apache.sysds.api.mlcontext.MatrixMetadata;
import org.apache.sysds.api.mlcontext.Metadata;
import org.apache.sysds.api.mlcontext.ProjectInfo;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.IfProgramBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.StringObject;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.utils.MLContextProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MLContextUtil {
    public static final String VERSION_NOT_AVAILABLE = "Version not available";
    public static final String BUILD_TIME_NOT_AVAILABLE = "Build time not available";
    public static final Class[] BASIC_DATA_TYPES = new Class[]{Integer.class, Boolean.class, Double.class, String.class};
    public static final Class[] COMPLEX_DATA_TYPES = new Class[]{JavaRDD.class, RDD.class, Dataset.class, Matrix.class, Frame.class, new double[0][].getClass(), MatrixBlock.class, URL.class};
    public static final Class[] ALL_SUPPORTED_DATA_TYPES = (Class[])ArrayUtils.addAll((Object[])BASIC_DATA_TYPES, (Object[])COMPLEX_DATA_TYPES);

    /*
     * Exception decompiling
     */
    private static int compareVersion(String versionStr1, String versionStr2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isSparkVersionSupported(String sparkVersion, String minimumRecommendedSparkVersion) {
        return MLContextUtil.compareVersion(sparkVersion, minimumRecommendedSparkVersion) >= 0;
    }

    public static void verifySparkVersionSupported(SparkSession spark) {
        String minimumRecommendedSparkVersion = null;
        try {
            ProjectInfo projectInfo = ProjectInfo.getProjectInfo();
            minimumRecommendedSparkVersion = projectInfo.minimumRecommendedSparkVersion();
        }
        catch (MLContextException e) {
            try {
                minimumRecommendedSparkVersion = MLContextUtil.getMinimumRecommendedSparkVersionFromPom();
            }
            catch (MLContextException e1) {
                throw new MLContextException("Minimum recommended Spark version could not be determined from SystemDS jar file manifest or pom.xml");
            }
        }
        String sparkVersion = spark.version();
        if (!MLContextUtil.isSparkVersionSupported(sparkVersion, minimumRecommendedSparkVersion)) {
            throw new MLContextException("Spark " + sparkVersion + " or greater is recommended for this version of SystemDS.");
        }
    }

    static String getMinimumRecommendedSparkVersionFromPom() {
        return MLContextUtil.getUniquePomProperty("spark.version");
    }

    static String getUniquePomProperty(String property) {
        File f = new File("pom.xml");
        if (!f.exists()) {
            throw new MLContextException("pom.xml not found");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(f);
            NodeList nodes = document.getElementsByTagName(property);
            int length = nodes.getLength();
            if (length == 0) {
                throw new MLContextException("Property not found in pom.xml");
            }
            Node node = nodes.item(0);
            String value = node.getTextContent();
            return value;
        }
        catch (Exception e) {
            throw new MLContextException("MLContextException when reading property '" + property + "' from pom.xml", e);
        }
    }

    public static void setDefaultConfig() {
        ConfigurationManager.setGlobalConfig(new DMLConfig());
    }

    public static void setConfig(String configFilePath) {
        try {
            DMLConfig config = new DMLConfig(configFilePath);
            ConfigurationManager.setGlobalConfig(config);
        }
        catch (ParseException e) {
            throw new MLContextException("Parse Exception when setting config", e);
        }
        catch (FileNotFoundException e) {
            throw new MLContextException("File not found (" + configFilePath + ") when setting config", e);
        }
    }

    public static void setCompilerConfig() {
        CompilerConfig compilerConfig = new CompilerConfig();
        compilerConfig.set(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS, true);
        compilerConfig.set(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS, false);
        compilerConfig.set(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS, false);
        compilerConfig.set(CompilerConfig.ConfigType.MLCONTEXT, true);
        ConfigurationManager.setGlobalConfig(compilerConfig);
    }

    public static void checkInputValueTypes(Map<String, Object> inputs) {
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            MLContextUtil.checkInputValueType(entry.getKey(), entry.getValue());
        }
    }

    public static void checkInputValueType(String name, Object value) {
        if (name == null) {
            throw new MLContextException("No input name supplied");
        }
        if (value == null) {
            throw new MLContextException("No input value supplied");
        }
        Object o = value;
        boolean supported = false;
        for (Class clazz : ALL_SUPPORTED_DATA_TYPES) {
            if (o.getClass().equals(clazz)) {
                supported = true;
                break;
            }
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new MLContextException("Input name (\"" + name + "\") value type not supported: " + o.getClass());
        }
    }

    public static void checkInputParameterType(String parameterName, Object parameterValue) {
        if (parameterName == null) {
            throw new MLContextException("No parameter name supplied");
        }
        if (parameterValue == null) {
            throw new MLContextException("No parameter value supplied");
        }
        if (!parameterName.startsWith("$")) {
            throw new MLContextException("Input parameter name must start with a $");
        }
        Object o = parameterValue;
        boolean supported = false;
        for (Class clazz : BASIC_DATA_TYPES) {
            if (o.getClass().equals(clazz)) {
                supported = true;
                break;
            }
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new MLContextException("Input parameter (\"" + parameterName + "\") value type not supported: " + o.getClass());
        }
    }

    public static boolean isBasicType(Object object) {
        for (Class clazz : BASIC_DATA_TYPES) {
            if (object.getClass().equals(clazz)) {
                return true;
            }
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static String getBasicTypeString(Object object) {
        if (!MLContextUtil.isBasicType(object)) {
            throw new MLContextException("Type (" + object.getClass() + ") not a recognized basic type");
        }
        Class<?> clazz = object.getClass();
        if (clazz.equals(Integer.class)) {
            return "int";
        }
        if (clazz.equals(Boolean.class)) {
            return "boolean";
        }
        if (clazz.equals(Double.class)) {
            return "double";
        }
        if (clazz.equals(String.class)) {
            return "string";
        }
        return null;
    }

    public static boolean isComplexType(Object object) {
        for (Class clazz : COMPLEX_DATA_TYPES) {
            if (object.getClass().equals(clazz)) {
                return true;
            }
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> convertInputParametersForParser(Map<String, Object> basicInputParameterMap) {
        if (basicInputParameterMap == null) {
            return null;
        }
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : basicInputParameterMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                throw new MLContextException("Input parameter value is null for: " + entry.getKey());
            }
            if (value instanceof Integer) {
                convertedMap.put(key, Integer.toString((Integer)value));
                continue;
            }
            if (value instanceof Boolean) {
                convertedMap.put(key, String.valueOf(value).toUpperCase());
                continue;
            }
            if (value instanceof Double) {
                convertedMap.put(key, Double.toString((Double)value));
                continue;
            }
            if (value instanceof String) {
                convertedMap.put(key, (String)value);
                continue;
            }
            throw new MLContextException("Incorrect type for input parameters");
        }
        return convertedMap;
    }

    public static Data convertInputType(String parameterName, Object parameterValue) {
        return MLContextUtil.convertInputType(parameterName, parameterValue, null);
    }

    public static Data convertInputType(String parameterName, Object parameterValue, Metadata metadata) {
        boolean hasFrameMetadata;
        String name = parameterName;
        Object value = parameterValue;
        boolean hasMetadata = metadata != null;
        boolean hasMatrixMetadata = hasMetadata && metadata instanceof MatrixMetadata;
        boolean bl = hasFrameMetadata = hasMetadata && metadata instanceof FrameMetadata;
        if (name == null) {
            throw new MLContextException("Input parameter name is null");
        }
        if (value == null) {
            throw new MLContextException("Input parameter value is null for: " + parameterName);
        }
        if (value instanceof JavaRDD) {
            JavaRDD javaRDD = (JavaRDD)value;
            if (hasMatrixMetadata) {
                MatrixMetadata matrixMetadata = (MatrixMetadata)metadata;
                if (matrixMetadata.getMatrixFormat() == MatrixFormat.IJV) {
                    return MLContextConversionUtil.javaRDDStringIJVToMatrixObject((JavaRDD<String>)javaRDD, matrixMetadata);
                }
                return MLContextConversionUtil.javaRDDStringCSVToMatrixObject((JavaRDD<String>)javaRDD, matrixMetadata);
            }
            if (hasFrameMetadata) {
                FrameMetadata frameMetadata = (FrameMetadata)metadata;
                if (frameMetadata.getFrameFormat() == FrameFormat.IJV) {
                    return MLContextConversionUtil.javaRDDStringIJVToFrameObject((JavaRDD<String>)javaRDD, frameMetadata);
                }
                return MLContextConversionUtil.javaRDDStringCSVToFrameObject((JavaRDD<String>)javaRDD, frameMetadata);
            }
            if (!hasMetadata) {
                String firstLine = (String)javaRDD.first();
                boolean isAllNumbers = MLContextUtil.isCSVLineAllNumbers(firstLine);
                if (isAllNumbers) {
                    return MLContextConversionUtil.javaRDDStringCSVToMatrixObject((JavaRDD<String>)javaRDD);
                }
                return MLContextConversionUtil.javaRDDStringCSVToFrameObject((JavaRDD<String>)javaRDD);
            }
        } else if (value instanceof RDD) {
            RDD rdd = (RDD)value;
            if (hasMatrixMetadata) {
                MatrixMetadata matrixMetadata = (MatrixMetadata)metadata;
                if (matrixMetadata.getMatrixFormat() == MatrixFormat.IJV) {
                    return MLContextConversionUtil.rddStringIJVToMatrixObject((RDD<String>)rdd, matrixMetadata);
                }
                return MLContextConversionUtil.rddStringCSVToMatrixObject((RDD<String>)rdd, matrixMetadata);
            }
            if (hasFrameMetadata) {
                FrameMetadata frameMetadata = (FrameMetadata)metadata;
                if (frameMetadata.getFrameFormat() == FrameFormat.IJV) {
                    return MLContextConversionUtil.rddStringIJVToFrameObject((RDD<String>)rdd, frameMetadata);
                }
                return MLContextConversionUtil.rddStringCSVToFrameObject((RDD<String>)rdd, frameMetadata);
            }
            if (!hasMetadata) {
                String firstLine = (String)rdd.first();
                boolean isAllNumbers = MLContextUtil.isCSVLineAllNumbers(firstLine);
                if (isAllNumbers) {
                    return MLContextConversionUtil.rddStringCSVToMatrixObject((RDD<String>)rdd);
                }
                return MLContextConversionUtil.rddStringCSVToFrameObject((RDD<String>)rdd);
            }
        } else {
            if (value instanceof MatrixBlock) {
                MatrixBlock matrixBlock = (MatrixBlock)value;
                return MLContextConversionUtil.matrixBlockToMatrixObject(name, matrixBlock, (MatrixMetadata)metadata);
            }
            if (value instanceof FrameBlock) {
                FrameBlock frameBlock = (FrameBlock)value;
                return MLContextConversionUtil.frameBlockToFrameObject(name, frameBlock, (FrameMetadata)metadata);
            }
            if (value instanceof Dataset) {
                Dataset dataFrame = (Dataset)value;
                dataFrame = MLUtils.convertVectorColumnsToML((Dataset)dataFrame, (String[])new String[0]);
                if (hasMatrixMetadata) {
                    return MLContextConversionUtil.dataFrameToMatrixObject((Dataset<Row>)dataFrame, (MatrixMetadata)metadata);
                }
                if (hasFrameMetadata) {
                    return MLContextConversionUtil.dataFrameToFrameObject((Dataset<Row>)dataFrame, (FrameMetadata)metadata);
                }
                if (!hasMetadata) {
                    boolean looksLikeMatrix = MLContextUtil.doesDataFrameLookLikeMatrix((Dataset<Row>)dataFrame);
                    if (looksLikeMatrix) {
                        return MLContextConversionUtil.dataFrameToMatrixObject((Dataset<Row>)dataFrame);
                    }
                    return MLContextConversionUtil.dataFrameToFrameObject((Dataset<Row>)dataFrame);
                }
            } else {
                if (value instanceof Matrix) {
                    Matrix matrix = (Matrix)value;
                    if (matrix.hasBinaryBlocks() && !matrix.hasMatrixObject()) {
                        if (metadata == null) {
                            metadata = matrix.getMatrixMetadata();
                        }
                        JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks = matrix.toBinaryBlocks();
                        return MLContextConversionUtil.binaryBlocksToMatrixObject(binaryBlocks, (MatrixMetadata)metadata);
                    }
                    return matrix.toMatrixObject();
                }
                if (value instanceof Frame) {
                    Frame frame = (Frame)value;
                    if (frame.hasBinaryBlocks() && !frame.hasFrameObject()) {
                        if (metadata == null) {
                            metadata = frame.getFrameMetadata();
                        }
                        JavaPairRDD<Long, FrameBlock> binaryBlocks = frame.toBinaryBlocks();
                        return MLContextConversionUtil.binaryBlocksToFrameObject(binaryBlocks, (FrameMetadata)metadata);
                    }
                    return frame.toFrameObject();
                }
                if (value instanceof double[][]) {
                    double[][] doubleMatrix = (double[][])value;
                    return MLContextConversionUtil.doubleMatrixToMatrixObject(name, doubleMatrix, (MatrixMetadata)metadata);
                }
                if (value instanceof URL) {
                    URL url = (URL)value;
                    return MLContextConversionUtil.urlToMatrixObject(url, (MatrixMetadata)metadata);
                }
                if (value instanceof Integer) {
                    return new IntObject(((Integer)value).intValue());
                }
                if (value instanceof Double) {
                    return new DoubleObject((Double)value);
                }
                if (value instanceof String) {
                    return new StringObject((String)value);
                }
                if (value instanceof Boolean) {
                    return new BooleanObject((Boolean)value);
                }
            }
        }
        return null;
    }

    public static boolean isCSVLineAllNumbers(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return false;
        }
        String[] parts = line.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            try {
                Double.parseDouble(part);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean doesDataFrameLookLikeMatrix(Dataset<Row> df) {
        StructType schema = df.schema();
        StructField[] fields = schema.fields();
        if (fields == null) {
            return true;
        }
        for (StructField field : fields) {
            DataType dataType = field.dataType();
            if (dataType == DataTypes.DoubleType || dataType == DataTypes.IntegerType || dataType == DataTypes.LongType || dataType instanceof VectorUDT || dataType instanceof org.apache.spark.mllib.linalg.VectorUDT) continue;
            return false;
        }
        return true;
    }

    public static String quotedString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'' || ch == '\"') {
                if (i > 0 && str.charAt(i - 1) != '\\') {
                    sb.append('\\');
                } else if (i == 0) {
                    sb.append('\\');
                }
            }
            sb.append(ch);
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String displayMap(String mapName, Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(mapName);
        sb.append(":\n");
        Set<String> keys = map.keySet();
        if (keys.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String key : keys) {
                sb.append("  [");
                sb.append(++count);
                sb.append("] ");
                sb.append(key);
                sb.append(": ");
                sb.append(map.get(key));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String displaySet(String setName, Set<String> set) {
        StringBuilder sb = new StringBuilder();
        sb.append(setName);
        sb.append(":\n");
        if (set.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String value : set) {
                sb.append("  [");
                sb.append(++count);
                sb.append("] ");
                sb.append(value);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String displaySymbolTable(String name, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":\n");
        sb.append(MLContextUtil.displaySymbolTable(symbolTable));
        return sb.toString();
    }

    public static String displaySymbolTable(LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = symbolTable.keySet();
        if (keys.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String key : keys) {
                sb.append("  [");
                sb.append(++count);
                sb.append("]");
                sb.append(" (");
                sb.append(MLContextUtil.determineOutputTypeAsString(symbolTable, key));
                sb.append(") ");
                sb.append(key);
                sb.append(": ");
                sb.append(symbolTable.get(key));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String determineOutputTypeAsString(LocalVariableMap symbolTable, String outputName) {
        Data data = symbolTable.get(outputName);
        if (data instanceof BooleanObject) {
            return "Boolean";
        }
        if (data instanceof DoubleObject) {
            return "Double";
        }
        if (data instanceof IntObject) {
            return "Long";
        }
        if (data instanceof StringObject) {
            return "String";
        }
        if (data instanceof MatrixObject) {
            return "Matrix";
        }
        if (data instanceof FrameObject) {
            return "Frame";
        }
        return "Unknown";
    }

    public static String displayInputs(String name, Map<String, Object> map, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":\n");
        Set<String> keys = map.keySet();
        if (keys.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String key : keys) {
                Object object = map.get(key);
                Class<?> clazz = object.getClass();
                String type = clazz.getSimpleName();
                if (object instanceof JavaRDD) {
                    type = "JavaRDD";
                } else if (object instanceof RDD) {
                    type = "RDD";
                }
                sb.append("  [");
                sb.append(++count);
                sb.append("]");
                sb.append(" (");
                sb.append(type);
                if (MLContextUtil.doesSymbolTableContainMatrixObject(symbolTable, key)) {
                    sb.append(" as Matrix");
                } else if (MLContextUtil.doesSymbolTableContainFrameObject(symbolTable, key)) {
                    sb.append(" as Frame");
                }
                sb.append(") ");
                sb.append(key);
                sb.append(": ");
                Object str = null;
                if (object instanceof MatrixBlock) {
                    MatrixBlock mb = (MatrixBlock)object;
                    str = "MatrixBlock [sparse? = " + mb.isInSparseFormat() + ", nonzeros = " + mb.getNonZeros() + ", size: " + mb.getNumRows() + " X " + mb.getNumColumns() + "]";
                } else {
                    str = object.toString();
                }
                str = StringUtils.abbreviate((String)str, (int)100);
                sb.append((String)str);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String displayOutputs(String name, Set<String> outputNames, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":\n");
        sb.append(MLContextUtil.displayOutputs(outputNames, symbolTable));
        return sb.toString();
    }

    public static String displayOutputs(Set<String> outputNames, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        if (outputNames.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String outputName : outputNames) {
                sb.append("  [");
                sb.append(++count);
                sb.append("] ");
                if (symbolTable.get(outputName) != null) {
                    sb.append("(");
                    sb.append(MLContextUtil.determineOutputTypeAsString(symbolTable, outputName));
                    sb.append(") ");
                }
                sb.append(outputName);
                if (symbolTable.get(outputName) != null) {
                    sb.append(": ");
                    sb.append(symbolTable.get(outputName));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String welcomeMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nWelcome to Apache SystemDS!\n");
        try {
            ProjectInfo info = ProjectInfo.getProjectInfo();
            if (info.version() != null) {
                sb.append("Version ");
                sb.append(info.version());
            }
        }
        catch (MLContextException mLContextException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static SparkContext getSparkContext(MLContext mlContext) {
        return mlContext.getSparkSession().sparkContext();
    }

    public static JavaSparkContext getJavaSparkContext(MLContext mlContext) {
        return new JavaSparkContext(mlContext.getSparkSession().sparkContext());
    }

    public static SparkContext getSparkContextFromProxy() {
        MLContext activeMLContext = MLContextProxy.getActiveMLContextForAPI();
        SparkContext sc = MLContextUtil.getSparkContext(activeMLContext);
        return sc;
    }

    public static JavaSparkContext getJavaSparkContextFromProxy() {
        MLContext activeMLContext = MLContextProxy.getActiveMLContextForAPI();
        JavaSparkContext jsc = MLContextUtil.getJavaSparkContext(activeMLContext);
        return jsc;
    }

    public static SparkSession getSparkSessionFromProxy() {
        return MLContextProxy.getActiveMLContextForAPI().getSparkSession();
    }

    public static boolean doesSymbolTableContainFrameObject(LocalVariableMap symbolTable, String variableName) {
        return symbolTable != null && symbolTable.keySet().contains(variableName) && symbolTable.get(variableName) instanceof FrameObject;
    }

    public static boolean doesSymbolTableContainMatrixObject(LocalVariableMap symbolTable, String variableName) {
        return symbolTable != null && symbolTable.keySet().contains(variableName) && symbolTable.get(variableName) instanceof MatrixObject;
    }

    public static void deleteRemoveVariableInstructions(Program progam) {
        HashMap<String, FunctionProgramBlock> fpbs = progam.getFunctionProgramBlocks();
        if (fpbs != null && !fpbs.isEmpty()) {
            for (Map.Entry entry : fpbs.entrySet()) {
                FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                for (ProgramBlock pb : fpb.getChildBlocks()) {
                    MLContextUtil.deleteRemoveVariableInstructions(pb);
                }
            }
        }
        for (ProgramBlock programBlock : progam.getProgramBlocks()) {
            MLContextUtil.deleteRemoveVariableInstructions(programBlock);
        }
    }

    private static void deleteRemoveVariableInstructions(ProgramBlock pb) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
            for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
        } else if (pb instanceof BasicProgramBlock) {
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            ArrayList<Instruction> instructions = bpb.getInstructions();
            MLContextUtil.deleteRemoveVariableInstructions(instructions);
        }
    }

    private static void deleteRemoveVariableInstructions(ArrayList<Instruction> instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction linst = instructions.get(i);
            if (!(linst instanceof VariableCPInstruction) || !((VariableCPInstruction)linst).isRemoveVariable()) continue;
            VariableCPInstruction varinst = (VariableCPInstruction)linst;
            instructions.remove(varinst);
            --i;
        }
    }
}

