/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.io.CompressedWriteBlock;
import org.apache.sysds.runtime.compress.io.DictWritable;
import org.apache.sysds.runtime.compress.lib.CLALibStack;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.CommonThreadPool;

public final class ReaderCompressed
extends MatrixReader {
    private final int k;

    public ReaderCompressed() {
        this.k = OptimizerUtils.getParallelBinaryReadParallelism();
    }

    public ReaderCompressed(int k) {
        this.k = k;
    }

    public static ReaderCompressed create() {
        int numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
        return new ReaderCompressed(numThreads);
    }

    public static MatrixBlock readCompressedMatrixFromHDFS(String fname, long rlen, long clen, int blen) throws IOException {
        return ReaderCompressed.create().readMatrixFromHDFS(fname, rlen, clen, blen, 100L);
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        return this.readCompressedMatrix(fname, job, fs, (int)rlen, (int)clen, blen);
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        throw new NotImplementedException("Not implemented reading compressedMatrix from input stream");
    }

    private MatrixBlock readCompressedMatrix(String fname, JobConf job, FileSystem fs, int rlen, int clen, int blen) throws IOException {
        if (this.k > 1) {
            return this.readCompressedMatrixParallel(fname, job, fs, rlen, clen, blen);
        }
        return this.readCompressedMatrixSingleThread(fname, job, fs, rlen, clen, blen);
    }

    private MatrixBlock readCompressedMatrixParallel(String fname, JobConf job, FileSystem fs, int rlen, int clen, int blen) throws IOException {
        HashMap<MatrixIndexes, MatrixBlock> data = new HashMap<MatrixIndexes, MatrixBlock>();
        HashMap<Integer, List<IDictionary>> dicts = null;
        ExecutorService pool = CommonThreadPool.get(this.k);
        try {
            ArrayList<Future<Map>> rt = new ArrayList<Future<Map>>();
            ArrayList<Future<Map>> dt = new ArrayList<Future<Map>>();
            Path[] pathArray = IOUtilFunctions.getSequenceFilePaths(fs, new Path(fname));
            int n = pathArray.length;
            for (int i = 0; i < n; ++i) {
                Path path;
                Path sp = path = pathArray[i];
                rt.add(pool.submit(() -> ReaderCompressed.readColumnGroups(sp, job)));
            }
            Path dictPath = new Path(fname + ".dict");
            boolean dictExists = fs.exists(dictPath);
            if (dictExists) {
                dicts = new HashMap<Integer, List<IDictionary>>();
                Path[] pathArray2 = IOUtilFunctions.getSequenceFilePaths(fs, dictPath);
                int n2 = pathArray2.length;
                for (int i = 0; i < n2; ++i) {
                    Path subPath2;
                    Path sp = subPath2 = pathArray2[i];
                    dt.add(pool.submit(() -> ReaderCompressed.readDictionaries(sp, job)));
                }
            }
            for (Future future : rt) {
                data.putAll((Map)future.get());
            }
            if (dictExists && dicts != null) {
                for (Future future : dt) {
                    dicts.putAll((Map)future.get());
                }
            }
            MatrixBlock matrixBlock = CLALibStack.combine(data, dicts, rlen, clen, blen, this.k);
            return matrixBlock;
        }
        catch (Exception e) {
            throw new IOException("failed parallel reading ", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private MatrixBlock readCompressedMatrixSingleThread(String fname, JobConf job, FileSystem fs, int rlen, int clen, int blen) throws IOException {
        HashMap<MatrixIndexes, MatrixBlock> data = new HashMap<MatrixIndexes, MatrixBlock>();
        for (Path subPath : IOUtilFunctions.getSequenceFilePaths(fs, new Path(fname))) {
            data.putAll(ReaderCompressed.readColumnGroups(subPath, job));
        }
        Path dictPath = new Path(fname + ".dict");
        HashMap<Integer, List<IDictionary>> dicts = null;
        if (fs.exists(dictPath)) {
            dicts = new HashMap<Integer, List<IDictionary>>();
            for (Path subPath : IOUtilFunctions.getSequenceFilePaths(fs, dictPath)) {
                dicts.putAll(ReaderCompressed.readDictionaries(subPath, job));
            }
        }
        if (data.containsValue(null)) {
            throw new DMLCompressionException("Invalid read data contains null:");
        }
        return CLALibStack.combine(data, dicts, this.k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<MatrixIndexes, MatrixBlock> readColumnGroups(Path path, JobConf job) throws IOException {
        HashMap<MatrixIndexes, MatrixBlock> data = new HashMap<MatrixIndexes, MatrixBlock>();
        SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
        try {
            MatrixIndexes key = new MatrixIndexes();
            CompressedWriteBlock value = new CompressedWriteBlock();
            while (reader.next((Writable)key, (Writable)value)) {
                MatrixBlock g = value.get();
                if (g instanceof CompressedMatrixBlock) {
                    data.put(key, g);
                } else if (g.isEmpty()) {
                    data.put(key, CompressedMatrixBlockFactory.createConstant(g.getNumRows(), g.getNumColumns(), 0.0));
                } else {
                    data.put(key, g);
                }
                key = new MatrixIndexes();
                value = new CompressedWriteBlock();
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)reader);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, List<IDictionary>> readDictionaries(Path path, JobConf job) throws IOException {
        HashMap<Integer, List<IDictionary>> data = new HashMap<Integer, List<IDictionary>>();
        SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
        try {
            DictWritable.K key = new DictWritable.K(0);
            DictWritable value = new DictWritable(null);
            while (reader.next((Writable)key, (Writable)value)) {
                data.put(key.id, value.dicts);
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)reader);
        }
        return data;
    }
}

