/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.estim;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.estim.MMNode;
import org.apache.sysds.hops.estim.SparsityEstimator;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class EstimatorBasicWorst
extends SparsityEstimator {
    @Override
    public DataCharacteristics estim(MMNode root) {
        DataCharacteristics mc1;
        if (!root.getLeft().isLeaf()) {
            this.estim(root.getLeft());
        }
        if (root.getRight() != null && !root.getRight().isLeaf()) {
            this.estim(root.getRight());
        }
        DataCharacteristics dataCharacteristics = mc1 = !root.getLeft().isLeaf() ? this.estim(root.getLeft()) : root.getLeft().getDataCharacteristics();
        DataCharacteristics mc2 = root.getRight() == null ? null : (!root.getRight().isLeaf() ? this.estim(root.getRight()) : root.getRight().getDataCharacteristics());
        return root.setDataCharacteristics(this.estimIntern(mc1, mc2, root.getOp()));
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2) {
        return this.estim(m1, m2, SparsityEstimator.OpCode.MM);
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2, SparsityEstimator.OpCode op) {
        return this.estimIntern(m1.getDataCharacteristics(), m2.getDataCharacteristics(), op).getSparsity();
    }

    @Override
    public double estim(MatrixBlock m, SparsityEstimator.OpCode op) {
        return this.estimIntern(m.getDataCharacteristics(), null, op).getSparsity();
    }

    private DataCharacteristics estimIntern(DataCharacteristics mc1, DataCharacteristics mc2, SparsityEstimator.OpCode op) {
        switch (op) {
            case MM: {
                return new MatrixCharacteristics(mc1.getRows(), mc2.getCols(), OptimizerUtils.getMatMultNnz(mc1.getSparsity(), mc2.getSparsity(), mc1.getRows(), mc1.getCols(), mc2.getCols(), true));
            }
            case MULT: {
                return new MatrixCharacteristics(mc1.getRows(), mc1.getCols(), OptimizerUtils.getNnz(mc1.getRows(), mc1.getCols(), Math.min(mc1.getSparsity(), mc2.getSparsity())));
            }
            case PLUS: {
                return new MatrixCharacteristics(mc1.getRows(), mc1.getCols(), OptimizerUtils.getNnz(mc1.getRows(), mc1.getCols(), Math.min(mc1.getSparsity() + mc2.getSparsity(), 1.0)));
            }
            case EQZERO: 
            case DIAG: 
            case CBIND: 
            case RBIND: 
            case NEQZERO: 
            case TRANS: 
            case RESHAPE: {
                return this.estimExactMetaData(mc1, mc2, op);
            }
        }
        throw new NotImplementedException();
    }
}

