/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.lops.MapMultChain;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.lib.CLALibAggTernaryOp;
import org.apache.sysds.runtime.compress.lib.CLALibMerge;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.data.Block;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.DenseBlockFP64DEDUP;
import org.apache.sysds.runtime.data.DenseBlockFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCOO;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockFactory;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.functionobjects.CTable;
import org.apache.sysds.runtime.functionobjects.DiagIndex;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.FunctionObject;
import org.apache.sysds.runtime.functionobjects.IfElse;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.PlusMultiply;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceCol;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.functionobjects.RevIndex;
import org.apache.sysds.runtime.functionobjects.SortIndex;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.functionobjects.TernaryValueFunction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysds.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysds.runtime.matrix.data.LibMatrixDenseToSparse;
import org.apache.sysds.runtime.matrix.data.LibMatrixEquals;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.LibMatrixNative;
import org.apache.sysds.runtime.matrix.data.LibMatrixOuterAgg;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.LibMatrixSparseToDense;
import org.apache.sysds.runtime.matrix.data.LibMatrixTercell;
import org.apache.sysds.runtime.matrix.data.MatrixBlockDataInput;
import org.apache.sysds.runtime.matrix.data.MatrixBlockDataOutput;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.FastBufferedDataInputStream;
import org.apache.sysds.runtime.util.FastBufferedDataOutputStream;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.NativeHelper;

public class MatrixBlock
extends MatrixValue
implements CacheBlock<MatrixBlock>,
Externalizable {
    protected static final Log LOG = LogFactory.getLog((String)MatrixBlock.class.getName());
    private static final long serialVersionUID = 7319972089143154056L;
    public static final double SPARSITY_TURN_POINT = 0.4;
    public static final double ULTRA_SPARSITY_TURN_POINT = 4.0E-5;
    public static final double ULTRA_SPARSITY_TURN_POINT2 = 4.0E-4;
    public static final int ULTRA_SPARSE_BLOCK_NNZ = 40;
    public static final SparseBlock.Type DEFAULT_SPARSEBLOCK = SparseBlock.Type.MCSR;
    public static final SparseBlock.Type DEFAULT_INPLACE_SPARSEBLOCK = SparseBlock.Type.CSR;
    public static final double MAX_SHALLOW_SERIALIZE_OVERHEAD = 2.0;
    public static final boolean CONVERT_MCSR_TO_CSR_ON_DEEP_SERIALIZE = true;
    public static final int HEADER_SIZE = 9;
    protected int rlen = -1;
    protected int clen = -1;
    protected boolean sparse = true;
    protected long nonZeros = 0L;
    protected DenseBlock denseBlock = null;
    protected SparseBlock sparseBlock = null;
    protected int estimatedNNzsPerRow = -1;

    public MatrixBlock() {
        this(0, 0, true, -1L);
    }

    public MatrixBlock(int rl, int cl, boolean sp) {
        this(rl, cl, sp, -1L);
    }

    public MatrixBlock(int rl, int cl, long estnnz) {
        this(rl, cl, MatrixBlock.evalSparseFormatInMemory(rl, cl, estnnz), estnnz);
    }

    public MatrixBlock(int rl, int cl, boolean sp, long estnnz) {
        this.reset(rl, cl, sp, estnnz, 0.0);
    }

    public MatrixBlock(int rl, int cl, boolean sp, long estnnz, boolean dedup) {
        this.reset(rl, cl, sp, estnnz, 0.0, dedup);
    }

    public MatrixBlock(MatrixBlock that) {
        this.copy(that);
    }

    public MatrixBlock(MatrixBlock that, boolean sp) {
        this.copy(that, sp);
    }

    public MatrixBlock(double val) {
        this.reset(1, 1, false, 1L, val);
    }

    public MatrixBlock(int rl, int cl, double val) {
        this.reset(rl, cl, false, (long)rl * (long)cl, val);
    }

    public MatrixBlock(int rl, int cl, long nnz, SparseBlock sblock) {
        this(rl, cl, true, nnz);
        this.nonZeros = nnz;
        this.sparseBlock = sblock;
    }

    public MatrixBlock(MatrixBlock that, SparseBlock.Type stype, boolean deep) {
        this(that.rlen, that.clen, that.sparse);
        if (!that.isInSparseFormat()) {
            throw new RuntimeException("Sparse matrix block expected.");
        }
        if (!that.isEmptyBlock(false)) {
            this.nonZeros = that.nonZeros;
            this.estimatedNNzsPerRow = that.estimatedNNzsPerRow;
            this.sparseBlock = SparseBlockFactory.copySparseBlock(stype, that.sparseBlock, deep);
        }
    }

    public MatrixBlock(int rl, int cl, DenseBlock dBlock) {
        this.rlen = rl;
        this.clen = cl;
        this.sparse = false;
        this.denseBlock = dBlock;
    }

    public MatrixBlock(int rl, int cl, double[] vals) {
        this.rlen = rl;
        this.clen = cl;
        this.sparse = false;
        this.denseBlock = new DenseBlockFP64(new int[]{rl, cl}, vals);
        this.nonZeros = vals.length;
    }

    protected MatrixBlock(boolean empty) {
    }

    @Override
    public final void reset() {
        this.reset(this.rlen, this.clen, this.sparse, -1L, 0.0);
    }

    @Override
    public final void reset(int rl, int cl) {
        this.reset(rl, cl, this.sparse, -1L, 0.0);
    }

    public final void reset(int rl, int cl, long estnnz) {
        this.reset(rl, cl, MatrixBlock.evalSparseFormatInMemory(rl, cl, estnnz), estnnz, 0.0);
    }

    @Override
    public final void reset(int rl, int cl, boolean sp) {
        this.reset(rl, cl, sp, -1L, 0.0);
    }

    @Override
    public final void reset(int rl, int cl, boolean sp, long estnnz) {
        this.reset(rl, cl, sp, estnnz, 0.0);
    }

    @Override
    public final void reset(int rl, int cl, double val) {
        this.reset(rl, cl, false, -1L, val);
    }

    public void reset(int rl, int cl, boolean sp, long estnnz, double val) {
        if (rl < 0 || cl < 0) {
            throw new RuntimeException("Invalid block dimensions: " + rl + " " + cl);
        }
        this.rlen = rl;
        this.clen = cl;
        this.sparse = val == 0.0 ? sp : false;
        this.nonZeros = val == 0.0 ? 0L : (long)rl * (long)cl;
        int n = this.estimatedNNzsPerRow = estnnz < 0L || !this.sparse ? -1 : (int)Math.ceil((double)estnnz / (double)this.rlen);
        if (this.sparse) {
            this.resetSparse();
        } else {
            this.resetDense(val);
        }
    }

    public void reset(int rl, int cl, boolean sp, long estnnz, double val, boolean dedup) {
        if (rl < 0 || cl < 0) {
            throw new RuntimeException("Invalid block dimensions: " + rl + " " + cl);
        }
        this.rlen = rl;
        this.clen = cl;
        this.sparse = val == 0.0 ? sp : false;
        this.nonZeros = val == 0.0 ? 0L : (long)rl * (long)cl;
        int n = this.estimatedNNzsPerRow = estnnz < 0L || !this.sparse ? -1 : (int)Math.ceil((double)estnnz / (double)this.rlen);
        if (this.sparse) {
            this.resetSparse();
        } else {
            this.resetDense(val, dedup);
        }
    }

    private void resetSparse() {
        if (this.sparseBlock == null) {
            return;
        }
        this.sparseBlock.reset(this.estimatedNNzsPerRow, this.clen);
    }

    private void resetDense(double val) {
        if (this.denseBlock != null) {
            this.denseBlock.reset(this.rlen, this.clen, val);
        } else if (val != 0.0) {
            this.allocateDenseBlock(false);
            this.denseBlock.set(val);
        }
    }

    private void resetDense(double val, boolean dedup) {
        if (this.denseBlock != null) {
            this.denseBlock.reset(this.rlen, this.clen, val);
        } else if (val != 0.0) {
            this.allocateDenseBlock(false, dedup);
            this.denseBlock.set(val);
        }
    }

    public void init(double[][] arr, int r, int c) {
        if (this.sparse) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() can be invoked only on matrices with dense representation.");
        }
        if (r * c > this.rlen * this.clen) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() invoked with too large dimensions (" + r + "," + c + ") vs (" + this.rlen + "," + this.clen + ")");
        }
        this.allocateDenseBlock();
        DenseBlock db = this.getDenseBlock();
        for (int i = 0; i < r; ++i) {
            System.arraycopy(arr[i], 0, db.values(i), db.pos(i), arr[i].length);
        }
        this.recomputeNonZeros();
    }

    public void init(double[] arr, int r, int c) {
        if (this.sparse) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() can be invoked only on matrices with dense representation.");
        }
        if (r * c > this.rlen * this.clen) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() invoked with too large dimensions (" + r + "," + c + ") vs (" + this.rlen + "," + this.clen + ")");
        }
        this.allocateDenseBlock();
        System.arraycopy(arr, 0, this.getDenseBlockValues(), 0, arr.length);
        this.recomputeNonZeros();
    }

    public boolean isAllocated() {
        return this.sparse ? this.sparseBlock != null : this.denseBlock != null;
    }

    public final MatrixBlock allocateDenseBlock() {
        this.allocateDenseBlock(true);
        return this;
    }

    public Future<MatrixBlock> allocateBlockAsync() {
        ExecutorService pool = CommonThreadPool.get();
        return pool != null ? pool.submit(() -> this.allocateBlock()) : ConcurrentUtils.constantFuture((Object)this.allocateBlock());
    }

    public final MatrixBlock allocateBlock() {
        if (this.sparse) {
            this.allocateSparseRowsBlock();
        } else {
            this.allocateDenseBlock();
        }
        return this;
    }

    public boolean allocateDenseBlock(boolean clearNNZ) {
        return this.allocateDenseBlock(clearNNZ, false);
    }

    public boolean allocateDenseBlock(boolean clearNNZ, boolean containsDuplicates) {
        long limit = (long)this.rlen * (long)this.clen;
        if (clearNNZ) {
            this.nonZeros = 0L;
        }
        this.sparse = false;
        if (this.denseBlock == null) {
            this.denseBlock = DenseBlockFactory.createDenseBlock(this.rlen, this.clen, containsDuplicates);
            return true;
        }
        if (containsDuplicates && !(this.denseBlock instanceof DenseBlockFP64DEDUP)) {
            this.denseBlock = DenseBlockFactory.createDenseBlock(this.rlen, this.clen, true);
            return true;
        }
        if (this.denseBlock.capacity() < limit) {
            this.denseBlock.reset(this.rlen, this.clen);
            return true;
        }
        return false;
    }

    public final boolean allocateSparseRowsBlock() {
        return this.allocateSparseRowsBlock(true);
    }

    public boolean allocateSparseRowsBlock(boolean clearNNZ) {
        boolean reset;
        boolean bl = reset = this.sparseBlock == null || this.sparseBlock.numRows() < this.rlen;
        if (reset) {
            this.sparseBlock = SparseBlockFactory.createSparseBlock(DEFAULT_SPARSEBLOCK, this.rlen);
        }
        if (clearNNZ) {
            this.nonZeros = 0L;
        }
        return reset;
    }

    public void allocateAndResetSparseBlock(boolean clearNNZ, SparseBlock.Type stype) {
        if (this.sparseBlock == null || this.sparseBlock.numRows() < this.rlen || !SparseBlockFactory.isSparseBlockType(this.sparseBlock, stype)) {
            this.sparseBlock = SparseBlockFactory.createSparseBlock(stype, this.rlen);
        } else {
            this.sparseBlock.reset(this.estimatedNNzsPerRow, this.clen);
        }
        if (clearNNZ) {
            this.nonZeros = 0L;
        }
    }

    public final void allocateDenseBlockUnsafe(int rl, int cl) {
        this.sparse = false;
        this.rlen = rl;
        this.clen = cl;
        this.allocateDenseBlock();
    }

    public final void cleanupBlock(boolean dense, boolean sparse) {
        if (dense) {
            this.denseBlock = null;
        }
        if (sparse) {
            this.sparseBlock = null;
        }
    }

    @Override
    public final int getNumRows() {
        return this.rlen;
    }

    public final void setNumRows(int r) {
        this.rlen = r;
    }

    @Override
    public final int getNumColumns() {
        return this.clen;
    }

    public final void setNumColumns(int c) {
        this.clen = c;
    }

    @Override
    public final long getNonZeros() {
        return this.nonZeros;
    }

    public final long setNonZeros(long nnz) {
        this.nonZeros = nnz;
        return this.nonZeros;
    }

    public final long setAllNonZeros() {
        this.nonZeros = this.getLength();
        return this.nonZeros;
    }

    public final double getSparsity() {
        return OptimizerUtils.getSparsity(this.rlen, this.clen, this.nonZeros);
    }

    @Override
    public final DataCharacteristics getDataCharacteristics() {
        return new MatrixCharacteristics(this.rlen, this.clen, -1, this.nonZeros);
    }

    public final boolean isVector() {
        return this.rlen == 1 || this.clen == 1;
    }

    public final long getLength() {
        return (long)this.rlen * (long)this.clen;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmptyBlock(false);
    }

    public final boolean isEmptyBlock() {
        return this.isEmptyBlock(true);
    }

    public boolean isEmptyBlock(boolean safe) {
        boolean ret;
        boolean bl = ret = this.sparse && this.sparseBlock == null || !this.sparse && this.denseBlock == null;
        if (this.nonZeros <= 0L) {
            if (safe) {
                this.recomputeNonZeros();
            }
            ret = this.nonZeros == 0L;
        }
        return ret;
    }

    public DenseBlock getDenseBlock() {
        return this.denseBlock;
    }

    public void setDenseBlock(DenseBlock dblock) {
        this.denseBlock = dblock;
    }

    public double[] getDenseBlockValues() {
        if (this.denseBlock != null && this.denseBlock.numBlocks() > 1) {
            throw new RuntimeException("Large dense in-memory block (with numblocks=" + this.denseBlock.numBlocks() + ") allocated but operation access to first block only, which might cause incorrect results.");
        }
        return this.denseBlock != null ? this.denseBlock.valuesAt(0) : null;
    }

    public SparseBlock getSparseBlock() {
        return this.sparseBlock;
    }

    public void setSparseBlock(SparseBlock sblock) {
        this.sparseBlock = sblock;
    }

    public Iterator<IJV> getSparseBlockIterator() {
        if (!this.sparse) {
            throw new RuntimeException("getSparseBlockInterator should not be called for dense format");
        }
        if (this.sparseBlock == null) {
            return new ArrayList().iterator();
        }
        if (this.rlen == this.sparseBlock.numRows()) {
            return this.sparseBlock.getIterator();
        }
        return this.sparseBlock.getIterator(this.rlen);
    }

    public Iterator<IJV> getSparseBlockIterator(int rl, int ru) {
        if (!this.sparse) {
            throw new RuntimeException("getSparseBlockInterator should not be called for dense format");
        }
        if (this.sparseBlock == null) {
            return Collections.emptyListIterator();
        }
        return this.sparseBlock.getIterator(rl, ru);
    }

    @Override
    public double getValue(int r, int c) {
        if (r >= this.rlen || c >= this.clen) {
            throw new RuntimeException("indexes (" + r + "," + c + ") out of range (" + this.rlen + "," + this.clen + ")");
        }
        return this.quickGetValue(r, c);
    }

    @Override
    public void setValue(int r, int c, double v) {
        if (r >= this.rlen || c >= this.clen) {
            throw new RuntimeException("indexes (" + r + "," + c + ") out of range (" + this.rlen + "," + this.clen + ")");
        }
        this.quickSetValue(r, c, v);
    }

    public double quickGetValue(int r, int c) {
        if (this.sparse && this.sparseBlock != null) {
            return this.sparseBlock.get(r, c);
        }
        if (!this.sparse && this.denseBlock != null) {
            return this.denseBlock.get(r, c);
        }
        return 0.0;
    }

    public void quickSetValue(int r, int c, double v) {
        if (this.sparse) {
            if ((this.sparseBlock == null || this.sparseBlock.isEmpty(r)) && v == 0.0) {
                return;
            }
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.allocate(r, this.estimatedNNzsPerRow, this.clen);
            if (this.sparseBlock.set(r, c, v)) {
                this.nonZeros += v != 0.0 ? 1L : -1L;
            }
        } else {
            if (this.denseBlock == null && v == 0.0) {
                return;
            }
            this.allocateDenseBlock(false);
            if (this.denseBlock.get(r, c) == 0.0) {
                ++this.nonZeros;
            }
            this.denseBlock.set(r, c, v);
            if (v == 0.0) {
                --this.nonZeros;
            }
        }
    }

    public void quickSetRow(int r, double[] values) {
        if (this.sparse) {
            throw new NotImplementedException();
        }
        this.allocateDenseBlock(false);
        this.nonZeros += (long)(UtilFunctions.computeNnz(values, 0, values.length) - this.denseBlock.countNonZeros(r));
        this.denseBlock.set(r, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double quickGetValueThreadSafe(int r, int c) {
        if (this.sparse) {
            if (!(this.sparseBlock instanceof SparseBlockMCSR)) {
                throw new RuntimeException("Only MCSR Blocks are supported for Multithreaded sparse get.");
            }
            SparseRow sparseRow = this.sparseBlock.get(r);
            synchronized (sparseRow) {
                return this.sparseBlock.get(r, c);
            }
        }
        return this.denseBlock.get(r, c);
    }

    public double getValueDenseUnsafe(int r, int c) {
        if (this.denseBlock == null) {
            return 0.0;
        }
        return this.denseBlock.get(r, c);
    }

    public boolean containsValue(double pattern) {
        if (this.isEmptyBlock(true)) {
            return pattern == 0.0;
        }
        if (this.nonZeros < this.getLength() && pattern == 0.0) {
            return true;
        }
        return this.isInSparseFormat() ? this.getSparseBlock().contains(pattern) : this.getDenseBlock().contains(pattern);
    }

    public List<Integer> containsVector(MatrixBlock pattern, boolean earlyAbort) {
        if (this.clen != pattern.clen || pattern.rlen != 1) {
            throw new DMLRuntimeException("contains only supports pattern row vectors of matching number of columns: " + this.getDataCharacteristics() + " vs " + pattern.getDataCharacteristics());
        }
        double[] dpattern = DataConverter.convertToDoubleVector(pattern, false, false);
        return this.isInSparseFormat() ? this.getSparseBlock().contains(dpattern, earlyAbort) : this.getDenseBlock().contains(dpattern, earlyAbort);
    }

    public void appendValue(int r, int c, double v) {
        if (v == 0.0) {
            return;
        }
        if (!this.sparse) {
            this.allocateDenseBlock(false);
            this.denseBlock.set(r, c, v);
            ++this.nonZeros;
        } else {
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.allocate(r, this.estimatedNNzsPerRow, this.clen);
            this.sparseBlock.append(r, c, v);
            ++this.nonZeros;
        }
    }

    public void appendValuePlain(int r, int c, double v) {
        if (v == 0.0) {
            return;
        }
        if (!this.sparse) {
            this.allocateDenseBlock(false);
            this.denseBlock.set(r, c, v);
        } else {
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.allocate(r, this.estimatedNNzsPerRow, this.clen);
            this.sparseBlock.append(r, c, v);
        }
    }

    public void appendRow(int r, SparseRow row) {
        this.appendRow(r, row, true);
    }

    public void appendRow(int r, SparseRow row, boolean deep) {
        if (row == null) {
            return;
        }
        if (this.sparse) {
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.set(r, row, deep);
            this.nonZeros += (long)row.size();
        } else {
            int[] cols = row.indexes();
            double[] vals = row.values();
            for (int i = 0; i < row.size(); ++i) {
                this.quickSetValue(r, cols[i], vals[i]);
            }
        }
    }

    public void appendToSparse(MatrixBlock that, int rowoffset, int coloffset) {
        this.appendToSparse(that, rowoffset, coloffset, true);
    }

    private void appendToSparse(MatrixBlock that, int rowoffset, int coloffset, boolean deep) {
        if (that == null || that.isEmptyBlock(false)) {
            return;
        }
        this.allocateSparseRowsBlock(false);
        int m2 = that.rlen;
        for (int i = 0; i < m2; ++i) {
            this.appendRowToSparse(this.sparseBlock, that, i, rowoffset, coloffset, deep);
        }
    }

    public void appendRowToSparse(SparseBlock dest, MatrixBlock src, int i, int rowoffset, int coloffset, boolean deep) {
        if (src.sparse) {
            SparseBlock a = src.sparseBlock;
            if (a == null || a.isEmpty(i)) {
                return;
            }
            int aix = rowoffset + i;
            if (!dest.isAllocated(aix) && coloffset == 0) {
                boolean ldeep = deep && a instanceof SparseBlockMCSR;
                dest.set(aix, a.get(i), ldeep);
            } else {
                int pos = a.pos(i);
                int len = a.size(i);
                int[] ix = a.indexes(i);
                double[] val = a.values(i);
                if (this.estimatedNNzsPerRow > 0) {
                    dest.allocate(aix, Math.max(this.estimatedNNzsPerRow, dest.size(aix) + len), this.clen);
                } else {
                    dest.allocate(aix, dest.size(aix) + len);
                }
                for (int j = pos; j < pos + len; ++j) {
                    dest.append(aix, coloffset + ix[j], val[j]);
                }
            }
        } else {
            DenseBlock a = src.getDenseBlock();
            int n2 = src.clen;
            double[] avals = a.values(i);
            int aix = a.pos(i);
            int cix = rowoffset + i;
            for (int j = 0; j < n2; ++j) {
                double bval = avals[aix + j];
                if (bval == 0.0) continue;
                dest.allocate(cix, this.estimatedNNzsPerRow, this.clen);
                dest.append(cix, coloffset + j, bval);
            }
        }
    }

    public void sortSparseRows() {
        if (!this.sparse || this.sparseBlock == null) {
            return;
        }
        this.sparseBlock.sort();
    }

    public void sortSparseRows(int rl, int ru) {
        if (!this.sparse || this.sparseBlock == null) {
            return;
        }
        for (int i = rl; i < ru; ++i) {
            if (this.sparseBlock.isEmpty(i)) continue;
            this.sparseBlock.sort(i);
        }
    }

    public double minNonZero() {
        if (this.isEmptyBlock()) {
            return -1.0;
        }
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double val = this.quickGetValue(i, j);
                if (val == 0.0) continue;
                min = Math.min(min, val);
            }
        }
        return min;
    }

    public double prod() {
        MatrixBlock out = new MatrixBlock(1, 1, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, InstructionUtils.parseBasicAggregateUnaryOperator("ua*", 1));
        return out.quickGetValue(0, 0);
    }

    public double mean() {
        return this.mean(1);
    }

    public double mean(int k) {
        MatrixBlock out = new MatrixBlock(1, 3, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, InstructionUtils.parseBasicAggregateUnaryOperator("uamean", k));
        return out.quickGetValue(0, 0);
    }

    public double min() {
        return this.min(1);
    }

    public double min(int k) {
        MatrixBlock out = new MatrixBlock(1, 1, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, InstructionUtils.parseBasicAggregateUnaryOperator("uamin", k));
        return out.quickGetValue(0, 0);
    }

    public final MatrixBlock colMin() {
        return this.colMin(1);
    }

    public final MatrixBlock colMin(int k) {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uacmin", k);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public final MatrixBlock colMax() {
        return this.colMax(1);
    }

    public final MatrixBlock colMax(int k) {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uacmax", k);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public double max() {
        return this.max(1).quickGetValue(0, 0);
    }

    public MatrixBlock max(int k) {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uamax", k);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public double sum() {
        KahanPlus kplus = KahanPlus.getKahanPlusFnObject();
        return this.sumWithFn(kplus);
    }

    public MatrixBlock sum(int k) {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uak+", k);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public MatrixBlock colSum() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uack+", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public final MatrixBlock rowSum() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uark+", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public final MatrixBlock rowSum(int k) {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uark+", k);
        return this.aggregateUnaryOperations(op, null, 1000, null, true);
    }

    public double sumSq() {
        KahanPlusSq kplusSq = KahanPlusSq.getKahanPlusSqFnObject();
        return this.sumWithFn(kplusSq);
    }

    private double sumWithFn(KahanFunction kfunc) {
        Types.CorrectionLocationType corrLoc = Types.CorrectionLocationType.LASTCOLUMN;
        ReduceAll reduceAllObj = ReduceAll.getReduceAllFnObject();
        AggregateOperator aop = new AggregateOperator(0.0, kfunc, corrLoc);
        AggregateUnaryOperator auop = new AggregateUnaryOperator(aop, reduceAllObj);
        MatrixBlock out = new MatrixBlock(1, 2, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, auop);
        return out.quickGetValue(0, 0);
    }

    @Override
    public boolean isInSparseFormat() {
        return this.sparse;
    }

    public boolean isUltraSparse() {
        return this.isUltraSparse(true);
    }

    public boolean isUltraSparse(boolean checkNnz) {
        double sp = (double)this.nonZeros / (double)this.rlen / (double)this.clen;
        return this.sparse && sp < 4.0E-5 && (!checkNnz || this.nonZeros < 40L);
    }

    public boolean isSparsePermutationMatrix() {
        if (!this.isInSparseFormat() || this.nonZeros > (long)this.rlen) {
            return false;
        }
        SparseBlock sblock = this.getSparseBlock();
        boolean isPM = sblock != null;
        int i = 0;
        while (i < this.rlen & isPM) {
            isPM &= sblock.isEmpty(i) || sblock.size(i) == 1;
            ++i;
        }
        return isPM;
    }

    private boolean isUltraSparseSerialize(boolean sparseDst) {
        return this.nonZeros < (long)this.rlen && sparseDst;
    }

    public boolean evalSparseFormatInMemory() {
        return this.evalSparseFormatInMemory(false);
    }

    public boolean evalSparseFormatInMemory(boolean allowCSR) {
        if (this.nonZeros <= 0L) {
            this.recomputeNonZeros();
        }
        return MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, this.nonZeros, allowCSR);
    }

    public boolean evalSparseFormatOnDisk() {
        if (this.nonZeros <= 0L) {
            this.recomputeNonZeros();
        }
        return MatrixBlock.evalSparseFormatOnDisk(this.rlen, this.clen, this.nonZeros);
    }

    public final void examSparsity() {
        this.examSparsity(true, 1);
    }

    public final void examSparsity(int k) {
        this.examSparsity(true, k);
    }

    public final void examSparsity(boolean allowCSR) {
        this.examSparsity(allowCSR, 1);
    }

    public void examSparsity(boolean allowCSR, int k) {
        boolean sparseDst = this.evalSparseFormatInMemory(allowCSR);
        if (this.isEmptyBlock(false)) {
            this.cleanupBlock(true, true);
        }
        if (this.sparse && !sparseDst) {
            this.sparseToDense(k);
        } else if (!this.sparse && sparseDst) {
            this.denseToSparse(allowCSR, k);
        }
    }

    public static boolean evalSparseFormatInMemory(DataCharacteristics dc) {
        return MatrixBlock.evalSparseFormatInMemory(dc.getRows(), dc.getCols(), dc.getNonZeros());
    }

    public static boolean evalSparseFormatInMemory(long nrows, long ncols, long nnz) {
        return MatrixBlock.evalSparseFormatInMemory(nrows, ncols, nnz, false);
    }

    public static boolean evalSparseFormatInMemory(long nrows, long ncols, long nnz, boolean allowCSR) {
        double lsparsity = (double)nnz / (double)nrows / (double)ncols;
        boolean lsparse = lsparsity < 0.4 && ncols > 1L;
        double sizeSparse = MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, lsparsity, allowCSR);
        double sizeDense = MatrixBlock.estimateSizeDenseInMemory(nrows, ncols);
        return lsparse && sizeSparse < sizeDense;
    }

    public static boolean evalSparseFormatOnDisk(long nrows, long ncols, long nnz) {
        double lsparsity = (double)nnz / (double)nrows / (double)ncols;
        boolean lsparse = lsparsity < 0.4;
        double sizeUltraSparse = MatrixBlock.estimateSizeUltraSparseOnDisk(nrows, ncols, nnz);
        double sizeSparse = MatrixBlock.estimateSizeSparseOnDisk(nrows, ncols, nnz);
        double sizeDense = MatrixBlock.estimateSizeDenseOnDisk(nrows, ncols);
        return lsparse && (sizeSparse < sizeDense || sizeUltraSparse < sizeDense);
    }

    private final void denseToSparse() {
        this.denseToSparse(true, 1);
    }

    public final void denseToSparse(boolean allowCSR) {
        this.denseToSparse(allowCSR, 1);
    }

    public void denseToSparse(boolean allowCSR, int k) {
        LibMatrixDenseToSparse.denseToSparse(this, allowCSR, k);
    }

    public final void sparseToDense() {
        this.sparseToDense(1);
    }

    public void sparseToDense(int k) {
        LibMatrixSparseToDense.sparseToDense(this, k);
    }

    public long recomputeNonZeros() {
        this.nonZeros = this.sparse && this.sparseBlock != null ? this.sparseBlock.size(0, this.sparseBlock.numRows()) : (!this.sparse && this.denseBlock != null ? this.denseBlock.countNonZeros() : 0L);
        return this.nonZeros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long recomputeNonZeros(int k) {
        if (this.sparse && this.sparseBlock != null) {
            return this.recomputeNonZeros();
        }
        if (!this.sparse && this.denseBlock != null) {
            if ((long)this.rlen * (long)this.clen < 10000L) {
                return this.recomputeNonZeros();
            }
            ExecutorService pool = CommonThreadPool.get(k);
            try {
                int i;
                int bz;
                ArrayList<Future<Long>> f = new ArrayList<Future<Long>>();
                if (this.denseBlock instanceof DenseBlockFP64DEDUP) {
                    bz = (int)Math.ceil((double)this.rlen / (double)k * 2.0);
                    for (i = 0; i < this.rlen; i += bz) {
                        int j = i;
                        f.add(pool.submit(() -> this.denseBlock.countNonZeros(j, Math.min(j + bz, this.rlen) - 1, 0, this.clen - 1)));
                    }
                } else {
                    bz = 1000;
                    for (i = 0; i < this.rlen; i += 1000) {
                        for (int ii = 0; ii < this.clen; ii += 1000) {
                            int n = i;
                            int jj = ii;
                            f.add(pool.submit(() -> this.recomputeNonZeros(j, Math.min(j + 1000, this.rlen) - 1, jj, Math.min(jj + 1000, this.clen) - 1)));
                        }
                    }
                }
                long nnz = 0L;
                for (Future future : f) {
                    nnz += ((Long)future.get()).longValue();
                }
                this.nonZeros = nnz;
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed Parallel non zero count fallback to singlethread");
                long l = this.recomputeNonZeros();
                return l;
            }
            finally {
                pool.shutdown();
            }
        }
        this.nonZeros = 0L;
        return this.nonZeros;
    }

    public long recomputeNonZeros(int rl, int ru) {
        return this.recomputeNonZeros(rl, ru, 0, this.clen - 1);
    }

    public long recomputeNonZeros(int rl, int ru, int cl, int cu) {
        if (this.sparse && this.sparseBlock != null) {
            long nnz = 0L;
            if (cl == 0 && cu == this.clen - 1) {
                nnz = this.sparseBlock.size(rl, ru + 1);
            } else if (cl == cu) {
                int rlimit = Math.min(ru + 1, this.rlen);
                for (int i = rl; i < rlimit; ++i) {
                    if (this.sparseBlock.isEmpty(i)) continue;
                    nnz += this.sparseBlock.get(i, cl) != 0.0 ? 1L : 0L;
                }
            } else {
                nnz = this.sparseBlock.size(rl, ru + 1, cl, cu + 1);
            }
            return nnz;
        }
        if (!this.sparse && this.denseBlock != null) {
            return this.denseBlock.countNonZeros(rl, ru + 1, cl, cu + 1);
        }
        return 0L;
    }

    public void checkNonZeros() {
        long nnzBefore = this.getNonZeros();
        this.recomputeNonZeros();
        long nnzAfter = this.getNonZeros();
        if (nnzBefore != nnzAfter) {
            throw new RuntimeException("Number of non zeros incorrect: " + nnzBefore + " vs " + nnzAfter);
        }
    }

    public void checkSparseRows() {
        this.checkSparseRows(0, this.rlen);
    }

    public void checkSparseRows(int rl, int ru) {
        if (!this.sparse || this.sparseBlock == null) {
            return;
        }
        for (int i = rl; i < ru; ++i) {
            int k;
            if (this.sparseBlock.isEmpty(i)) continue;
            int apos = this.sparseBlock.pos(i);
            int alen = this.sparseBlock.size(i);
            int[] aix = this.sparseBlock.indexes(i);
            double[] avals = this.sparseBlock.values(i);
            for (k = apos + 1; k < apos + alen; ++k) {
                if (aix[k - 1] < aix[k]) continue;
                throw new RuntimeException("Wrong sparse row ordering: " + k + " " + aix[k - 1] + " " + aix[k]);
            }
            for (k = apos; k < apos + alen; ++k) {
                if (avals[k] != 0.0) continue;
                throw new RuntimeException("Wrong sparse row: zero at " + k);
            }
            if (aix[apos + alen - 1] <= this.clen) continue;
            throw new RuntimeException("Invalid offset outside of matrix");
        }
    }

    @Override
    public void copy(MatrixValue thatValue) {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        this.copy(that, that.evalSparseFormatInMemory());
    }

    @Override
    public void copy(MatrixValue thatValue, boolean sp) {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        if (this == that) {
            throw new RuntimeException("Copy must not overwrite itself!");
        }
        if (that instanceof CompressedMatrixBlock) {
            that = CompressedMatrixBlock.getUncompressed(that, "Copy not effecient into a MatrixBlock");
        }
        this.rlen = that.rlen;
        this.clen = that.clen;
        this.sparse = sp;
        this.estimatedNNzsPerRow = (int)Math.ceil((double)thatValue.getNonZeros() / (double)this.rlen);
        if (this.sparse && that.sparse) {
            this.copySparseToSparse(that);
        } else if (this.sparse && !that.sparse) {
            this.copyDenseToSparse(that);
        } else if (!this.sparse && that.sparse) {
            this.copySparseToDense(that);
        } else {
            this.copyDenseToDense(that);
        }
    }

    public MatrixBlock copyShallow(MatrixBlock that) {
        if (that instanceof CompressedMatrixBlock) {
            throw new DMLCompressionException("Invalid copy from CompressedMatrixBlock");
        }
        this.rlen = that.rlen;
        this.clen = that.clen;
        this.nonZeros = that.nonZeros;
        this.sparse = that.sparse;
        if (!this.sparse) {
            this.denseBlock = that.denseBlock;
        } else {
            this.sparseBlock = that.sparseBlock;
        }
        return this;
    }

    private void copySparseToSparse(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            this.resetSparse();
            return;
        }
        this.allocateSparseRowsBlock(false);
        for (int i = 0; i < Math.min(that.sparseBlock.numRows(), this.rlen); ++i) {
            if (!that.sparseBlock.isEmpty(i)) {
                this.sparseBlock.set(i, that.sparseBlock.get(i), true);
                continue;
            }
            if (this.sparseBlock.isEmpty(i)) continue;
            this.sparseBlock.reset(i, this.estimatedNNzsPerRow, this.clen);
        }
    }

    private void copyDenseToDense(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            if (this.denseBlock != null) {
                this.denseBlock.reset(this.rlen, this.clen);
            }
            return;
        }
        this.allocateDenseBlock(false);
        this.denseBlock.set(that.denseBlock);
    }

    private void copySparseToDense(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            if (this.denseBlock != null) {
                this.denseBlock.reset(this.rlen, this.clen);
            }
            return;
        }
        this.allocateDenseBlock(false);
        SparseBlock a = that.getSparseBlock();
        DenseBlock c = this.getDenseBlock();
        for (int i = 0; i < Math.min(a.numRows(), this.rlen); ++i) {
            if (a.isEmpty(i)) continue;
            int pos = a.pos(i);
            int len = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            double[] cvals = c.values(i);
            int cix = c.pos(i);
            for (int j = pos; j < pos + len; ++j) {
                cvals[cix + aix[j]] = avals[j];
            }
        }
    }

    private void copyDenseToSparse(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            this.resetSparse();
            return;
        }
        if (!this.allocateSparseRowsBlock(false)) {
            this.resetSparse();
        }
        DenseBlock a = that.getDenseBlock();
        SparseBlock c = this.getSparseBlock();
        for (int i = 0; i < this.rlen; ++i) {
            double[] avals = a.values(i);
            int aix = a.pos(i);
            for (int j = 0; j < this.clen; ++j) {
                double val = avals[aix + j];
                if (val == 0.0) continue;
                c.allocate(i, this.estimatedNNzsPerRow, this.clen);
                c.append(i, j, val);
            }
        }
    }

    public void putInto(MatrixBlock target, int rowOffset, int colOffset, boolean sparseCopyShallow) {
        if (target.isInSparseFormat()) {
            target.appendToSparse(this, rowOffset, colOffset, !sparseCopyShallow);
        } else {
            target.copy(rowOffset, rowOffset + this.rlen - 1, colOffset, colOffset + this.clen - 1, this, false);
        }
    }

    public void copy(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (this.sparse && src.sparse) {
            this.copySparseToSparse(rl, ru, cl, cu, src, awareDestNZ);
        } else if (this.sparse && !src.sparse) {
            this.copyDenseToSparse(rl, ru, cl, cu, src, awareDestNZ);
        } else if (!this.sparse && src.sparse) {
            this.copySparseToDense(rl, ru, cl, cu, src, awareDestNZ);
        } else {
            this.copyDenseToDense(rl, ru, cl, cu, src, awareDestNZ);
        }
    }

    private void copySparseToSparse(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.sparseBlock != null) {
                this.copyEmptyToSparse(rl, ru, cl, cu, true);
            }
            return;
        }
        this.allocateSparseRowsBlock(false);
        SparseBlock a = src.sparseBlock;
        SparseBlock b = this.sparseBlock;
        for (int i = 0; i < src.rlen; ++i) {
            if (a.isEmpty(i)) {
                this.copyEmptyToSparse(rl + i, rl + i, cl, cu, true);
                continue;
            }
            int apos = a.pos(i);
            int alen = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            if (b.isEmpty(rl + i)) {
                if (cl == 0) {
                    this.appendRow(rl + i, a.get(i), false);
                    this.nonZeros -= (long)alen;
                } else {
                    b.allocate(rl + i, alen);
                    b.setIndexRange(rl + i, cl, cu + 1, avals, aix, apos, alen);
                }
                this.nonZeros += awareDestNZ ? (long)alen : 0L;
                continue;
            }
            int lnnz = b.size(rl + i);
            b.setIndexRange(rl + i, cl, cu + 1, avals, aix, apos, alen);
            this.nonZeros += awareDestNZ ? (long)(b.size(rl + i) - lnnz) : 0L;
        }
    }

    private void copySparseToDense(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.denseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(rl, ru, cl, cu);
                this.denseBlock.set(rl, ru + 1, cl, cu + 1, 0.0);
            }
            return;
        }
        if (this.denseBlock == null) {
            this.allocateDenseBlock();
        } else if (awareDestNZ) {
            this.nonZeros -= this.recomputeNonZeros(rl, ru, cl, cu);
            this.denseBlock.set(rl, ru + 1, cl, cu + 1, 0.0);
        }
        SparseBlock a = src.sparseBlock;
        DenseBlock c = this.getDenseBlock();
        for (int i = 0; i < src.rlen; ++i) {
            if (a.isEmpty(i)) continue;
            int apos = a.pos(i);
            int alen = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            double[] cvals = c.values(rl + i);
            int cix = c.pos(rl + i, cl);
            for (int j = apos; j < apos + alen; ++j) {
                cvals[cix + aix[j]] = avals[j];
            }
            this.nonZeros += awareDestNZ ? (long)alen : 0L;
        }
    }

    private void copyDenseToSparse(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.sparseBlock != null) {
                this.copyEmptyToSparse(rl, ru, cl, cu, true);
            }
            return;
        }
        this.allocateSparseRowsBlock(false);
        DenseBlock a = src.getDenseBlock();
        SparseBlock c = this.getSparseBlock();
        for (int i = 0; i < src.rlen; ++i) {
            int lnnz;
            int rix = rl + i;
            double[] avals = a.values(i);
            int aix = a.pos(i);
            if (c instanceof SparseBlockMCSR && c.isEmpty(rix)) {
                lnnz = UtilFunctions.computeNnz(avals, aix, src.clen);
                if (lnnz <= 0) continue;
                c.allocate(rix, lnnz);
                for (int j = 0; j < src.clen; ++j) {
                    double val = avals[aix + j];
                    if (val == 0.0) continue;
                    c.append(rix, cl + j, val);
                }
                if (!awareDestNZ) continue;
                this.nonZeros += (long)lnnz;
                continue;
            }
            if (awareDestNZ) {
                lnnz = c.size(rix);
                if (cl == cu) {
                    double val = avals[aix];
                    c.set(rix, cl, val);
                } else {
                    c.setIndexRange(rix, cl, cu + 1, avals, aix, src.clen);
                }
                this.nonZeros += (long)(c.size(rix) - lnnz);
                continue;
            }
            for (int j = 0; j < src.clen; ++j) {
                double val = avals[aix + j];
                if (val == 0.0) continue;
                c.set(rix, cl + j, val);
            }
        }
    }

    private void copyDenseToDense(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.denseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(rl, ru, cl, cu);
                this.denseBlock.set(rl, ru + 1, cl, cu + 1, 0.0);
            }
            return;
        }
        DenseBlock a = src.getDenseBlock();
        this.allocateDenseBlock(false, a instanceof DenseBlockFP64DEDUP);
        if (awareDestNZ && (this.nonZeros != this.getLength() || src.nonZeros != src.getLength())) {
            this.nonZeros = this.nonZeros - this.recomputeNonZeros(rl, ru, cl, cu) + src.nonZeros;
        }
        DenseBlock c = this.getDenseBlock();
        c.set(rl, ru + 1, cl, cu + 1, a);
    }

    private void copyEmptyToSparse(int rl, int ru, int cl, int cu, boolean updateNNZ) {
        SparseBlock a = this.sparseBlock;
        if (cl == cu) {
            for (int i = rl; i <= ru; ++i) {
                if (a.isEmpty(i)) continue;
                boolean update = a.set(i, cl, 0.0);
                if (!updateNNZ) continue;
                this.nonZeros -= update ? 1L : 0L;
            }
        } else {
            for (int i = rl; i <= ru; ++i) {
                if (a.isEmpty(i)) continue;
                int lnnz = a.size(i);
                a.deleteIndexRange(i, cl, cu + 1);
                if (!updateNNZ) continue;
                this.nonZeros += (long)(a.size(i) - lnnz);
            }
        }
    }

    public MatrixBlock merge(MatrixBlock that, boolean appendOnly) {
        return this.merge(that, appendOnly, false, true);
    }

    public MatrixBlock merge(MatrixBlock that, boolean appendOnly, boolean par) {
        return this.merge(that, appendOnly, par, true);
    }

    public MatrixBlock merge(MatrixBlock that, boolean appendOnly, boolean par, boolean deep) {
        try {
            if (that == null || that.isEmptyBlock(false)) {
                return this;
            }
            if (this instanceof CompressedMatrixBlock || that instanceof CompressedMatrixBlock) {
                return CLALibMerge.merge(this, that, appendOnly, par, deep);
            }
            if (this.rlen != that.rlen || this.clen != that.clen) {
                throw new DMLRuntimeException("Dimension mismatch on merge disjoint (target=" + this.rlen + "x" + this.clen + ", source=" + that.rlen + "x" + that.clen + ")");
            }
            if (this.nonZeros + that.nonZeros > (long)this.rlen * (long)this.clen) {
                this.recomputeNonZeros();
                that.recomputeNonZeros();
                if (this.nonZeros + that.nonZeros > (long)this.rlen * (long)this.clen) {
                    throw new DMLRuntimeException("Number of non-zeros mismatch on merge disjoint (target=" + this.rlen + "x" + this.clen + ", nnz target=" + this.nonZeros + ", nnz source=" + that.nonZeros + ")");
                }
            }
            if (this.isEmptyBlock(false) && (this.sparse || !this.isAllocated())) {
                this.copy(that);
                return this;
            }
            long nnz = this.nonZeros + that.nonZeros;
            if (this.sparse) {
                this.mergeIntoSparse(that, appendOnly, deep);
            } else if (par) {
                this.mergeIntoDensePar(that);
            } else {
                this.mergeIntoDense(that);
            }
            this.nonZeros = nnz;
            return this;
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed merging blocks: " + this + " \n " + that, e);
        }
    }

    private void mergeIntoDense(MatrixBlock that) {
        DenseBlock a = this.getDenseBlock();
        if (that.sparse) {
            SparseBlock b = that.sparseBlock;
            int m = this.rlen;
            for (int i = 0; i < m; ++i) {
                if (b.isEmpty(i)) continue;
                int bpos = b.pos(i);
                int blen = b.size(i);
                int[] bix = b.indexes(i);
                double[] avals = a.values(i);
                double[] bvals = b.values(i);
                int aix = a.pos(i);
                for (int j = bpos; j < bpos + blen; ++j) {
                    double bval = bvals[j];
                    if (bval == 0.0) continue;
                    avals[aix + bix[j]] = bval;
                }
            }
        } else {
            DenseBlock b = that.getDenseBlock();
            for (int bi = 0; bi < a.numBlocks(); ++bi) {
                double[] avals = a.valuesAt(bi);
                double[] bvals = b.valuesAt(bi);
                int blen = a.size(bi);
                for (int j = 0; j < blen; ++j) {
                    avals[j] = bvals[j] != 0.0 ? bvals[j] : avals[j];
                }
            }
        }
    }

    private void mergeIntoDensePar(MatrixBlock that) {
        DenseBlock a = this.getDenseBlock();
        if (that.sparse) {
            SparseBlock b = that.sparseBlock;
            int roff = 0;
            for (int bi = 0; bi < a.numBlocks(); ++bi) {
                double[] avals = a.valuesAt(bi);
                int alen = a.blockSize(bi);
                int lroff = roff;
                IntStream.range(lroff, lroff + alen).parallel().forEach(i -> {
                    if (b.isEmpty(i)) {
                        return;
                    }
                    int aix = (i - lroff) * this.clen;
                    int bpos = b.pos(i);
                    int blen = b.size(i);
                    int[] bix = b.indexes(i);
                    double[] bval = b.values(i);
                    for (int j = bpos; j < bpos + blen; ++j) {
                        if (bval[j] == 0.0) continue;
                        avals[aix + bix[j]] = bval[j];
                    }
                });
                roff += alen;
            }
        } else {
            DenseBlock b = that.getDenseBlock();
            for (int bi = 0; bi < a.numBlocks(); ++bi) {
                double[] avals = a.valuesAt(bi);
                double[] bvals = b.valuesAt(bi);
                Arrays.parallelSetAll(avals, i -> bvals[i] != 0.0 ? bvals[i] : avals[i]);
            }
        }
    }

    private void mergeIntoSparse(MatrixBlock that, boolean appendOnly, boolean deep) {
        SparseBlock a = this.sparseBlock;
        boolean COO = a instanceof SparseBlockCOO;
        int m = this.rlen;
        int n = this.clen;
        if (that.sparse) {
            SparseBlock b = that.sparseBlock;
            for (int i = 0; i < m; ++i) {
                if (b.isEmpty(i)) continue;
                if (!COO && a.isEmpty(i)) {
                    a.set(i, b.get(i), deep);
                    continue;
                }
                boolean appended = false;
                int bpos = b.pos(i);
                int blen = b.size(i);
                int[] bix = b.indexes(i);
                double[] bval = b.values(i);
                for (int j = bpos; j < bpos + blen; ++j) {
                    if (bval[j] == 0.0) continue;
                    a.append(i, bix[j], bval[j]);
                    appended = true;
                }
                if (COO || appendOnly || !appended) continue;
                a.sort(i);
            }
        } else {
            DenseBlock b = that.getDenseBlock();
            for (int i = 0; i < m; ++i) {
                double[] bvals = b.values(i);
                int bix = b.pos(i);
                boolean appended = false;
                for (int j = 0; j < n; ++j) {
                    double bval = bvals[bix + j];
                    if (bval == 0.0) continue;
                    this.appendValue(i, j, bval);
                    appended = true;
                }
                if (COO || appendOnly || !appended) continue;
                a.sort(i);
            }
        }
        if (COO && !appendOnly) {
            a.sort();
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.rlen = in.readInt();
        this.clen = in.readInt();
        byte bformat = in.readByte();
        if (bformat < 0 || bformat >= Types.BlockType.values().length) {
            throw new IOException("invalid format: '" + bformat + "' (need to be 0-" + Types.BlockType.values().length + ").");
        }
        Types.BlockType format = Types.BlockType.values()[bformat];
        try {
            switch (format) {
                case ULTRA_SPARSE_BLOCK: {
                    this.nonZeros = this.readNnzInfo(in, true);
                    this.sparse = MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, this.nonZeros);
                    this.cleanupBlock(true, !this.sparse || !(this.sparseBlock instanceof SparseBlockCSR));
                    if (this.sparse) {
                        this.readUltraSparseBlock(in);
                        break;
                    }
                    this.readUltraSparseToDense(in);
                    break;
                }
                case SPARSE_BLOCK: {
                    this.nonZeros = this.readNnzInfo(in, false);
                    this.sparse = MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, this.nonZeros);
                    this.cleanupBlock(this.sparse, !this.sparse);
                    if (this.sparse) {
                        this.readSparseBlock(in);
                        break;
                    }
                    this.readSparseToDense(in);
                    break;
                }
                case DENSE_BLOCK: {
                    this.sparse = false;
                    this.cleanupBlock(false, true);
                    this.readDenseBlock(in);
                    break;
                }
                case DEDUP_BLOCK: {
                    this.sparse = false;
                    this.cleanupBlock(false, true);
                    this.readDedupDenseBlock(in);
                    break;
                }
                case EMPTY_BLOCK: {
                    this.sparse = true;
                    this.cleanupBlock(true, !(this.sparseBlock instanceof SparseBlockCSR));
                    if (this.sparseBlock != null) {
                        this.sparseBlock.reset();
                    }
                    this.nonZeros = 0L;
                }
            }
        }
        catch (DMLRuntimeException ex) {
            throw new IOException("Error reading block of type '" + format.toString() + "'.", ex);
        }
    }

    private void readDedupDenseBlock(DataInput in) throws IOException, DMLRuntimeException {
        int i;
        this.allocateDenseBlock(true, true);
        DenseBlock a = this.getDenseBlock();
        if (a.getDim(0) != this.rlen || a.getDim(1) != this.clen) {
            a.resetNoFill(this.rlen, this.clen);
        }
        HashMap<Integer, double[]> mapping = new HashMap<Integer, double[]>();
        for (i = 0; i < this.rlen; ++i) {
            Integer pos = in.readInt();
            double[] row = (double[])mapping.get(pos);
            if (row == null) {
                row = new double[this.clen];
                mapping.put(pos, row);
            }
            a.set(i, row);
        }
        for (i = 0; i < mapping.size(); ++i) {
            double[] row = (double[])mapping.get(i);
            if (row == null) {
                throw new DMLRuntimeException("serialized object is corrupt, did not find unique row number [" + i + "] in mappings");
            }
            for (int j = 0; j < this.clen; ++j) {
                row[j] = in.readDouble();
            }
        }
        this.nonZeros = a.countNonZeros();
    }

    private void readDenseBlock(DataInput in) throws IOException, DMLRuntimeException {
        this.allocateDenseBlock(true);
        DenseBlock a = this.getDenseBlock();
        if (a.getDim(0) != this.rlen || a.getDim(1) != this.clen) {
            a.resetNoFill(this.rlen, this.clen);
        }
        long nnz = 0L;
        if (in instanceof MatrixBlockDataInput) {
            MatrixBlockDataInput mbin = (MatrixBlockDataInput)((Object)in);
            for (int i = 0; i < a.numBlocks(); ++i) {
                nnz += mbin.readDoubleArray(a.size(i), a.valuesAt(i));
            }
        } else if (in instanceof DataInputBuffer) {
            DataInputBuffer din = (DataInputBuffer)in;
            try (FastBufferedDataInputStream mbin = new FastBufferedDataInputStream((InputStream)din);){
                for (int i = 0; i < a.numBlocks(); ++i) {
                    nnz += mbin.readDoubleArray(a.size(i), a.valuesAt(i));
                }
            }
        } else {
            for (int i = 0; i < this.rlen; ++i) {
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < this.clen; ++j) {
                    double d = in.readDouble();
                    avals[aix + j] = d;
                    nnz += d != 0.0 ? 1L : 0L;
                }
            }
        }
        this.nonZeros = nnz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSparseBlock(DataInput in) throws IOException {
        block6: {
            block7: {
                block5: {
                    if (!this.allocateSparseRowsBlock(false)) {
                        this.resetSparse();
                    }
                    if (!(in instanceof MatrixBlockDataInput)) break block5;
                    MatrixBlockDataInput mbin = (MatrixBlockDataInput)((Object)in);
                    this.nonZeros = mbin.readSparseRows(this.rlen, this.nonZeros, this.sparseBlock);
                    break block6;
                }
                if (!(in instanceof DataInputBuffer)) break block7;
                DataInputBuffer din = (DataInputBuffer)in;
                FastBufferedDataInputStream mbin = null;
                try {
                    mbin = new FastBufferedDataInputStream((InputStream)din);
                    this.nonZeros = mbin.readSparseRows(this.rlen, this.nonZeros, this.sparseBlock);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(mbin);
                    throw throwable;
                }
                IOUtilFunctions.closeSilently(mbin);
                break block6;
            }
            for (int r = 0; r < this.rlen; ++r) {
                int rnnz = in.readInt();
                if (rnnz <= 0) continue;
                this.sparseBlock.reset(r, rnnz, this.clen);
                for (int j = 0; j < rnnz; ++j) {
                    this.sparseBlock.append(r, in.readInt(), in.readDouble());
                }
            }
        }
    }

    private void readSparseToDense(DataInput in) throws IOException, DMLRuntimeException {
        if (!this.allocateDenseBlock(false)) {
            this.denseBlock.reset(this.rlen, this.clen);
        }
        DenseBlock a = this.getDenseBlock();
        for (int r = 0; r < this.rlen; ++r) {
            int nr = in.readInt();
            double[] avals = a.values(r);
            int cix = a.pos(r);
            for (int j = 0; j < nr; ++j) {
                int c = in.readInt();
                avals[cix + c] = in.readDouble();
            }
        }
    }

    private void readUltraSparseBlock(DataInput in) throws IOException {
        this.allocateAndResetSparseBlock(false, SparseBlock.Type.CSR);
        if (this.clen > 1) {
            SparseBlockCSR sblockCSR = (SparseBlockCSR)this.sparseBlock;
            sblockCSR.initUltraSparse((int)this.nonZeros, in);
        } else {
            for (long i = 0L; i < this.nonZeros; ++i) {
                int r = in.readInt();
                double val = in.readDouble();
                this.sparseBlock.allocate(r, 1, 1);
                this.sparseBlock.append(r, 0, val);
            }
        }
    }

    private void readUltraSparseToDense(DataInput in) throws IOException, DMLRuntimeException {
        if (!this.allocateDenseBlock(false)) {
            this.denseBlock.reset(this.rlen, this.clen);
        }
        if (this.clen > 1) {
            DenseBlock a = this.getDenseBlock();
            for (long i = 0L; i < this.nonZeros; ++i) {
                int r = in.readInt();
                int c = in.readInt();
                a.set(r, c, in.readDouble());
            }
        } else {
            double[] a = this.getDenseBlockValues();
            for (long i = 0L; i < this.nonZeros; ++i) {
                a[in.readInt()] = in.readDouble();
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        boolean sparseSrc = this.sparse;
        boolean sparseDst = this.evalSparseFormatOnDisk();
        out.writeInt(this.rlen);
        out.writeInt(this.clen);
        if (sparseSrc) {
            if (this.sparseBlock == null || this.nonZeros == 0L) {
                MatrixBlock.writeEmptyBlock(out);
            } else if (this.isUltraSparseSerialize(sparseDst)) {
                this.writeSparseToUltraSparse(out);
            } else if (sparseDst) {
                this.writeSparseBlock(out);
            } else {
                this.writeSparseToDense(out);
            }
        } else if (this.denseBlock == null || this.nonZeros == 0L) {
            MatrixBlock.writeEmptyBlock(out);
        } else if (this.isUltraSparseSerialize(sparseDst)) {
            this.writeDenseToUltraSparse(out);
        } else if (sparseDst) {
            this.writeDenseToSparse(out);
        } else if (this.denseBlock instanceof DenseBlockFP64DEDUP) {
            this.writeDedupDenseblock(out);
        } else {
            this.writeDenseBlock(out);
        }
    }

    private void writeDedupDenseblock(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.DEDUP_BLOCK.ordinal());
        DenseBlockFP64DEDUP a = (DenseBlockFP64DEDUP)this.getDenseBlock();
        if (this.rlen > a.numBlocks()) {
            throw new DMLRuntimeException("Serialize DedupDenseblock: block does not contain enough rows [" + a.numBlocks() + " < " + this.rlen + "]");
        }
        HashMap<double[], Integer> mapping = new HashMap<double[], Integer>((int)((double)a.getNrDistinctRows() * 1.1));
        ArrayList<double[]> unique_rows = new ArrayList<double[]>((int)((double)a.getNrDistinctRows() * 1.1));
        for (int i = 0; i < this.rlen; ++i) {
            double[] dArray = a.values(i);
            Integer pos = (Integer)mapping.get(dArray);
            if (pos == null) {
                pos = mapping.size();
                unique_rows.add(dArray);
                mapping.put(dArray, pos);
            }
            out.writeInt(pos);
        }
        if (mapping.size() != unique_rows.size()) {
            throw new DMLRuntimeException("Serialize DedupDenseblock: Map Size != Row Size");
        }
        if (out instanceof MatrixBlockDataOutput) {
            MatrixBlockDataOutput mout = (MatrixBlockDataOutput)((Object)out);
            for (double[] row : unique_rows) {
                mout.writeDoubleArray(this.clen, row);
            }
        } else {
            for (double[] dArray : unique_rows) {
                for (int i = 0; i < this.clen; ++i) {
                    out.writeDouble(dArray[i]);
                }
            }
        }
    }

    private static void writeEmptyBlock(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.EMPTY_BLOCK.ordinal());
    }

    private void writeDenseBlock(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.DENSE_BLOCK.ordinal());
        DenseBlock a = this.getDenseBlock();
        if (out instanceof MatrixBlockDataOutput) {
            MatrixBlockDataOutput mout = (MatrixBlockDataOutput)((Object)out);
            for (int i = 0; i < a.numBlocks(); ++i) {
                mout.writeDoubleArray(a.size(i), a.valuesAt(i));
            }
        } else {
            for (int i = 0; i < a.numBlocks(); ++i) {
                double[] avals = a.values(i);
                int limit = a.size(i);
                for (int j = 0; j < limit; ++j) {
                    out.writeDouble(avals[j]);
                }
            }
        }
    }

    private void writeSparseBlock(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, false);
        if (out instanceof MatrixBlockDataOutput) {
            ((MatrixBlockDataOutput)((Object)out)).writeSparseRows(this.rlen, this.sparseBlock);
        } else {
            int r;
            for (r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) {
                    out.writeInt(0);
                    continue;
                }
                int pos = this.sparseBlock.pos(r);
                int nr = this.sparseBlock.size(r);
                int[] cols = this.sparseBlock.indexes(r);
                double[] values = this.sparseBlock.values(r);
                out.writeInt(nr);
                for (int j = pos; j < pos + nr; ++j) {
                    out.writeInt(cols[j]);
                    out.writeDouble(values[j]);
                }
            }
            while (r < this.rlen) {
                out.writeInt(0);
                ++r;
            }
        }
    }

    private void writeSparseToUltraSparse(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.ULTRA_SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, true);
        long wnnz = 0L;
        if (this.clen > 1) {
            if (this.sparseBlock instanceof SparseBlockCOO) {
                SparseBlockCOO sblock = (SparseBlockCOO)this.sparseBlock;
                int[] rix = sblock.rowIndexes();
                int[] cix = sblock.indexes();
                double[] vals = sblock.values();
                int i = 0;
                while ((long)i < sblock.size()) {
                    out.writeInt(rix[i]);
                    out.writeInt(cix[i]);
                    out.writeDouble(vals[i]);
                    ++wnnz;
                    ++i;
                }
            } else {
                for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                    if (this.sparseBlock.isEmpty(r)) continue;
                    int apos = this.sparseBlock.pos(r);
                    int alen = this.sparseBlock.size(r);
                    int[] aix = this.sparseBlock.indexes(r);
                    double[] avals = this.sparseBlock.values(r);
                    for (int j = apos; j < apos + alen; ++j) {
                        out.writeInt(r);
                        out.writeInt(aix[j]);
                        out.writeDouble(avals[j]);
                        ++wnnz;
                    }
                }
            }
        } else {
            for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) continue;
                int pos = this.sparseBlock.pos(r);
                out.writeInt(r);
                out.writeDouble(this.sparseBlock.values(r)[pos]);
                ++wnnz;
            }
        }
        if (this.nonZeros != wnnz) {
            throw new IOException("Invalid number of serialized non-zeros: " + wnnz + " (expected: " + this.nonZeros + ")");
        }
    }

    private void writeSparseToDense(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.DENSE_BLOCK.ordinal());
        if (this.sparseBlock == null) {
            for (int i = 0; i < this.rlen * this.clen; ++i) {
                out.writeDouble(0.0);
            }
        } else {
            SparseBlock a = this.sparseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                if (i < a.numRows() && !a.isEmpty(i)) {
                    int apos = a.pos(i);
                    int alen = a.size(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    int j = 0;
                    for (int j2 = 0; j2 < alen; ++j2) {
                        while (j < aix[apos + j2]) {
                            out.writeDouble(0.0);
                            ++j;
                        }
                        out.writeDouble(avals[apos + j2]);
                        ++j;
                    }
                    for (j = aix[apos + alen - 1] + 1; j < this.clen; ++j) {
                        out.writeDouble(0.0);
                    }
                    continue;
                }
                for (int j = 0; j < this.clen; ++j) {
                    out.writeDouble(0.0);
                }
            }
        }
    }

    private void writeDenseToUltraSparse(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.ULTRA_SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, true);
        long wnnz = 0L;
        if (this.clen > 1) {
            DenseBlock a = this.getDenseBlock();
            for (int r = 0; r < this.rlen; ++r) {
                double[] avals = a.values(r);
                int aix = a.pos(r);
                for (int c = 0; c < this.clen; ++c) {
                    double aval = avals[aix + c];
                    if (aval == 0.0) continue;
                    out.writeInt(r);
                    out.writeInt(c);
                    out.writeDouble(aval);
                    ++wnnz;
                }
            }
        } else {
            double[] a = this.getDenseBlockValues();
            for (int r = 0; r < this.rlen; ++r) {
                double aval = a[r];
                if (aval == 0.0) continue;
                out.writeInt(r);
                out.writeDouble(aval);
                ++wnnz;
            }
        }
        if (this.nonZeros != wnnz) {
            throw new IOException("Invalid number of serialized non-zeros: " + wnnz + " (expected: " + this.nonZeros + ")");
        }
    }

    private void writeDenseToSparse(DataOutput out) throws IOException {
        out.writeByte(Types.BlockType.SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, false);
        DenseBlock a = this.getDenseBlock();
        for (int r = 0; r < this.rlen; ++r) {
            double[] avals = a.values(r);
            int aix = a.pos(r);
            out.writeInt(a.countNonZeros(r));
            for (int c = 0; c < this.clen; ++c) {
                double aval = avals[aix + c];
                if (aval == 0.0) continue;
                out.writeInt(c);
                out.writeDouble(aval);
            }
        }
    }

    private long readNnzInfo(DataInput in, boolean ultrasparse) throws IOException {
        long lrlen = this.rlen;
        long lclen = this.clen;
        this.nonZeros = lrlen * lclen > Integer.MAX_VALUE && !ultrasparse ? in.readLong() : (long)in.readInt();
        return this.nonZeros;
    }

    private void writeNnzInfo(DataOutput out, boolean ultrasparse) throws IOException {
        long lrlen = this.rlen;
        long lclen = this.clen;
        if (lrlen * lclen > Integer.MAX_VALUE && !ultrasparse) {
            out.writeLong(this.nonZeros);
        } else {
            out.writeInt((int)this.nonZeros);
        }
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        if (is instanceof ObjectInputStream && !(is instanceof MatrixBlockDataInput)) {
            ObjectInputStream ois = (ObjectInputStream)is;
            FastBufferedDataInputStream fis = new FastBufferedDataInputStream(ois);
            this.readFields(fis);
        } else {
            this.readFields(is);
        }
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        if (os instanceof ObjectOutputStream && !this.isEmptyBlock(false) && !(os instanceof MatrixBlockDataOutput)) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            FastBufferedDataOutputStream fos = new FastBufferedDataOutputStream(oos);
            this.write(fos);
            fos.flush();
        } else {
            this.write(os);
        }
    }

    public long getExactSizeOnDisk() {
        boolean sparseSrc = this.sparse;
        boolean sparseDst = this.evalSparseFormatOnDisk();
        long lrlen = this.rlen;
        long lclen = this.clen;
        if (this.nonZeros <= 0L) {
            this.recomputeNonZeros();
        }
        if (sparseSrc) {
            if (this.sparseBlock == null || this.nonZeros == 0L) {
                return 9L;
            }
            if (this.nonZeros < lrlen && sparseDst) {
                return MatrixBlock.estimateSizeUltraSparseOnDisk(lrlen, lclen, this.nonZeros);
            }
            if (sparseDst) {
                return MatrixBlock.estimateSizeSparseOnDisk(lrlen, lclen, this.nonZeros);
            }
            return MatrixBlock.estimateSizeDenseOnDisk(lrlen, lclen);
        }
        if (this.denseBlock == null || this.nonZeros == 0L) {
            return 9L;
        }
        if (this.nonZeros < lrlen && sparseDst) {
            return MatrixBlock.estimateSizeUltraSparseOnDisk(lrlen, lclen, this.nonZeros);
        }
        if (sparseDst) {
            return MatrixBlock.estimateSizeSparseOnDisk(lrlen, lclen, this.nonZeros);
        }
        return MatrixBlock.estimateSizeDenseOnDisk(lrlen, lclen);
    }

    public static long getHeaderSize() {
        long size = 16L;
        size += 12L;
        ++size;
        size += 3L;
        size += 8L;
        return size += 16L;
    }

    public long estimateSizeInMemory() {
        if (this.denseBlock instanceof DenseBlockFP64DEDUP) {
            long size = MatrixBlock.getHeaderSize() + ((DenseBlockFP64DEDUP)this.denseBlock).estimateMemory();
            return Math.min(size, Long.MAX_VALUE);
        }
        return MatrixBlock.estimateSizeInMemory((long)this.rlen, (long)this.clen, this.getSparsity());
    }

    public static long estimateSizeInMemory(long nrows, long ncols, double sparsity) {
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(nrows, ncols, (long)(sparsity * (double)nrows * (double)ncols));
        if (sparse) {
            return MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, sparsity);
        }
        return MatrixBlock.estimateSizeDenseInMemory(nrows, ncols);
    }

    public static long estimateSizeInMemory(DataCharacteristics dc) {
        return MatrixBlock.estimateSizeInMemory(dc.getRows(), dc.getCols(), dc.getSparsity());
    }

    public static long estimateSizeInMemory(long nrows, long ncols, long nnz) {
        return MatrixBlock.estimateSizeInMemory(nrows, ncols, OptimizerUtils.getSparsity(nrows, ncols, nnz));
    }

    public long estimateSizeDenseInMemory() {
        return MatrixBlock.estimateSizeDenseInMemory(this.rlen, this.clen);
    }

    public static long estimateSizeDenseInMemory(long nrows, long ncols) {
        double size = (double)MatrixBlock.getHeaderSize() + DenseBlockFactory.estimateSizeDenseInMemory(nrows, ncols);
        return (long)Math.min(size, 9.223372036854776E18);
    }

    public long estimateSizeSparseInMemory() {
        return MatrixBlock.estimateSizeSparseInMemory(this.rlen, this.clen, this.getSparsity());
    }

    public static long estimateSizeSparseInMemory(long nrows, long ncols, double sparsity) {
        return MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, sparsity, DEFAULT_SPARSEBLOCK);
    }

    public static long estimateSizeSparseInMemory(long nrows, long ncols, double sparsity, boolean allowCSR) {
        if (allowCSR) {
            return MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, sparsity, SparseBlock.Type.CSR);
        }
        return MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, sparsity, DEFAULT_SPARSEBLOCK);
    }

    public long estimateSizeSparseInMemory(SparseBlock.Type stype) {
        return MatrixBlock.estimateSizeSparseInMemory((long)this.rlen, (long)this.clen, this.getSparsity(), stype);
    }

    public static long estimateSizeSparseInMemory(long nrows, long ncols, double sparsity, SparseBlock.Type stype) {
        double size = MatrixBlock.getHeaderSize() + (sparsity == 0.0 ? 0L : SparseBlockFactory.estimateSizeSparseInMemory(stype, nrows, ncols, sparsity));
        return (long)Math.min(size, 9.223372036854776E18);
    }

    public long estimateSizeOnDisk() {
        return MatrixBlock.estimateSizeOnDisk(this.rlen, this.clen, this.nonZeros);
    }

    public static long estimateSizeOnDisk(long nrows, long ncols, long nnz) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(nrows, ncols, nnz);
        if (sparse && nnz < nrows) {
            return MatrixBlock.estimateSizeUltraSparseOnDisk(nrows, ncols, nnz);
        }
        if (sparse) {
            return MatrixBlock.estimateSizeSparseOnDisk(nrows, ncols, nnz);
        }
        return MatrixBlock.estimateSizeDenseOnDisk(nrows, ncols);
    }

    private static long estimateSizeDenseOnDisk(long nrows, long ncols) {
        long size = 9L;
        return size += nrows * ncols * 8L;
    }

    private static long estimateSizeSparseOnDisk(long nrows, long ncols, long nnz) {
        long size = 9L;
        size += nrows * ncols > Integer.MAX_VALUE ? 8L : 4L;
        return size += nrows * 4L + nnz * 12L;
    }

    private static long estimateSizeUltraSparseOnDisk(long nrows, long ncols, long nnz) {
        long size = 9L;
        size += 4L;
        size = ncols > 1L ? (size += nnz * 16L) : (size += nnz * 12L);
        return size;
    }

    private static SparsityEstimate estimateSparsityOnBinary(MatrixBlock m1, MatrixBlock m2, BinaryOperator op) {
        SparsityEstimate est = new SparsityEstimate();
        if (!(op.sparseSafe || op.fn instanceof Divide && m2.getSparsity() == 1.0)) {
            est.sparse = false;
            return est;
        }
        LibMatrixBincell.BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
        boolean outer = atype == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR;
        long m = m1.getNumRows();
        long n = outer ? (long)m2.getNumColumns() : (long)m1.getNumColumns();
        long nz1 = m1.getNonZeros();
        long nz2 = m2.getNonZeros();
        long estnnz = 0L;
        if (atype == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR) {
            estnnz = OptimizerUtils.getOuterNonZeros(m, n, nz1, nz2, op.getBinaryOperatorOpOp2());
        } else {
            if (atype == LibMatrixBincell.BinaryAccessType.MATRIX_COL_VECTOR) {
                nz2 *= n;
            } else if (atype == LibMatrixBincell.BinaryAccessType.MATRIX_ROW_VECTOR) {
                nz2 *= m;
            }
            double sp1 = OptimizerUtils.getSparsity(m, n, nz1);
            double sp2 = OptimizerUtils.getSparsity(m, n, nz2);
            double spout = OptimizerUtils.getBinaryOpSparsity(sp1, sp2, op.getBinaryOperatorOpOp2(), true);
            estnnz = UtilFunctions.toLong(spout * (double)m * (double)n);
        }
        est.sparse = MatrixBlock.evalSparseFormatInMemory(m, n, estnnz);
        est.estimatedNonZeros = estnnz;
        return est;
    }

    private boolean estimateSparsityOnSlice(int selectRlen, int selectClen, int finalRlen, int finalClen) {
        long ennz = (long)((double)this.nonZeros / (double)this.rlen / (double)this.clen * (double)selectRlen * (double)selectClen);
        return MatrixBlock.evalSparseFormatInMemory(finalRlen, finalClen, ennz);
    }

    private static boolean estimateSparsityOnLeftIndexing(long rlenm1, long clenm1, long nnzm1, long rlenm2, long clenm2, long nnzm2) {
        long ennz = Math.min(rlenm1 * clenm1, nnzm1 + nnzm2);
        return MatrixBlock.evalSparseFormatInMemory(rlenm1, clenm1, ennz);
    }

    private boolean requiresInplaceSparseBlockOnLeftIndexing(boolean sparse, MatrixObject.UpdateType update, long nnz) {
        return sparse && update != MatrixObject.UpdateType.INPLACE_PINNED && !this.isShallowSerialize() && (nnz <= Integer.MAX_VALUE || DEFAULT_INPLACE_SPARSEBLOCK == SparseBlock.Type.MCSR);
    }

    private static boolean estimateSparsityOnGroupedAgg(long rlen, long groups) {
        long ennz = Math.min(groups, rlen);
        return MatrixBlock.evalSparseFormatInMemory(groups, 1L, ennz);
    }

    @Override
    public long getInMemorySize() {
        if (!this.isAllocated()) {
            return MatrixBlock.getHeaderSize();
        }
        if (this.denseBlock instanceof DenseBlockFP64DEDUP) {
            double size = MatrixBlock.getHeaderSize() + ((DenseBlockFP64DEDUP)this.denseBlock).estimateMemory();
            return (long)Math.min(size, 9.223372036854776E18);
        }
        return !this.sparse ? MatrixBlock.estimateSizeDenseInMemory(this.rlen, this.clen) : MatrixBlock.estimateSizeSparseInMemory((long)this.rlen, (long)this.clen, this.getSparsity(), SparseBlockFactory.getSparseBlockType(this.sparseBlock));
    }

    @Override
    public long getExactSerializedSize() {
        return this.getExactSizeOnDisk();
    }

    @Override
    public boolean isShallowSerialize() {
        return this.isShallowSerialize(false);
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        boolean sparseDst = this.evalSparseFormatOnDisk();
        return !this.sparse || !sparseDst || this.sparse && this.sparseBlock instanceof SparseBlockCSR || this.sparse && this.sparseBlock instanceof SparseBlockMCSR && (double)this.getInMemorySize() / 2.0 <= (double)this.getExactSerializedSize() || this.sparse && this.sparseBlock instanceof SparseBlockMCSR && this.nonZeros < Integer.MAX_VALUE && inclConvert && !this.isUltraSparseSerialize(sparseDst);
    }

    @Override
    public void toShallowSerializeBlock() {
        if (this.isShallowSerialize() || !this.isShallowSerialize(true)) {
            return;
        }
        this.sparseBlock = SparseBlockFactory.copySparseBlock(SparseBlock.Type.CSR, this.sparseBlock, false);
    }

    @Override
    public void compactEmptyBlock() {
        if (this.isEmptyBlock(false) && this.isAllocated()) {
            this.cleanupBlock(true, true);
        }
    }

    @Override
    public MatrixBlock scalarOperations(ScalarOperator op, MatrixValue result) {
        MatrixBlock ret = MatrixBlock.checkType(result);
        boolean sp = this.sparse;
        if (!op.sparseSafe) {
            sp = false;
        }
        if (ret == null) {
            ret = new MatrixBlock(this.rlen, this.clen, sp, this.nonZeros);
        } else {
            ret.reset(this.rlen, this.clen, sp, this.nonZeros);
        }
        if (op.getNumThreads() > 1) {
            LibMatrixBincell.bincellOp(this, ret, op, op.getNumThreads());
        } else {
            LibMatrixBincell.bincellOp(this, ret, op);
        }
        return ret;
    }

    public final MatrixBlock unaryOperations(UnaryOperator op) {
        return this.unaryOperations(op, null);
    }

    @Override
    public MatrixBlock unaryOperations(UnaryOperator op, MatrixValue result) {
        int n;
        boolean sp;
        MatrixBlock ret = MatrixBlock.checkType(result);
        boolean bl = sp = this.sparse && op.sparseSafe;
        if (Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.ISNAN, Builtin.BuiltinCode.ISNA) && !this.containsValue(op.getPattern())) {
            return new MatrixBlock(this.rlen, this.clen, true);
        }
        int n2 = n = Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.CUMSUMPROD) ? 1 : this.clen;
        if (ret == null) {
            ret = new MatrixBlock(this.rlen, n, sp, sp ? this.nonZeros : (long)(this.rlen * n));
        } else {
            ret.reset(this.rlen, n, sp);
        }
        ret = LibMatrixAgg.isSupportedUnaryOperator(op) ? (op.getNumThreads() > 1 ? LibMatrixAgg.cumaggregateUnaryMatrix(this, ret, op, op.getNumThreads()) : LibMatrixAgg.cumaggregateUnaryMatrix(this, ret, op)) : LibMatrixBincell.uncellOp(this, ret, op);
        if (ret.isEmptyBlock(false)) {
            ret.examSparsity();
        }
        return ret;
    }

    public final MatrixBlock binaryOperations(BinaryOperator op, MatrixValue thatValue) {
        return this.binaryOperations(op, thatValue, null);
    }

    @Override
    public MatrixBlock binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        MatrixBlock ret = MatrixBlock.checkType(result);
        LibMatrixBincell.isValidDimensionsBinary(this, that);
        if (thatValue instanceof CompressedMatrixBlock) {
            return ((CompressedMatrixBlock)thatValue).binaryOperationsLeft(op, this, result);
        }
        boolean outer = LibMatrixBincell.getBinaryAccessType(this, that) == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR;
        int rows = this.rlen;
        int cols = outer ? that.clen : this.clen;
        SparsityEstimate resultSparse = MatrixBlock.estimateSparsityOnBinary(this, that, op);
        if (ret == null) {
            ret = new MatrixBlock(rows, cols, resultSparse.sparse, resultSparse.estimatedNonZeros);
        } else {
            ret.reset(rows, cols, resultSparse.sparse, resultSparse.estimatedNonZeros);
        }
        if (op.getNumThreads() > 1) {
            LibMatrixBincell.bincellOp(this, that, ret, op, op.getNumThreads());
        } else {
            LibMatrixBincell.bincellOp(this, that, ret, op);
        }
        return ret;
    }

    @Override
    public MatrixBlock binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        LibMatrixBincell.isValidDimensionsBinary(this, that);
        SparsityEstimate resultSparse = MatrixBlock.estimateSparsityOnBinary(this, that, op);
        if (resultSparse.sparse && !this.sparse) {
            this.denseToSparse();
        } else if (!resultSparse.sparse && this.sparse) {
            this.sparseToDense();
        }
        LibMatrixBincell.bincellOpInPlace(this, that, op);
        return this;
    }

    public MatrixBlock ternaryOperations(TernaryOperator op, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret) {
        if (ret == null) {
            ret = new MatrixBlock();
        }
        int r1 = this.getNumRows();
        int r2 = m2.getNumRows();
        int r3 = m3.getNumRows();
        int c1 = this.getNumColumns();
        int c2 = m2.getNumColumns();
        int c3 = m3.getNumColumns();
        boolean s1 = r1 == 1 && c1 == 1;
        boolean s2 = r2 == 1 && c2 == 1;
        boolean s3 = r3 == 1 && c3 == 1;
        double d1 = s1 ? this.quickGetValue(0, 0) : Double.NaN;
        double d2 = s2 ? m2.quickGetValue(0, 0) : Double.NaN;
        double d3 = s3 ? m3.quickGetValue(0, 0) : Double.NaN;
        int m = Math.max(Math.max(r1, r2), r3);
        int n = Math.max(Math.max(c1, c2), c3);
        long nnz = this.nonZeros;
        MatrixBlock.ternaryOperationCheck(s1, s2, s3, m, r1, r2, r3, n, c1, c2, c3);
        if (op.fn instanceof IfElse && (s1 || nnz == 0L || nnz == (long)m * (long)n)) {
            MatrixBlock tmp;
            ret.reset(m, n, false);
            boolean expr = s1 ? d1 != 0.0 : nnz == (long)m * (long)n;
            MatrixBlock matrixBlock = tmp = expr ? m2 : m3;
            if (tmp.rlen == m && tmp.clen == n) {
                ret.copyShallow(tmp);
            } else {
                double tmpVal = tmp.quickGetValue(0, 0);
                if (tmpVal != 0.0) {
                    ret.allocateDenseBlock();
                    ret.denseBlock.set(tmpVal);
                    ret.nonZeros = (long)m * (long)n;
                }
            }
        } else {
            boolean PM_Or_MM;
            boolean bl = PM_Or_MM = op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply;
            if (PM_Or_MM && (s2 && d2 == 0.0 || s3 && d3 == 0.0)) {
                ret.copy(this);
                return ret;
            }
            boolean sparseOutput = MatrixBlock.evalSparseFormatInMemory(m, n, (s1 ? (long)(m * n * (d1 != 0.0 ? 1 : 0)) : this.getNonZeros()) + Math.min(s2 ? (long)(m * n) : m2.getNonZeros(), s3 ? (long)(m * n) : m3.getNonZeros()));
            if (m2 instanceof CompressedMatrixBlock) {
                m2 = ((CompressedMatrixBlock)m2).getUncompressed("Ternary Operator arg2 " + op.fn.getClass().getSimpleName(), op.getNumThreads());
            }
            if (m3 instanceof CompressedMatrixBlock) {
                m3 = ((CompressedMatrixBlock)m3).getUncompressed("Ternary Operator arg3 " + op.fn.getClass().getSimpleName(), op.getNumThreads());
            }
            ret.reset(m, n, sparseOutput);
            if (s2 != s3 && (op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply)) {
                BinaryOperator bop = ((TernaryValueFunction.ValueFunctionWithConstant)((Object)op.fn)).setOp2Constant(s2 ? d2 : d3);
                if (op.getNumThreads() > 1) {
                    LibMatrixBincell.bincellOp(this, s2 ? m3 : m2, ret, bop, op.getNumThreads());
                } else {
                    LibMatrixBincell.bincellOp(this, s2 ? m3 : m2, ret, bop);
                }
            } else {
                LibMatrixTercell.tercellOp(this, m2, m3, ret, op);
                ret.examSparsity();
            }
        }
        return ret;
    }

    public static void ternaryOperationCheck(boolean s1, boolean s2, boolean s3, int m, int r1, int r2, int r3, int n, int c1, int c2, int c3) {
        if (!((s1 || r1 == m && c1 == n) && (s2 || r2 == m && c2 == n) && (s3 || r3 == m && c3 == n))) {
            throw new DMLRuntimeException("Block sizes are not matched for ternary cell operations: " + r1 + "x" + c1 + " vs " + r2 + "x" + c2 + " vs " + r3 + "x" + c3);
        }
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection, boolean deep) {
        MatrixBlock cor = MatrixBlock.checkType(correction);
        MatrixBlock newWithCor = MatrixBlock.checkType(newWithCorrection);
        KahanObject buffer = new KahanObject(0.0, 0.0);
        if (aggOp.correction == Types.CorrectionLocationType.LASTROW) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    buffer._correction = cor.quickGetValue(0, c);
                    buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r + 1, c));
                    this.quickSetValue(r, c, buffer._sum);
                    cor.quickSetValue(0, c, buffer._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTCOLUMN) {
            if (aggOp.increOp.fn instanceof Builtin && (((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX || ((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX)) {
                for (int r = 0; r < this.rlen; ++r) {
                    double currMaxValue = cor.quickGetValue(r, 0);
                    long newMaxIndex = (long)newWithCor.quickGetValue(r, 0);
                    double newMaxValue = newWithCor.quickGetValue(r, 1);
                    double update = aggOp.increOp.fn.execute(newMaxValue, currMaxValue);
                    if (2.0 == update) {
                        long curMaxIndex = (long)this.quickGetValue(r, 0);
                        this.quickSetValue(r, 0, Math.max(curMaxIndex, newMaxIndex));
                        continue;
                    }
                    if (1.0 != update) continue;
                    this.quickSetValue(r, 0, newMaxIndex);
                    cor.quickSetValue(r, 0, newMaxValue);
                }
            } else {
                for (int r = 0; r < this.rlen; ++r) {
                    for (int c = 0; c < this.clen; ++c) {
                        buffer._sum = this.quickGetValue(r, c);
                        buffer._correction = cor.quickGetValue(r, 0);
                        buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r, c + 1));
                        this.quickSetValue(r, c, buffer._sum);
                        cor.quickSetValue(r, 0, buffer._correction);
                    }
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.NONE) {
            if (aggOp.increOp.fn instanceof KahanPlus) {
                LibMatrixAgg.aggregateBinaryMatrix(newWithCor, this, cor, deep);
            } else {
                if (newWithCor.isInSparseFormat() && aggOp.sparseSafe) {
                    SparseBlock b = newWithCor.getSparseBlock();
                    if (b == null) {
                        return;
                    }
                    for (int r = 0; r < Math.min(this.rlen, b.numRows()); ++r) {
                        if (b.isEmpty(r)) continue;
                        int bpos = b.pos(r);
                        int blen = b.size(r);
                        int[] bix = b.indexes(r);
                        double[] bvals = b.values(r);
                        for (int j = bpos; j < bpos + blen; ++j) {
                            int c = bix[j];
                            buffer._sum = this.quickGetValue(r, c);
                            buffer._correction = cor.quickGetValue(r, c);
                            buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, bvals[j]);
                            this.quickSetValue(r, c, buffer._sum);
                            cor.quickSetValue(r, c, buffer._correction);
                        }
                    }
                } else {
                    for (int r = 0; r < this.rlen; ++r) {
                        for (int c = 0; c < this.clen; ++c) {
                            buffer._sum = this.quickGetValue(r, c);
                            buffer._correction = cor.quickGetValue(r, c);
                            buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, newWithCor.quickGetValue(r, c));
                            this.quickSetValue(r, c, buffer._sum);
                            cor.quickSetValue(r, c, buffer._correction);
                        }
                    }
                }
                this.examSparsity();
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTTWOROWS) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = cor.quickGetValue(0, c);
                    buffer._correction = cor.quickGetValue(1, c);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r + 1, c);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    cor.quickSetValue(0, c, n);
                    cor.quickSetValue(1, c, buffer._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTTWOCOLUMNS) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = cor.quickGetValue(r, 0);
                    buffer._correction = cor.quickGetValue(r, 1);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r, c + 1);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    cor.quickSetValue(r, 0, n);
                    cor.quickSetValue(r, 1, buffer._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTFOURROWS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    cbuff_curr.w = cor.quickGetValue(1, c);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = cor.quickGetValue(0, c);
                    cbuff_curr.m2._correction = cor.quickGetValue(2, c);
                    cbuff_curr.mean._correction = cor.quickGetValue(3, c);
                    cbuff_part.w = newWithCor.quickGetValue(r + 2, c);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r + 1, c);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r + 3, c);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r + 4, c);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    cor.quickSetValue(0, c, cbuff_curr.mean._sum);
                    cor.quickSetValue(1, c, cbuff_curr.w);
                    cor.quickSetValue(2, c, cbuff_curr.m2._correction);
                    cor.quickSetValue(3, c, cbuff_curr.mean._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTFOURCOLUMNS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    cbuff_curr.w = cor.quickGetValue(r, 1);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = cor.quickGetValue(r, 0);
                    cbuff_curr.m2._correction = cor.quickGetValue(r, 2);
                    cbuff_curr.mean._correction = cor.quickGetValue(r, 3);
                    cbuff_part.w = newWithCor.quickGetValue(r, c + 2);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r, c + 1);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r, c + 3);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r, c + 4);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    cor.quickSetValue(r, 0, cbuff_curr.mean._sum);
                    cor.quickSetValue(r, 1, cbuff_curr.w);
                    cor.quickSetValue(r, 2, cbuff_curr.m2._correction);
                    cor.quickSetValue(r, 3, cbuff_curr.mean._correction);
                }
            }
        } else {
            throw new DMLRuntimeException("unrecognized correctionLocation: " + aggOp.correction);
        }
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) {
        MatrixBlock newWithCor = MatrixBlock.checkType(newWithCorrection);
        KahanObject buffer = new KahanObject(0.0, 0.0);
        if (aggOp.correction == Types.CorrectionLocationType.LASTROW) {
            if (aggOp.increOp.fn instanceof KahanPlus) {
                LibMatrixAgg.aggregateBinaryMatrix(newWithCor, this, aggOp);
            } else {
                for (int r = 0; r < this.rlen - 1; ++r) {
                    for (int c = 0; c < this.clen; ++c) {
                        buffer._sum = this.quickGetValue(r, c);
                        buffer._correction = this.quickGetValue(r + 1, c);
                        buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r + 1, c));
                        this.quickSetValue(r, c, buffer._sum);
                        this.quickSetValue(r + 1, c, buffer._correction);
                    }
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTCOLUMN) {
            if (aggOp.increOp.fn instanceof Builtin && (((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX || ((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX)) {
                for (int r = 0; r < this.rlen; ++r) {
                    double currMaxValue = this.quickGetValue(r, 1);
                    long newMaxIndex = (long)newWithCor.quickGetValue(r, 0);
                    double newMaxValue = newWithCor.quickGetValue(r, 1);
                    double update = aggOp.increOp.fn.execute(newMaxValue, currMaxValue);
                    if (2.0 == update) {
                        long curMaxIndex = (long)this.quickGetValue(r, 0);
                        this.quickSetValue(r, 0, Math.max(curMaxIndex, newMaxIndex));
                        continue;
                    }
                    if (1.0 != update) continue;
                    this.quickSetValue(r, 0, newMaxIndex);
                    this.quickSetValue(r, 1, newMaxValue);
                }
            } else if (aggOp.increOp.fn instanceof KahanPlus) {
                LibMatrixAgg.aggregateBinaryMatrix(newWithCor, this, aggOp);
            } else {
                for (int r = 0; r < this.rlen; ++r) {
                    for (int c = 0; c < this.clen - 1; ++c) {
                        buffer._sum = this.quickGetValue(r, c);
                        buffer._correction = this.quickGetValue(r, c + 1);
                        buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r, c + 1));
                        this.quickSetValue(r, c, buffer._sum);
                        this.quickSetValue(r, c + 1, buffer._correction);
                    }
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTTWOROWS) {
            for (int r = 0; r < this.rlen - 2; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = this.quickGetValue(r + 1, c);
                    buffer._correction = this.quickGetValue(r + 2, c);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r + 1, c);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    this.quickSetValue(r + 1, c, n);
                    this.quickSetValue(r + 2, c, buffer._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTTWOCOLUMNS) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen - 2; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = this.quickGetValue(r, c + 1);
                    buffer._correction = this.quickGetValue(r, c + 2);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r, c + 1);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    this.quickSetValue(r, c + 1, n);
                    this.quickSetValue(r, c + 2, buffer._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTFOURROWS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen - 4; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    cbuff_curr.w = this.quickGetValue(r + 2, c);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = this.quickGetValue(r + 1, c);
                    cbuff_curr.m2._correction = this.quickGetValue(r + 3, c);
                    cbuff_curr.mean._correction = this.quickGetValue(r + 4, c);
                    cbuff_part.w = newWithCor.quickGetValue(r + 2, c);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r + 1, c);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r + 3, c);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r + 4, c);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    this.quickSetValue(r + 1, c, cbuff_curr.mean._sum);
                    this.quickSetValue(r + 2, c, cbuff_curr.w);
                    this.quickSetValue(r + 3, c, cbuff_curr.m2._correction);
                    this.quickSetValue(r + 4, c, cbuff_curr.mean._correction);
                }
            }
        } else if (aggOp.correction == Types.CorrectionLocationType.LASTFOURCOLUMNS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen - 4; ++c) {
                    cbuff_curr.w = this.quickGetValue(r, c + 2);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = this.quickGetValue(r, c + 1);
                    cbuff_curr.m2._correction = this.quickGetValue(r, c + 3);
                    cbuff_curr.mean._correction = this.quickGetValue(r, c + 4);
                    cbuff_part.w = newWithCor.quickGetValue(r, c + 2);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r, c + 1);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r, c + 3);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r, c + 4);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    this.quickSetValue(r, c + 1, cbuff_curr.mean._sum);
                    this.quickSetValue(r, c + 2, cbuff_curr.w);
                    this.quickSetValue(r, c + 3, cbuff_curr.m2._correction);
                    this.quickSetValue(r, c + 4, cbuff_curr.mean._correction);
                }
            }
        } else {
            throw new DMLRuntimeException("unrecognized correctionLocation: " + aggOp.correction);
        }
    }

    @Override
    public MatrixBlock reorgOperations(ReorgOperator op, MatrixValue ret, int startRow, int startColumn, int length) {
        if (!(op.fn instanceof SwapIndex || op.fn instanceof DiagIndex || op.fn instanceof SortIndex || op.fn instanceof RevIndex)) {
            throw new DMLRuntimeException("the current reorgOperations cannot support: " + op.fn.getClass() + ".");
        }
        MatrixBlock result = MatrixBlock.checkType(ret);
        MatrixValue.CellIndex tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        op.fn.computeDimension(this.rlen, this.clen, tempCellIndex);
        long ennz = Math.min(this.nonZeros, (long)tempCellIndex.row * (long)tempCellIndex.column);
        boolean sps = MatrixBlock.evalSparseFormatInMemory(tempCellIndex.row, tempCellIndex.column, ennz);
        if (result == null) {
            result = new MatrixBlock(tempCellIndex.row, tempCellIndex.column, sps, this.nonZeros);
        } else {
            result.reset(tempCellIndex.row, tempCellIndex.column, sps, this.nonZeros);
        }
        if (LibMatrixReorg.isSupportedReorgOperator(op)) {
            LibMatrixReorg.reorg(this, result, op);
        } else {
            MatrixValue.CellIndex temp = new MatrixValue.CellIndex(0, 0);
            if (this.sparse && this.sparseBlock != null) {
                for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                    if (this.sparseBlock.isEmpty(r)) continue;
                    int apos = this.sparseBlock.pos(r);
                    int alen = this.sparseBlock.size(r);
                    int[] aix = this.sparseBlock.indexes(r);
                    double[] avals = this.sparseBlock.values(r);
                    for (int i = apos; i < apos + alen; ++i) {
                        tempCellIndex.set(r, aix[i]);
                        op.fn.execute(tempCellIndex, temp);
                        result.appendValue(temp.row, temp.column, avals[i]);
                    }
                }
            } else if (!this.sparse && this.denseBlock != null) {
                if (result.isInSparseFormat()) {
                    DenseBlock a = this.getDenseBlock();
                    for (int i = 0; i < this.rlen; ++i) {
                        double[] avals = a.values(i);
                        int aix = a.pos(i);
                        for (int j = 0; j < this.clen; ++j) {
                            temp.set(i, j);
                            op.fn.execute(temp, temp);
                            result.appendValue(temp.row, temp.column, avals[aix + j]);
                        }
                    }
                } else {
                    result.allocateDenseBlock();
                    DenseBlock a = this.getDenseBlock();
                    DenseBlock c = result.getDenseBlock();
                    for (int i = 0; i < this.rlen; ++i) {
                        double[] avals = a.values(i);
                        int aix = a.pos(i);
                        for (int j = 0; j < this.clen; ++j) {
                            temp.set(i, j);
                            op.fn.execute(temp, temp);
                            c.set(temp.row, temp.column, avals[aix + j]);
                        }
                    }
                    result.nonZeros = this.nonZeros;
                }
            }
        }
        return result;
    }

    public final MatrixBlock append(MatrixBlock that) {
        return this.append(that, null, true);
    }

    public final MatrixBlock append(MatrixBlock that, boolean cbind) {
        return this.append(that, null, cbind);
    }

    public final MatrixBlock append(MatrixBlock that, MatrixBlock ret) {
        return this.append(that, ret, true);
    }

    public static MatrixBlock append(List<MatrixBlock> that, MatrixBlock ret, boolean cbind, int k) {
        MatrixBlock[] th = new MatrixBlock[that.size() - 1];
        for (int i = 0; i < that.size() - 1; ++i) {
            th[i] = that.get(i + 1);
        }
        return that.get(0).append(th, ret, cbind);
    }

    public final MatrixBlock append(MatrixBlock that, MatrixBlock ret, boolean cbind) {
        return this.append(new MatrixBlock[]{that}, ret, cbind);
    }

    private final long calculateCombinedNNz(MatrixBlock[] that) {
        long nnz = this.nonZeros;
        for (MatrixBlock b : that) {
            nnz += b.nonZeros;
        }
        return nnz;
    }

    private final int combinedRows(MatrixBlock[] that) {
        int r = this.rlen;
        for (MatrixBlock b : that) {
            r += b.rlen;
        }
        return r;
    }

    private final int combinedCols(MatrixBlock[] that) {
        int c = this.clen;
        for (MatrixBlock b : that) {
            c += b.clen;
        }
        return c;
    }

    private final int computeNNzRow(MatrixBlock[] that, int row) {
        int lnnz = (int)this.recomputeNonZeros(row, row, 0, this.clen - 1);
        for (MatrixBlock b : that) {
            lnnz = (int)((long)lnnz + b.recomputeNonZeros(row, row, 0, b.clen - 1));
        }
        return lnnz;
    }

    public MatrixBlock append(MatrixBlock[] that, MatrixBlock result, boolean cbind) {
        this.checkDimensionsForAppend(that, cbind);
        int m = cbind ? this.rlen : this.combinedRows(that);
        int n = cbind ? this.combinedCols(that) : this.clen;
        long nnz = this.calculateCombinedNNz(that);
        boolean shallowCopy = this.nonZeros == nnz;
        boolean sp = MatrixBlock.evalSparseFormatInMemory(m, n, nnz);
        if (result == null) {
            result = new MatrixBlock(m, n, sp, nnz);
        } else {
            result.reset(m, n, sp, nnz);
        }
        if (!result.sparse && nnz != 0L) {
            if (cbind) {
                DenseBlock resd = result.allocateBlock().getDenseBlock();
                MatrixBlock[] in = (MatrixBlock[])ArrayUtils.addAll((Object[])new MatrixBlock[]{this}, (Object[])that);
                for (int i = 0; i < m; ++i) {
                    int off = 0;
                    for (int k = 0; k < in.length; ++k) {
                        if (!in[k].isEmptyBlock(false)) {
                            Block src;
                            if (in[k].sparse) {
                                src = in[k].sparseBlock;
                                if (!((SparseBlock)src).isEmpty(i)) {
                                    int srcpos = ((SparseBlock)src).pos(i);
                                    int srclen = ((SparseBlock)src).size(i);
                                    int[] srcix = ((SparseBlock)src).indexes(i);
                                    double[] srcval = ((SparseBlock)src).values(i);
                                    double[] resval = resd.values(i);
                                    int resix = resd.pos(i, off);
                                    for (int j = srcpos; j < srcpos + srclen; ++j) {
                                        resval[resix + srcix[j]] = srcval[j];
                                    }
                                }
                            } else {
                                src = in[k].getDenseBlock();
                                double[] srcval = ((DenseBlock)src).values(i);
                                double[] resval = resd.values(i);
                                System.arraycopy(srcval, ((DenseBlock)src).pos(i), resval, resd.pos(i, off), in[k].clen);
                            }
                        }
                        off += in[k].clen;
                    }
                }
            } else {
                result.copy(0, this.rlen - 1, 0, n - 1, this, false);
                int off = this.rlen;
                for (int i = 0; i < that.length; ++i) {
                    result.copy(off, off + that[i].rlen - 1, 0, n - 1, that[i], false);
                    off += that[i].rlen;
                }
            }
        } else if (nnz != 0L) {
            int off;
            result.allocateSparseRowsBlock();
            if (cbind && nnz > (long)this.rlen && !shallowCopy && result.getSparseBlock() instanceof SparseBlockMCSR) {
                SparseBlock sblock = result.getSparseBlock();
                for (int i = 0; i < result.rlen; ++i) {
                    sblock.allocate(i, this.computeNNzRow(that, i));
                }
            }
            result.appendToSparse(this, 0, 0, !shallowCopy);
            if (cbind) {
                off = this.clen;
                for (int i = 0; i < that.length; ++i) {
                    result.appendToSparse(that[i], 0, off);
                    off += that[i].clen;
                }
            } else {
                off = this.rlen;
                for (int i = 0; i < that.length; ++i) {
                    result.appendToSparse(that[i], off, 0);
                    off += that[i].rlen;
                }
            }
        }
        result.nonZeros = nnz;
        return result;
    }

    public void checkDimensionsForAppend(MatrixBlock[] in, boolean cbind) {
        if (cbind) {
            for (int i = 0; i < in.length; ++i) {
                if (in[i].rlen == this.rlen) continue;
                throw new DMLRuntimeException("Invalid nRow dimension for append cbind: was " + in[i].rlen + " should be: " + this.rlen);
            }
        } else {
            for (int i = 0; i < in.length; ++i) {
                if (in[i].clen == this.clen) continue;
                throw new DMLRuntimeException("Invalid nCol dimension for append rbind: was " + in[i].clen + " should be: " + this.clen);
            }
        }
    }

    public static MatrixBlock naryOperations(Operator op, MatrixBlock[] matrices, ScalarObject[] scalars, MatrixBlock ret) {
        FunctionObject fn = ((SimpleOperator)op).fn;
        boolean plus = fn instanceof Plus;
        Builtin bfn = !plus ? (Builtin)((SimpleOperator)op).fn : null;
        for (int i = 0; i < matrices.length; ++i) {
            if (!(matrices[i] instanceof CompressedMatrixBlock)) continue;
            matrices[i] = CompressedMatrixBlock.getUncompressed(matrices[i], "Nary operation process add row");
        }
        double init = plus ? 0.0 : (bfn.getBuiltinCode() == Builtin.BuiltinCode.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        for (ScalarObject so : scalars) {
            init = fn.execute(init, so.getDoubleValue());
        }
        int m = matrices.length > 0 ? matrices[0].rlen : 1;
        int n = matrices.length > 0 ? matrices[0].clen : 1;
        long mn = (long)m * (long)n;
        long nnz = !plus && bfn.getBuiltinCode() == Builtin.BuiltinCode.MIN && init < 0.0 || !plus && bfn.getBuiltinCode() == Builtin.BuiltinCode.MAX && init > 0.0 ? mn : Math.min(Arrays.stream(matrices).mapToLong(mb -> mb.nonZeros).sum(), mn);
        boolean sp = MatrixBlock.evalSparseFormatInMemory(m, n, nnz);
        if (ret == null) {
            ret = new MatrixBlock(m, n, sp, nnz);
        } else {
            ret.reset(m, n, sp, nnz);
        }
        if (matrices.length > 0) {
            int[] cnt;
            ret.allocateBlock();
            int[] nArray = cnt = !plus && Arrays.stream(matrices).allMatch(mb -> mb.sparse || mb.isEmpty()) ? new int[n] : null;
            if (ret.isInSparseFormat()) {
                double[] tmp = new double[n];
                for (int i = 0; i < m; ++i) {
                    Arrays.fill(tmp, init);
                    if (plus) {
                        MatrixBlock.processAddRow(matrices, tmp, 0, n, i);
                    } else {
                        MatrixBlock.processMinMaxRow(bfn, matrices, tmp, 0, n, i, cnt);
                    }
                    for (int j = 0; j < n; ++j) {
                        if (tmp[j] == 0.0) continue;
                        ret.appendValue(i, j, tmp[j]);
                    }
                }
            } else {
                DenseBlock c = ret.getDenseBlock();
                long lnnz = 0L;
                for (int i = 0; i < m; ++i) {
                    if (init != 0.0) {
                        Arrays.fill(c.values(i), c.pos(i), c.pos(i) + n, init);
                    }
                    if (plus) {
                        MatrixBlock.processAddRow(matrices, c.values(i), c.pos(i), n, i);
                    } else {
                        MatrixBlock.processMinMaxRow(bfn, matrices, c.values(i), c.pos(i), n, i, cnt);
                    }
                    lnnz += (long)UtilFunctions.countNonZeros(c.values(i), c.pos(i), n);
                }
                ret.setNonZeros(lnnz);
            }
        } else {
            ret.quickSetValue(0, 0, init);
        }
        return ret;
    }

    private static void processAddRow(MatrixBlock[] inputs, double[] c, int cix, int n, int i) {
        for (MatrixBlock in : inputs) {
            Block a;
            if (in.isEmptyBlock(false)) continue;
            if (in.isInSparseFormat()) {
                a = in.getSparseBlock();
                if (((SparseBlock)a).isEmpty(i)) continue;
                LibMatrixMult.vectAdd(((SparseBlock)a).values(i), c, ((SparseBlock)a).indexes(i), ((SparseBlock)a).pos(i), cix, ((SparseBlock)a).size(i));
                continue;
            }
            a = in.getDenseBlock();
            LibMatrixMult.vectAdd(in.getDenseBlock().values(i), c, ((DenseBlock)a).pos(i), cix, n);
        }
    }

    private static void processMinMaxRow(Builtin fn, MatrixBlock[] inputs, double[] c, int cix, int n, int i, int[] cnt) {
        if (cnt != null) {
            Arrays.fill(cnt, 0);
        }
        for (MatrixBlock in : inputs) {
            if (in.isEmptyBlock(false)) continue;
            if (in.isInSparseFormat()) {
                SparseBlock a = in.sparseBlock;
                if (a.isEmpty(i)) continue;
                int alen = a.size(i);
                int apos = a.pos(i);
                int[] aix = a.indexes(i);
                double[] avals = a.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    c[aix[k]] = fn.execute(c[aix[k]], avals[k]);
                    if (cnt == null) continue;
                    int n2 = aix[k];
                    cnt[n2] = cnt[n2] + 1;
                }
                continue;
            }
            double[] avals = in.getDenseBlock().values(i);
            int aix = in.getDenseBlock().pos(i);
            for (int j = 0; j < n; ++j) {
                c[cix + j] = fn.execute(c[cix + j], avals[aix + j]);
            }
        }
        if (Arrays.stream(inputs).allMatch(m -> m.sparse || m.isEmpty())) {
            for (int j = 0; j < n; ++j) {
                if (cnt[j] == inputs.length) continue;
                c[cix + j] = fn.execute(c[cix + j], 0.0);
            }
        }
    }

    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype) {
        return this.transposeSelfMatrixMultOperations(out, tstype, 1);
    }

    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype, int k) {
        int dim;
        if (tstype != MMTSJ.MMTSJType.LEFT && tstype != MMTSJ.MMTSJType.RIGHT) {
            throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
        }
        boolean leftTranspose = tstype == MMTSJ.MMTSJType.LEFT;
        int n = dim = leftTranspose ? this.clen : this.rlen;
        if (out == null) {
            out = new MatrixBlock(dim, dim, false);
        } else {
            out.reset(dim, dim, false);
        }
        MatrixBlock m1 = LibMatrixMult.prepMatrixMultTransposeSelfInput(this, leftTranspose, k > 1);
        if (NativeHelper.isNativeLibraryLoaded()) {
            LibMatrixNative.tsmm(m1, out, leftTranspose, k);
        } else if (k > 1) {
            LibMatrixMult.matrixMultTransposeSelf(m1, out, leftTranspose, k);
        } else {
            LibMatrixMult.matrixMultTransposeSelf(m1, out, leftTranspose);
        }
        return out;
    }

    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype) {
        return this.chainMatrixMultOperations(v, w, out, ctype, 1);
    }

    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype, int k) {
        this.checkMMChain(ctype, v, w);
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (k > 1) {
            LibMatrixMult.matrixMultChain(this, v, w, out, ctype, k);
        } else {
            LibMatrixMult.matrixMultChain(this, v, w, out, ctype);
        }
        return out;
    }

    protected void checkMMChain(MapMultChain.ChainType ctype, MatrixBlock v, MatrixBlock w) {
        if (ctype != MapMultChain.ChainType.XtXv && ctype != MapMultChain.ChainType.XtwXv && ctype != MapMultChain.ChainType.XtXvy) {
            throw new DMLRuntimeException("Invalid mmchain type '" + ctype.toString() + "'.");
        }
        if (this.getNumColumns() != v.getNumRows()) {
            throw new DMLRuntimeException("Dimensions mismatch on mmchain operation (" + this.getNumColumns() + " != " + v.getNumRows() + ")");
        }
        if (v.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input vector (column vector expected, but ncol=" + v.getNumColumns() + ")");
        }
        if (w != null && w.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight vector (column vector expected, but ncol=" + w.getNumColumns() + ")");
        }
    }

    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val) {
        this.permutationMatrixMultOperations(m2Val, out1Val, out2Val, 1);
    }

    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val, int k) {
        MatrixBlock m2 = MatrixBlock.checkType(m2Val);
        MatrixBlock ret1 = MatrixBlock.checkType(out1Val);
        MatrixBlock ret2 = MatrixBlock.checkType(out2Val);
        if (this.rlen != m2.rlen) {
            throw new RuntimeException("Dimensions do not match for permutation matrix multiplication (" + this.rlen + "!=" + m2.rlen + ").");
        }
        if (k > 1) {
            LibMatrixMult.matrixMultPermute(this, m2, ret1, ret2, k);
        } else {
            LibMatrixMult.matrixMultPermute(this, m2, ret1, ret2);
        }
    }

    public final MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, IndexRange ixrange, MatrixBlock ret, MatrixObject.UpdateType update) {
        return this.leftIndexingOperations(rhsMatrix, (int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, ret, update);
    }

    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update) {
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cl >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for matrix indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within matrix dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "].");
        }
        if (ru - rl + 1 != rhsMatrix.getNumRows() || cu - cl + 1 != rhsMatrix.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for matrix indexing: dimensions of the source matrix [" + rhsMatrix.getNumRows() + "x" + rhsMatrix.getNumColumns() + "] do not match the shape of the matrix specified by indices [" + (rl + 1) + ":" + (ru + 1) + ", " + (cl + 1) + ":" + (cu + 1) + "] (i.e., [" + (ru - rl + 1) + "x" + (cu - cl + 1) + "]).");
        }
        MatrixBlock result = ret;
        boolean sp = MatrixBlock.estimateSparsityOnLeftIndexing(this.rlen, this.clen, this.nonZeros, rhsMatrix.getNumRows(), rhsMatrix.getNumColumns(), rhsMatrix.getNonZeros());
        if (!update.isInPlace()) {
            if (result == null) {
                result = new MatrixBlock(this.rlen, this.clen, sp);
            } else {
                result.reset(this.rlen, this.clen, sp);
            }
            result.copy(this, sp);
        } else {
            result = this;
            if (result.sparse && !sp) {
                result.sparseToDense();
            } else if (!result.sparse && sp) {
                result.denseToSparse();
            }
            if (this.requiresInplaceSparseBlockOnLeftIndexing(result.sparse, update, result.nonZeros + rhsMatrix.nonZeros)) {
                result.sparseBlock = SparseBlockFactory.copySparseBlock(DEFAULT_INPLACE_SPARSEBLOCK, result.sparseBlock, false);
            }
        }
        MatrixBlock src = rhsMatrix;
        if (rl == ru && cl == cu) {
            result.quickSetValue(rl, cl, src.quickGetValue(0, 0));
        } else if (!result.isEmptyBlock(false) && result.sparse && (!src.sparse || rl == 0) && result.sparseBlock instanceof SparseBlockCSR) {
            SparseBlockCSR sblock = (SparseBlockCSR)result.sparseBlock;
            if (src.sparse || src.isEmptyBlock(false)) {
                sblock.setIndexRange(rl, ru + 1, cl, cu + 1, src.getSparseBlock());
            } else {
                for (int bi = 0; bi < src.denseBlock.numBlocks(); ++bi) {
                    int rpos = bi * src.denseBlock.blockSize();
                    int blen = src.denseBlock.blockSize(bi);
                    sblock.setIndexRange(rl + rpos, rl + rpos + blen, cl, cu + 1, src.denseBlock.valuesAt(bi), 0, src.rlen * src.clen);
                }
            }
            result.nonZeros = sblock.size();
        } else {
            result.copy(rl, ru, cl, cu, src, true);
        }
        return result;
    }

    public MatrixBlock leftIndexingOperations(ScalarObject scalar, int rl, int cl, MatrixBlock ret, MatrixObject.UpdateType update) {
        double inVal = scalar.getDoubleValue();
        boolean sp = MatrixBlock.estimateSparsityOnLeftIndexing(this.rlen, this.clen, this.nonZeros, 1L, 1L, inVal != 0.0 ? 1L : 0L);
        if (!update.isInPlace()) {
            if (ret == null) {
                ret = new MatrixBlock(this.rlen, this.clen, sp);
            } else {
                ret.reset(this.rlen, this.clen, sp);
            }
            ret.copy(this, sp);
        } else {
            ret = this;
            if (this.requiresInplaceSparseBlockOnLeftIndexing(ret.sparse, update, ret.nonZeros + 1L)) {
                ret.sparseBlock = SparseBlockFactory.copySparseBlock(DEFAULT_INPLACE_SPARSEBLOCK, ret.sparseBlock, false);
            }
        }
        ret.quickSetValue(rl, cl, inVal);
        return ret;
    }

    public final MatrixBlock slice(IndexRange ixrange, MatrixBlock ret) {
        return this.slice((int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, true, ret);
    }

    public final MatrixBlock slice(int rl, int ru) {
        return this.slice(rl, ru, 0, this.clen - 1, true, null);
    }

    public final MatrixBlock slice(int rl, int ru, boolean deep) {
        return this.slice(rl, ru, 0, this.clen - 1, deep, null);
    }

    public final MatrixBlock slice(int rl, int ru, int cl, int cu) {
        return this.slice(rl, ru, cl, cu, true, null);
    }

    public final MatrixBlock slice(int rl, int ru, int cl, int cu, MatrixBlock ret) {
        return this.slice(rl, ru, cl, cu, true, ret);
    }

    public final MatrixBlock slice(int rl, int ru, int cl, int cu, boolean deep) {
        return this.slice(rl, ru, cl, cu, deep, null);
    }

    public MatrixBlock slice(int rl, int ru, int cl, int cu, boolean deep, MatrixBlock ret) {
        boolean result_sparsity;
        this.validateSliceArgument(rl, ru, cl, cu);
        MatrixBlock result = MatrixBlock.checkType(ret);
        long estnnz = (long)((double)this.nonZeros / (double)this.rlen / (double)this.clen * (double)(ru - rl + 1) * (double)(cu - cl + 1));
        boolean bl = result_sparsity = this.sparse && MatrixBlock.evalSparseFormatInMemory(ru - rl + 1, cu - cl + 1, estnnz);
        if (result == null) {
            result = new MatrixBlock(ru - rl + 1, cu - cl + 1, result_sparsity, estnnz);
        } else {
            result.reset(ru - rl + 1, cu - cl + 1, result_sparsity, estnnz);
        }
        if (rl == 0 && ru == this.rlen - 1 && cl == 0 && cu == this.clen - 1) {
            if (deep) {
                result.copy(this);
            } else {
                result = this;
            }
        } else if (this.sparse) {
            this.sliceSparse(rl, ru, cl, cu, deep, result);
        } else {
            this.sliceDense(rl, ru, cl, cu, result);
        }
        return result;
    }

    protected void validateSliceArgument(int rl, int ru, int cl, int cu) {
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cl >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for matrix indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within matrix dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "]");
        }
    }

    private void sliceSparse(int rl, int ru, int cl, int cu, boolean deep, MatrixBlock dest) {
        if (this.isEmptyBlock(false)) {
            return;
        }
        if (cl == cu) {
            dest.allocateDenseBlock();
            double[] c = dest.getDenseBlockValues();
            for (int i = rl; i <= ru; ++i) {
                double val;
                if (this.sparseBlock.isEmpty(i) || (val = this.sparseBlock.get(i, cl)) == 0.0) continue;
                c[i - rl] = val;
                ++dest.nonZeros;
            }
        } else if (cl == 0 && cu == this.clen - 1) {
            boolean ldeep = deep && this.sparseBlock instanceof SparseBlockMCSR;
            for (int i = rl; i <= ru; ++i) {
                dest.appendRow(i - rl, this.sparseBlock.get(i), ldeep);
            }
        } else {
            SparseBlock sblock = this.sparseBlock;
            for (int i = rl; i <= ru; ++i) {
                int astart;
                if (sblock.isEmpty(i)) continue;
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                int n = astart = cl > 0 ? sblock.posFIndexGTE(i, cl) : 0;
                if (astart == -1) continue;
                for (int j = apos + astart; j < apos + alen && aix[j] <= cu; ++j) {
                    dest.appendValue(i - rl, aix[j] - cl, avals[j]);
                }
            }
        }
    }

    private void sliceDense(int rl, int ru, int cl, int cu, MatrixBlock dest) {
        if (this.denseBlock == null) {
            return;
        }
        boolean dedup = this.denseBlock instanceof DenseBlockFP64DEDUP;
        if (dedup && cl != cu) {
            dest.allocateDenseBlock(true, true);
        } else {
            dest.allocateDenseBlock();
        }
        if (cl == cu) {
            if (this.clen == 1) {
                System.arraycopy(this.getDenseBlockValues(), rl, dest.getDenseBlockValues(), 0, ru - rl + 1);
            } else {
                DenseBlock a = this.getDenseBlock();
                double[] c = dest.getDenseBlockValues();
                for (int i = rl; i <= ru; ++i) {
                    c[i - rl] = a.get(i, cl);
                }
            }
        } else {
            DenseBlock a = this.getDenseBlock();
            DenseBlock c = dest.getDenseBlock();
            int len = dest.clen;
            if (dedup) {
                HashMap<double[], double[]> cache = new HashMap<double[], double[]>();
                for (int i = rl; i <= ru; ++i) {
                    double[] row = a.values(i);
                    double[] newRow = (double[])cache.get(row);
                    if (newRow == null) {
                        newRow = new double[len];
                        System.arraycopy(row, cl, newRow, 0, len);
                        cache.put(row, newRow);
                    }
                    c.set(i - rl, newRow);
                }
            } else {
                for (int i = rl; i <= ru; ++i) {
                    System.arraycopy(a.values(i), a.pos(i) + cl, c.values(i - rl), c.pos(i - rl), len);
                }
            }
        }
        dest.setNonZeros(this.getNonZeros() == this.getLength() ? (long)((ru - rl + 1) * (cu - cl + 1)) : dest.recomputeNonZeros());
    }

    @Override
    public void slice(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int blen, int boundaryRlen, int boundaryClen) {
        block15: {
            int c;
            MatrixBlock bottomright;
            MatrixBlock bottomleft;
            MatrixBlock topright;
            MatrixBlock topleft;
            block14: {
                topleft = null;
                topright = null;
                bottomleft = null;
                bottomright = null;
                Iterator<IndexedMatrixValue> p = outlist.iterator();
                int blockRowFactor = blen;
                int blockColFactor = blen;
                if ((long)rowCut > range.rowEnd) {
                    blockRowFactor = boundaryRlen;
                }
                if ((long)colCut > range.colEnd) {
                    blockColFactor = boundaryClen;
                }
                int minrowcut = (int)Math.min((long)rowCut, range.rowEnd);
                int mincolcut = (int)Math.min((long)colCut, range.colEnd);
                int maxrowcut = (int)Math.max((long)rowCut, range.rowStart);
                int maxcolcut = (int)Math.max((long)colCut, range.colStart);
                if (range.rowStart < (long)rowCut && range.colStart < (long)colCut) {
                    topleft = (MatrixBlock)p.next().getValue();
                    topleft.reset(blockRowFactor, blockColFactor, this.estimateSparsityOnSlice(minrowcut - (int)range.rowStart, mincolcut - (int)range.colStart, blockRowFactor, blockColFactor));
                }
                if (range.rowStart < (long)rowCut && range.colEnd >= (long)colCut) {
                    topright = (MatrixBlock)p.next().getValue();
                    topright.reset(blockRowFactor, boundaryClen, this.estimateSparsityOnSlice(minrowcut - (int)range.rowStart, (int)range.colEnd - maxcolcut + 1, blockRowFactor, boundaryClen));
                }
                if (range.rowEnd >= (long)rowCut && range.colStart < (long)colCut) {
                    bottomleft = (MatrixBlock)p.next().getValue();
                    bottomleft.reset(boundaryRlen, blockColFactor, this.estimateSparsityOnSlice((int)range.rowEnd - maxrowcut + 1, mincolcut - (int)range.colStart, boundaryRlen, blockColFactor));
                }
                if (range.rowEnd >= (long)rowCut && range.colEnd >= (long)colCut) {
                    bottomright = (MatrixBlock)p.next().getValue();
                    bottomright.reset(boundaryRlen, boundaryClen, this.estimateSparsityOnSlice((int)range.rowEnd - maxrowcut + 1, (int)range.colEnd - maxcolcut + 1, boundaryRlen, boundaryClen));
                }
                if (!this.sparse || this.sparseBlock == null) break block14;
                int r = (int)range.rowStart;
                while ((long)r < Math.min((long)Math.min(rowCut, this.sparseBlock.numRows()), range.rowEnd + 1L)) {
                    this.sliceHelp(r, range, colCut, topleft, topright, blen - rowCut, blen, blen);
                    ++r;
                }
                while ((long)r <= Math.min(range.rowEnd, (long)(this.sparseBlock.numRows() - 1))) {
                    this.sliceHelp(r, range, colCut, bottomleft, bottomright, -rowCut, blen, blen);
                    ++r;
                }
                break block15;
            }
            if (this.denseBlock == null) break block15;
            double[] a = this.getDenseBlockValues();
            int i = (int)range.rowStart * this.clen;
            int r = (int)range.rowStart;
            while ((long)r < Math.min((long)rowCut, range.rowEnd + 1L)) {
                c = (int)range.colStart;
                while ((long)c < Math.min((long)colCut, range.colEnd + 1L)) {
                    topleft.appendValue(r + blen - rowCut, c + blen - colCut, a[i + c]);
                    ++c;
                }
                while ((long)c <= range.colEnd) {
                    topright.appendValue(r + blen - rowCut, c - colCut, a[i + c]);
                    ++c;
                }
                i += this.clen;
                ++r;
            }
            while ((long)r <= range.rowEnd) {
                c = (int)range.colStart;
                while ((long)c < Math.min((long)colCut, range.colEnd + 1L)) {
                    bottomleft.appendValue(r - rowCut, c + blen - colCut, a[i + c]);
                    ++c;
                }
                while ((long)c <= range.colEnd) {
                    bottomright.appendValue(r - rowCut, c - colCut, a[i + c]);
                    ++c;
                }
                i += this.clen;
                ++r;
            }
        }
    }

    private void sliceHelp(int r, IndexRange range, int colCut, MatrixBlock left, MatrixBlock right, int rowOffset, int normalBlockRowFactor, int normalBlockColFactor) {
        if (this.sparseBlock.isEmpty(r)) {
            return;
        }
        int[] cols = this.sparseBlock.indexes(r);
        double[] values = this.sparseBlock.values(r);
        int start = this.sparseBlock.posFIndexGTE(r, (int)range.colStart);
        if (start < 0) {
            return;
        }
        int end = this.sparseBlock.posFIndexLTE(r, (int)range.colEnd);
        if (end < 0 || start > end) {
            return;
        }
        int pos = this.sparseBlock.pos(r);
        for (int i = start; i <= end; ++i) {
            if (cols[pos + i] < colCut) {
                left.appendValue(r + rowOffset, cols[pos + i] + normalBlockColFactor - colCut, values[pos + i]);
                continue;
            }
            right.appendValue(r + rowOffset, cols[pos + i] - colCut, values[pos + i]);
        }
    }

    @Override
    public void append(MatrixValue v2, ArrayList<IndexedMatrixValue> outlist, int blen, boolean cbind, boolean m2IsLast, int nextNCol) {
        MatrixBlock m2 = (MatrixBlock)v2;
        if (cbind && this.clen == blen || !cbind && this.rlen == blen) {
            ((MatrixBlock)outlist.get(0).getValue()).copy(this);
            ((MatrixBlock)outlist.get(1).getValue()).copy(m2);
        } else if (cbind && this.clen + m2.clen < blen || !cbind && this.rlen + m2.rlen < blen) {
            this.append(m2, (MatrixBlock)outlist.get(0).getValue(), cbind);
        } else {
            MatrixBlock ret1 = (MatrixBlock)outlist.get(0).getValue();
            int lrlen1 = cbind ? this.rlen - 1 : blen - this.rlen - 1;
            int lclen1 = cbind ? blen - this.clen - 1 : this.clen - 1;
            MatrixBlock tmp1 = m2.slice(0, lrlen1, 0, lclen1, new MatrixBlock());
            this.append(tmp1, ret1, cbind);
            MatrixBlock ret2 = (MatrixBlock)outlist.get(1).getValue();
            if (cbind) {
                m2.slice(0, this.rlen - 1, lclen1 + 1, m2.clen - 1, ret2);
            } else {
                m2.slice(lrlen1 + 1, m2.rlen - 1, 0, this.clen - 1, ret2);
            }
        }
    }

    @Override
    public MatrixBlock zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) {
        block29: {
            block28: {
                MatrixBlock.checkType(result);
                double currentSparsity = (double)this.nonZeros / (double)this.rlen / (double)this.clen;
                double estimatedSps = currentSparsity * (double)(range.rowEnd - range.rowStart + 1L) * (double)(range.colEnd - range.colStart + 1L) / (double)this.rlen / (double)this.clen;
                if (!complementary) {
                    estimatedSps = currentSparsity - estimatedSps;
                }
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, (long)(estimatedSps * (double)this.rlen * (double)this.clen));
                if (result == null) {
                    result = new MatrixBlock(this.rlen, this.clen, lsparse, (int)(estimatedSps * (double)this.rlen * (double)this.clen));
                } else {
                    result.reset(this.rlen, this.clen, lsparse, (int)(estimatedSps * (double)this.rlen * (double)this.clen));
                }
                if (!this.sparse) break block28;
                if (this.sparseBlock != null) {
                    int r;
                    if (!complementary) {
                        for (r = 0; r < Math.min((int)range.rowStart, this.sparseBlock.numRows()); ++r) {
                            ((MatrixBlock)result).appendRow(r, this.sparseBlock.get(r));
                        }
                        for (r = Math.min((int)range.rowEnd + 1, this.sparseBlock.numRows()); r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                            ((MatrixBlock)result).appendRow(r, this.sparseBlock.get(r));
                        }
                    }
                    r = (int)range.rowStart;
                    while ((long)r <= Math.min(range.rowEnd, (long)(this.sparseBlock.numRows() - 1))) {
                        if (!this.sparseBlock.isEmpty(r)) {
                            int[] cols = this.sparseBlock.indexes(r);
                            double[] values = this.sparseBlock.values(r);
                            if (complementary) {
                                int end;
                                int start = this.sparseBlock.posFIndexGTE(r, (int)range.colStart);
                                if (start >= 0 && (end = this.sparseBlock.posFIndexGT(r, (int)range.colEnd)) >= 0 && start <= end) {
                                    for (int i = start; i < end; ++i) {
                                        ((MatrixBlock)result).appendValue(r, cols[i], values[i]);
                                    }
                                }
                            } else {
                                int i;
                                int end;
                                int pos = this.sparseBlock.pos(r);
                                int len = this.sparseBlock.size(r);
                                int start = this.sparseBlock.posFIndexGTE(r, (int)range.colStart);
                                if (start < 0) {
                                    start = pos + len;
                                }
                                if ((end = this.sparseBlock.posFIndexGT(r, (int)range.colEnd)) < 0) {
                                    end = pos + len;
                                }
                                for (i = pos; i < start; ++i) {
                                    ((MatrixBlock)result).appendValue(r, cols[i], values[i]);
                                }
                                for (i = end; i < pos + len; ++i) {
                                    ((MatrixBlock)result).appendValue(r, cols[i], values[i]);
                                }
                            }
                        }
                        ++r;
                    }
                }
                break block29;
            }
            if (this.denseBlock == null) break block29;
            double[] a = this.getDenseBlockValues();
            if (complementary) {
                int offset = (int)range.rowStart * this.clen;
                int r = (int)range.rowStart;
                while ((long)r <= range.rowEnd) {
                    int c = (int)range.colStart;
                    while ((long)c <= range.colEnd) {
                        ((MatrixBlock)result).appendValue(r, c, a[offset + c]);
                        ++c;
                    }
                    offset += this.clen;
                    ++r;
                }
            } else {
                int c;
                int r;
                int offset = 0;
                for (r = 0; r < (int)range.rowStart; ++r) {
                    c = 0;
                    while (c < this.clen) {
                        ((MatrixBlock)result).appendValue(r, c, a[offset]);
                        ++c;
                        ++offset;
                    }
                }
                while (r <= (int)range.rowEnd) {
                    for (c = 0; c < (int)range.colStart; ++c) {
                        ((MatrixBlock)result).appendValue(r, c, a[offset + c]);
                    }
                    for (c = (int)range.colEnd + 1; c < this.clen; ++c) {
                        ((MatrixBlock)result).appendValue(r, c, a[offset + c]);
                    }
                    offset += this.clen;
                    ++r;
                }
                while (r < this.rlen) {
                    c = 0;
                    while (c < this.clen) {
                        ((MatrixBlock)result).appendValue(r, c, a[offset]);
                        ++c;
                        ++offset;
                    }
                    ++r;
                }
            }
        }
        return (MatrixBlock)result;
    }

    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn, boolean inCP) {
        return LibMatrixAgg.aggregateUnaryMatrix(op, this, result, blen, indexesIn, inCP);
    }

    public void dropLastRowsOrColumns(Types.CorrectionLocationType correctionLocation) {
        int step = correctionLocation.getNumRemovedRowsColumns();
        if (step <= 0) {
            return;
        }
        if (correctionLocation == Types.CorrectionLocationType.LASTROW || correctionLocation == Types.CorrectionLocationType.LASTTWOROWS || correctionLocation == Types.CorrectionLocationType.LASTFOURROWS) {
            if (this.sparse && this.sparseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(1, this.rlen - 1, 0, this.clen - 1);
                this.sparseBlock = SparseBlockFactory.createSparseBlock(DEFAULT_SPARSEBLOCK, this.sparseBlock.get(0));
            } else if (!this.sparse && this.denseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(1, this.rlen - 1, 0, this.clen - 1);
                DenseBlock tmp = DenseBlockFactory.createDenseBlock(1, this.clen);
                tmp.set(0, this.getDenseBlockValues());
                this.denseBlock = tmp;
            }
            this.rlen -= step;
        } else if (correctionLocation == Types.CorrectionLocationType.LASTCOLUMN || correctionLocation == Types.CorrectionLocationType.LASTTWOCOLUMNS || correctionLocation == Types.CorrectionLocationType.LASTFOURCOLUMNS) {
            if (this.sparse && this.sparseBlock != null) {
                double[] tmp = new double[this.rlen];
                int lnnz = 0;
                for (int i = 0; i < this.rlen; ++i) {
                    tmp[i] = this.sparseBlock.get(i, 0);
                    lnnz += tmp[i] != 0.0 ? 1 : 0;
                }
                this.cleanupBlock(true, true);
                this.sparse = false;
                this.denseBlock = DenseBlockFactory.createDenseBlock(tmp, this.rlen, 1);
                this.nonZeros = lnnz;
            } else if (!this.sparse && this.denseBlock != null) {
                double[] tmp = new double[this.rlen];
                double[] a = this.getDenseBlockValues();
                int lnnz = 0;
                int i = 0;
                int aix = 0;
                while (i < this.rlen) {
                    tmp[i] = a[aix];
                    lnnz += tmp[i] != 0.0 ? 1 : 0;
                    ++i;
                    aix += this.clen;
                }
                this.denseBlock = DenseBlockFactory.createDenseBlock(tmp, this.rlen, 1);
                this.nonZeros = lnnz;
            }
            this.clen -= step;
        }
    }

    public CM_COV_Object cmOperations(CMOperator op) {
        MatrixBlock.checkCMOperations(this, op);
        return LibMatrixAgg.aggregateCmCov(this, null, null, op.fn, op.getNumThreads());
    }

    public static void checkCMOperations(MatrixBlock mb, CMOperator op) {
        if (mb.getNumColumns() != 1) {
            throw new DMLRuntimeException("Central Moment cannot be computed on [" + mb.getNumRows() + "," + mb.getNumColumns() + "] matrix.");
        }
    }

    public CM_COV_Object cmOperations(CMOperator op, MatrixBlock weights) {
        if (this.getNumColumns() != 1 || weights.getNumColumns() != 1) {
            throw new DMLRuntimeException("Central Moment can be computed only on 1-dimensional column matrices.");
        }
        if (this.getNumRows() != weights.getNumRows() || this.getNumColumns() != weights.getNumColumns()) {
            throw new DMLRuntimeException("Covariance: Mismatching dimensions between input and weight matrices - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + weights.getNumRows() + "," + weights.getNumColumns() + "]");
        }
        return LibMatrixAgg.aggregateCmCov(this, weights, null, op.fn, op.getNumThreads());
    }

    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that) {
        if (this.getNumColumns() != 1 || that.getNumColumns() != 1) {
            throw new DMLRuntimeException("Covariance can be computed only on 1-dimensional column matrices.");
        }
        if (this.getNumRows() != that.getNumRows() || this.getNumColumns() != that.getNumColumns()) {
            throw new DMLRuntimeException("Covariance: Mismatching input matrix dimensions - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + that.getNumRows() + "," + that.getNumColumns() + "]");
        }
        return LibMatrixAgg.aggregateCmCov(this, that, null, op.fn, op.getNumThreads());
    }

    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that, MatrixBlock weights) {
        if (this.getNumColumns() != 1 || that.getNumColumns() != 1 || weights.getNumColumns() != 1) {
            throw new DMLRuntimeException("Covariance can be computed only on 1-dimensional column matrices.");
        }
        if (this.getNumRows() != that.getNumRows() || this.getNumColumns() != that.getNumColumns()) {
            throw new DMLRuntimeException("Covariance: Mismatching input matrix dimensions - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + that.getNumRows() + "," + that.getNumColumns() + "]");
        }
        if (this.getNumRows() != weights.getNumRows() || this.getNumColumns() != weights.getNumColumns()) {
            throw new DMLRuntimeException("Covariance: Mismatching dimensions between input and weight matrices - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + weights.getNumRows() + "," + weights.getNumColumns() + "]");
        }
        return LibMatrixAgg.aggregateCmCov(this, that, weights, op.fn, op.getNumThreads());
    }

    public final MatrixBlock sortOperations() {
        return this.sortOperations(null, null);
    }

    public final MatrixBlock sortOperations(MatrixValue weights) {
        return this.sortOperations(weights, null);
    }

    public MatrixBlock sortOperations(MatrixValue weights, MatrixBlock result) {
        return this.sortOperations(weights, result, 1);
    }

    public MatrixBlock sortOperations(MatrixValue weights, MatrixBlock result, int k) {
        int i;
        boolean wtflag = weights != null;
        MatrixBlock wts = weights == null ? null : MatrixBlock.checkType(weights);
        MatrixBlock.checkType(result);
        if (this.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input dimensions (" + this.getNumRows() + "x" + this.getNumColumns() + ") to sort operation.");
        }
        if (wts != null && wts.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight dimensions (" + wts.getNumRows() + "x" + wts.getNumColumns() + ") to sort operation.");
        }
        int dim1 = (int)(1L + this.getNonZeros());
        if (result == null) {
            result = new MatrixBlock(dim1, 2, false);
        } else {
            result.reset(dim1, 2, false);
        }
        MatrixBlock tdw = new MatrixBlock(dim1, 2, false);
        double zero_wt = 0.0;
        int ind = 1;
        if (wtflag) {
            for (i = 0; i < this.rlen; ++i) {
                double d = this.quickGetValue(i, 0);
                double w = wts.quickGetValue(i, 0);
                if (d != 0.0) {
                    tdw.quickSetValue(ind, 0, d);
                    tdw.quickSetValue(ind, 1, w);
                    ++ind;
                    continue;
                }
                zero_wt += w;
            }
        } else {
            zero_wt = (long)this.getNumRows() - this.getNonZeros();
            for (i = 0; i < this.rlen; ++i) {
                double d = this.quickGetValue(i, 0);
                if (d == 0.0) continue;
                tdw.quickSetValue(ind, 0, d);
                tdw.quickSetValue(ind, 1, 1.0);
                ++ind;
            }
        }
        tdw.quickSetValue(0, 0, 0.0);
        tdw.quickSetValue(0, 1, zero_wt);
        SortIndex sfn = new SortIndex(1, false, false);
        ReorgOperator rop = new ReorgOperator(sfn, k);
        LibMatrixReorg.reorg(tdw, result, rop);
        return result;
    }

    public double interQuartileMean() {
        double psum;
        double sum_wt = this.sumWeightForQuantile();
        double q25d = 0.25 * sum_wt;
        double q75d = 0.75 * sum_wt;
        int q25i = (int)Math.ceil(q25d);
        int q75i = (int)Math.ceil(q75d);
        int i = -1;
        for (psum = 0.0; psum < (double)q25i && i < this.getNumRows(); psum += this.quickGetValue(++i, 1)) {
        }
        double q25Part = psum - q25d;
        double q25Val = this.quickGetValue(i, 0);
        double sum = 0.0;
        while (psum < (double)q75i && i < this.getNumRows()) {
            double v1 = this.quickGetValue(++i, 0);
            double v2 = this.quickGetValue(i, 1);
            psum += v2;
            sum += v1 * v2;
        }
        double q75Part = psum - q75d;
        double q75Val = this.quickGetValue(i, 0);
        return MatrixBlock.computeIQMCorrection(sum, sum_wt, q25Part, q25Val, q75Part, q75Val);
    }

    public static double computeIQMCorrection(double sum, double sum_wt, double q25Part, double q25Val, double q75Part, double q75Val) {
        return (sum + q25Part * q25Val - q75Part * q75Val) / (sum_wt * 0.5);
    }

    public MatrixBlock pickValues(MatrixValue quantiles, MatrixValue ret) {
        MatrixBlock qs = MatrixBlock.checkType(quantiles);
        if (qs.clen != 1) {
            throw new DMLRuntimeException("Multiple quantiles can only be computed on a 1D matrix");
        }
        MatrixBlock output = MatrixBlock.checkType(ret);
        if (output == null) {
            output = new MatrixBlock(qs.rlen, qs.clen, false);
        } else {
            output.reset(qs.rlen, qs.clen, false);
        }
        for (int i = 0; i < qs.rlen; ++i) {
            output.quickSetValue(i, 0, this.pickValue(qs.quickGetValue(i, 0)));
        }
        return output;
    }

    public double median() {
        double sum_wt = this.sumWeightForQuantile();
        return this.pickValue(0.5, sum_wt % 2.0 == 0.0);
    }

    public final double pickValue(double quantile) {
        return this.pickValue(quantile, false);
    }

    public double pickValue(double quantile, boolean average) {
        double sum_wt = this.sumWeightForQuantile();
        average = average && sum_wt % 2.0 == 0.0;
        int pos = (int)Math.ceil(quantile * sum_wt);
        int t = 0;
        int i = -1;
        while ((t = (int)((double)t + this.quickGetValue(++i, 1))) < pos && i < this.getNumRows()) {
        }
        if (this.quickGetValue(i, 1) != 0.0) {
            if (average) {
                if (pos < t) {
                    return this.quickGetValue(i, 0);
                }
                if (this.quickGetValue(i + 1, 1) != 0.0) {
                    return (this.quickGetValue(i, 0) + this.quickGetValue(i + 1, 0)) / 2.0;
                }
                return (this.quickGetValue(i, 0) + this.quickGetValue(i + 2, 0)) / 2.0;
            }
            return this.quickGetValue(i, 0);
        }
        if (i + 1 < this.getNumRows()) {
            return this.quickGetValue(i + 1, 0);
        }
        return this.quickGetValue(i - 1, 0);
    }

    public double sumWeightForQuantile() {
        double sum_wt = 0.0;
        for (int i = 0; i < this.getNumRows(); ++i) {
            double tmp = this.quickGetValue(i, 1);
            sum_wt += tmp;
            if (!(Math.floor(tmp) < tmp)) continue;
            throw new DMLRuntimeException("Wrong input data, quantile weights are expected to be integers but found '" + tmp + "'.");
        }
        return sum_wt;
    }

    public final MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, AggregateBinaryOperator op) {
        return this.aggregateBinaryOperations(m1, m2, null, op);
    }

    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op) {
        this.checkAggregateBinaryOperations(m1, m2, op);
        int k = op.getNumThreads();
        if (NativeHelper.isNativeLibraryLoaded()) {
            return LibMatrixNative.matrixMult(m1, m2, ret, k);
        }
        return LibMatrixMult.matrixMult(m1, m2, ret, k);
    }

    protected void checkAggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, AggregateBinaryOperator op) {
        if (m1.clen != m2.rlen) {
            throw new RuntimeException("Dimensions do not match for matrix multiplication (" + m1.clen + "!=" + m2.rlen + ").");
        }
        this.checkAggregateBinaryOperationsCommon(m1, m2, op);
    }

    protected void checkAggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, AggregateBinaryOperator op, boolean transposeLeft, boolean transposeRight) {
        if ((transposeLeft ? m1.rlen : m1.clen) != (transposeRight ? m2.clen : m2.rlen)) {
            throw new RuntimeException("Dimensions do not match for matrix multiplication (" + m1.clen + "!=" + m2.rlen + ").");
        }
        this.checkAggregateBinaryOperationsCommon(m1, m2, op);
    }

    private void checkAggregateBinaryOperationsCommon(MatrixBlock m1, MatrixBlock m2, AggregateBinaryOperator op) {
        if (!(op.binaryFn instanceof Multiply) || !(op.aggOp.increOp.fn instanceof Plus)) {
            throw new DMLRuntimeException("Unsupported binary aggregate operation: (" + op.binaryFn + ", " + op.aggOp + ").");
        }
        if (m1 != this && m2 != this) {
            throw new DMLRuntimeException("Invalid aggregateBinaryOperatio: one of either input should be this");
        }
    }

    public static MatrixBlock aggregateTernaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        int cl;
        if (m1 instanceof CompressedMatrixBlock || m2 instanceof CompressedMatrixBlock || m3 instanceof CompressedMatrixBlock) {
            return CLALibAggTernaryOp.agg(m1, m2, m3, ret, op, inCP);
        }
        int rl = op.indexFn instanceof ReduceRow ? 2 : 1;
        int n = cl = op.indexFn instanceof ReduceRow ? m1.clen : 2;
        if (ret == null) {
            ret = new MatrixBlock(rl, cl, false);
        } else {
            ret.reset(rl, cl, false);
        }
        ret = op.getNumThreads() > 1 ? LibMatrixAgg.aggregateTernary(m1, m2, m3, ret, op, op.getNumThreads()) : LibMatrixAgg.aggregateTernary(m1, m2, m3, ret, op);
        if (op.aggOp.existsCorrection() && inCP) {
            ret.dropLastRowsOrColumns(op.aggOp.correction);
        }
        return ret;
    }

    public MatrixBlock uaggouterchainOperations(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        double[] bv = DataConverter.convertToDoubleVector(mbRight);
        int[] bvi = null;
        if (LibMatrixOuterAgg.isSupportedUaggOp(uaggOp, bOp)) {
            int iCols;
            if (LibMatrixOuterAgg.isRowIndexMax(uaggOp) || LibMatrixOuterAgg.isRowIndexMin(uaggOp)) {
                bvi = LibMatrixOuterAgg.prepareRowIndices(bv.length, bv, bOp, uaggOp);
            } else {
                Arrays.sort(bv);
            }
            int iRows = uaggOp.indexFn instanceof ReduceCol ? mbLeft.getNumRows() : 2;
            int n = iCols = uaggOp.indexFn instanceof ReduceRow ? mbLeft.getNumColumns() : 2;
            if (mbOut == null) {
                mbOut = new MatrixBlock(iRows, iCols, false);
            } else {
                mbOut.reset(iRows, iCols, false);
            }
        } else {
            throw new DMLRuntimeException("Unsupported operator for unary aggregate operations.");
        }
        LibMatrixOuterAgg.aggregateMatrix(mbLeft, mbOut, bv, bvi, bOp, uaggOp);
        return mbOut;
    }

    public final MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op) {
        return this.groupedAggOperations(tgt, wghts, ret, ngroups, op, 1);
    }

    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op, int k) {
        boolean validMatrixOp;
        MatrixBlock target = MatrixBlock.checkType(tgt);
        MatrixBlock weights = MatrixBlock.checkType(wghts);
        boolean bl = validMatrixOp = weights == null && ngroups >= 1;
        if (this.getNumColumns() != 1 || weights != null && weights.getNumColumns() != 1) {
            throw new DMLRuntimeException("groupedAggregate can only operate on 1-dimensional column matrices for groups and weights.");
        }
        if (target.getNumColumns() != 1 && op instanceof CMOperator && !validMatrixOp) {
            throw new DMLRuntimeException("groupedAggregate can only operate on 1-dimensional column matrices for target (for this aggregation function).");
        }
        if (target.getNumColumns() != 1 && target.getNumRows() != 1 && !validMatrixOp) {
            throw new DMLRuntimeException("groupedAggregate can only operate on 1-dimensional column or row matrix for target.");
        }
        if (this.getNumRows() != target.getNumRows() && this.getNumRows() != Math.max(target.getNumRows(), target.getNumColumns()) || weights != null && this.getNumRows() != weights.getNumRows()) {
            throw new DMLRuntimeException("groupedAggregate can only operate on matrices with equal dimensions.");
        }
        if (ngroups <= 0) {
            double min = this.min();
            double max = this.max();
            if (min <= 0.0) {
                throw new DMLRuntimeException("Invalid value (" + min + ") encountered in 'groups' while computing groupedAggregate");
            }
            if (max <= 0.0) {
                throw new DMLRuntimeException("Invalid value (" + max + ") encountered in 'groups' while computing groupedAggregate.");
            }
            ngroups = (int)max;
        }
        boolean rowVector = target.getNumRows() == 1 && target.getNumColumns() > 1;
        MatrixBlock result = MatrixBlock.checkType(ret);
        boolean result_sparsity = MatrixBlock.estimateSparsityOnGroupedAgg(this.rlen, ngroups);
        if (result == null) {
            result = new MatrixBlock(ngroups, rowVector ? 1 : target.getNumColumns(), result_sparsity);
        } else {
            result.reset(ngroups, rowVector ? 1 : target.getNumColumns(), result_sparsity);
        }
        if (k > 1) {
            LibMatrixAgg.groupedAggregate(this, target, weights, result, ngroups, op, k);
        } else {
            LibMatrixAgg.groupedAggregate(this, target, weights, result, ngroups, op);
        }
        return result;
    }

    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn, MatrixBlock select) {
        return LibMatrixReorg.rmempty(this, ret, rows, emptyReturn, select);
    }

    public final MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn) {
        return this.removeEmptyOperations(ret, rows, emptyReturn, null);
    }

    public MatrixBlock rexpandOperations(MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) {
        MatrixBlock result = MatrixBlock.checkType(ret);
        return LibMatrixReorg.rexpand(this, result, max, rows, cast, ignore, k);
    }

    @Override
    public MatrixBlock replaceOperations(MatrixValue result, double pattern, double replacement) {
        MatrixBlock ret = MatrixBlock.checkType(result);
        this.examSparsity();
        if (ret != null) {
            ret.reset(this.rlen, this.clen, this.sparse);
        } else {
            ret = new MatrixBlock(this.rlen, this.clen, this.sparse);
        }
        if (this.nonZeros == 0L && pattern != 0.0) {
            return ret;
        }
        if (!this.containsValue(pattern)) {
            return this;
        }
        if (this.isEmpty() && pattern == 0.0) {
            ret.reset(this.rlen, this.clen, replacement);
            return ret;
        }
        boolean NaNpattern = Double.isNaN(pattern);
        if (this.sparse) {
            if (pattern != 0.0) {
                ret.allocateSparseRowsBlock();
                SparseBlock a = this.sparseBlock;
                SparseBlock c = ret.sparseBlock;
                for (int i = 0; i < this.rlen; ++i) {
                    if (a.isEmpty(i)) continue;
                    c.allocate(i);
                    int apos = a.pos(i);
                    int alen = a.size(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        double val = avals[j];
                        if (val == pattern || NaNpattern && Double.isNaN(val)) {
                            c.append(i, aix[j], replacement);
                            continue;
                        }
                        c.append(i, aix[j], val);
                    }
                }
            } else {
                ret.sparse = false;
                ret.allocateDenseBlock();
                SparseBlock a = this.sparseBlock;
                DenseBlock c = ret.getDenseBlock();
                c.reset(this.rlen, this.clen, replacement);
                if (a != null) {
                    for (int i = 0; i < this.rlen; ++i) {
                        if (a.isEmpty(i)) continue;
                        int apos = a.pos(i);
                        int cpos = c.pos(i);
                        int alen = a.size(i);
                        int[] aix = a.indexes(i);
                        double[] avals = a.values(i);
                        double[] cvals = c.values(i);
                        for (int j = apos; j < apos + alen; ++j) {
                            if (avals[j] == 0.0) continue;
                            cvals[cpos + aix[j]] = avals[j];
                        }
                    }
                }
            }
        } else {
            DenseBlock a = this.getDenseBlock();
            DenseBlock c = ret.allocateDenseBlock().getDenseBlock();
            for (int bi = 0; bi < a.numBlocks(); ++bi) {
                int len = a.size(bi);
                double[] avals = a.valuesAt(bi);
                double[] cvals = c.valuesAt(bi);
                for (int i = 0; i < len; ++i) {
                    cvals[i] = avals[i] == pattern || NaNpattern && Double.isNaN(avals[i]) ? replacement : avals[i];
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return ret;
    }

    public MatrixBlock extractTriangular(MatrixBlock ret, boolean lower, boolean diag, boolean values) {
        ret.reset(this.rlen, this.clen, this.sparse);
        if (this.isEmptyBlock(false)) {
            return ret;
        }
        ret.allocateBlock();
        long nnz = 0L;
        if (this.sparse) {
            SparseBlock a = this.sparseBlock;
            SparseBlock c = ret.sparseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                if (a.isEmpty(i)) continue;
                int jbeg = Math.min(lower ? 0 : (diag ? i : i + 1), this.clen);
                int jend = Math.min(lower ? (diag ? i + 1 : i) : this.clen, this.clen);
                if (values) {
                    int k1 = a.posFIndexGTE(i, jbeg);
                    int k2 = a.posFIndexGTE(i, jend);
                    k1 = k1 >= 0 ? k1 : a.size(i);
                    k2 = k2 >= 0 ? k2 : a.size(i);
                    int apos = a.pos(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    c.allocate(i, k2 - k1);
                    for (int k = apos + k1; k < apos + k2; ++k) {
                        ret.appendValue(i, aix[k], avals[k]);
                    }
                    continue;
                }
                c.allocate(i, jend - jbeg);
                for (int j = jbeg; j < jend; ++j) {
                    ret.appendValue(i, j, 1.0);
                }
            }
        } else {
            DenseBlock a = this.denseBlock;
            DenseBlock c = ret.getDenseBlock();
            for (int i = 0; i < this.rlen; ++i) {
                int jbeg = Math.min(lower ? 0 : (diag ? i : i + 1), this.clen);
                int jend = Math.min(lower ? (diag ? i + 1 : i) : this.clen, this.clen);
                double[] avals = a.values(i);
                double[] cvals = c.values(i);
                int aix = a.pos(i, jbeg);
                int cix = c.pos(i, jbeg);
                if (values) {
                    System.arraycopy(avals, aix, cvals, cix, jend - jbeg);
                    nnz += (long)UtilFunctions.countNonZeros(avals, aix, jend - jbeg);
                    continue;
                }
                Arrays.fill(cvals, cix, cix + (jend - jbeg), 1.0);
                nnz += (long)(jend - jbeg);
            }
        }
        ret.setNonZeros(nnz);
        ret.examSparsity();
        return ret;
    }

    @Override
    public void ctableOperations(Operator op, double scalarThat, MatrixValue that2Val, CTableMap resultMap, MatrixBlock resultBlock) {
        MatrixBlock that2 = MatrixBlock.checkType(that2Val);
        CTable ctable = CTable.getCTableFnObject();
        double v2 = scalarThat;
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double v1 = this.quickGetValue(i, j);
                double w = that2.quickGetValue(i, j);
                ctable.execute(v1, v2, w, false, resultMap, resultBlock);
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public void ctableOperations(Operator op, double scalarThat, double scalarThat2, CTableMap resultMap, MatrixBlock resultBlock) {
        CTable ctable = CTable.getCTableFnObject();
        double v2 = scalarThat;
        double w = scalarThat2;
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double v1 = this.quickGetValue(i, j);
                ctable.execute(v1, v2, w, false, resultMap, resultBlock);
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public void ctableOperations(Operator op, MatrixIndexes ix1, double scalarThat, boolean left, int blen, CTableMap resultMap, MatrixBlock resultBlock) {
        CTable ctable = CTable.getCTableFnObject();
        double w = scalarThat;
        int offset = (int)((ix1.getRowIndex() - 1L) * (long)blen);
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double v1 = this.quickGetValue(i, j);
                if (left) {
                    ctable.execute((double)(offset + i + 1), v1, w, false, resultMap, resultBlock);
                    continue;
                }
                ctable.execute(v1, (double)(offset + i + 1), w, false, resultMap, resultBlock);
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue thatVal, double scalarThat2, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        MatrixBlock that = MatrixBlock.checkType(thatVal);
        if (that instanceof CompressedMatrixBlock) {
            that = ((CompressedMatrixBlock)that).getUncompressed("CTable " + op);
        }
        CTable ctable = CTable.getCTableFnObject();
        double w = scalarThat2;
        if (ignoreZeros && this.sparse && that.sparse) {
            if (this.isEmptyBlock(false) && that.isEmptyBlock(false)) {
                return;
            }
            SparseBlock a = this.sparseBlock;
            SparseBlock b = that.sparseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                if (a.isEmpty(i)) continue;
                int alen = a.size(i);
                int apos = a.pos(i);
                double[] avals = a.values(i);
                int bpos = b.pos(i);
                double[] bvals = b.values(i);
                for (int j = 0; j < alen; ++j) {
                    ctable.execute(avals[apos + j], bvals[bpos + j], w, ignoreZeros, resultMap, resultBlock);
                }
            }
        } else {
            for (int i = 0; i < this.rlen; ++i) {
                for (int j = 0; j < this.clen; ++j) {
                    double v1 = this.quickGetValue(i, j);
                    double v2 = that.quickGetValue(i, j);
                    ctable.execute(v1, v2, w, ignoreZeros, resultMap, resultBlock);
                }
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    public MatrixBlock ctableSeqOperations(MatrixValue thatMatrix, double thatScalar, MatrixBlock ret, boolean updateClen) {
        MatrixBlock that = MatrixBlock.checkType(thatMatrix);
        CTable ctable = CTable.getCTableFnObject();
        double w = thatScalar;
        int[] rptr = new int[this.rlen + 1];
        int[] indexes = new int[this.rlen];
        double[] values = new double[this.rlen];
        int maxCol = 0;
        for (int i = 0; i < this.rlen; ++i) {
            double v2 = that.quickGetValue(i, 0);
            maxCol = ctable.execute(i + 1, v2, w, maxCol, indexes, values);
            rptr[i] = i;
        }
        rptr[this.rlen] = this.rlen;
        ret.sparseBlock = new SparseBlockCSR(rptr, indexes, values, this.rlen);
        ((SparseBlockCSR)ret.sparseBlock).compact();
        ret.setNonZeros(ret.sparseBlock.size());
        if (updateClen) {
            ret.clen = maxCol;
        }
        return ret;
    }

    public final MatrixBlock ctableSeqOperations(MatrixValue thatMatrix, double thatScalar, MatrixBlock resultBlock) {
        return this.ctableSeqOperations(thatMatrix, thatScalar, resultBlock, true);
    }

    public final void ctableOperations(Operator op, MatrixValue thatVal, MatrixValue that2Val, CTableMap resultMap) {
        this.ctableOperations(op, thatVal, that2Val, resultMap, null);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue thatVal, MatrixValue that2Val, CTableMap resultMap, MatrixBlock resultBlock) {
        MatrixBlock that = MatrixBlock.checkType(thatVal);
        MatrixBlock that2 = MatrixBlock.checkType(that2Val);
        CTable ctable = CTable.getCTableFnObject();
        int k = OptimizerUtils.getTransformNumThreads();
        if (resultBlock == null) {
            if (k > 1 && this.clen == 1) {
                ctable.execute(this, that, that2, resultMap, k);
            } else {
                for (int i = 0; i < this.rlen; ++i) {
                    for (int j = 0; j < this.clen; ++j) {
                        double v1 = this.quickGetValue(i, j);
                        double v2 = that.quickGetValue(i, j);
                        double w = that2.quickGetValue(i, j);
                        ctable.execute(v1, v2, w, false, resultMap);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.rlen; ++i) {
                for (int j = 0; j < this.clen; ++j) {
                    double v1 = this.quickGetValue(i, j);
                    double v2 = that.quickGetValue(i, j);
                    double w = that2.quickGetValue(i, j);
                    ctable.execute(v1, v2, w, false, resultBlock);
                }
            }
            resultBlock.recomputeNonZeros();
        }
    }

    public final MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out) {
        return this.quaternaryOperations(qop, um, vm, wm, out, 1);
    }

    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock U, MatrixBlock V, MatrixBlock wm, MatrixBlock out, int k) {
        MatrixBlock W;
        if (this.getNumRows() != U.getNumRows()) {
            throw new DMLRuntimeException("Dimension mismatch rows on quaternary operation: " + this.getNumRows() + "!=" + U.getNumRows());
        }
        if (this.getNumColumns() != V.getNumRows()) {
            throw new DMLRuntimeException("Dimension mismatch columns quaternary operation: " + this.getNumColumns() + "!=" + V.getNumRows());
        }
        MatrixBlock X = this;
        MatrixBlock R = MatrixBlock.checkType(out);
        if (qop.wtype1 != null || qop.wtype4 != null) {
            R.reset(1, 1, false);
        } else if (qop.wtype2 != null || qop.wtype5 != null) {
            R.reset(this.rlen, this.clen, this.sparse);
        } else if (qop.wtype3 != null) {
            MatrixCharacteristics mc = qop.wtype3.computeOutputCharacteristics(X.rlen, X.clen, U.clen);
            R.reset((int)((DataCharacteristics)mc).getRows(), (int)((DataCharacteristics)mc).getCols(), qop.wtype3.isBasic() ? X.isInSparseFormat() : false);
        }
        if (qop.wtype1 != null) {
            MatrixBlock matrixBlock = W = qop.wtype1.hasFourInputs() ? MatrixBlock.checkType(wm) : null;
            if (k > 1) {
                LibMatrixMult.matrixMultWSLoss(X, U, V, W, R, qop.wtype1, k);
            } else {
                LibMatrixMult.matrixMultWSLoss(X, U, V, W, R, qop.wtype1);
            }
        } else if (qop.wtype2 != null) {
            if (k > 1) {
                LibMatrixMult.matrixMultWSigmoid(X, U, V, R, qop.wtype2, k);
            } else {
                LibMatrixMult.matrixMultWSigmoid(X, U, V, R, qop.wtype2);
            }
        } else if (qop.wtype3 != null) {
            MatrixBlock matrixBlock = W = qop.wtype3.hasFourInputs() ? MatrixBlock.checkType(wm) : null;
            if (qop.getScalar() != 0.0) {
                W = new MatrixBlock(qop.getScalar());
            }
            if (k > 1) {
                LibMatrixMult.matrixMultWDivMM(X, U, V, W, R, qop.wtype3, k);
            } else {
                LibMatrixMult.matrixMultWDivMM(X, U, V, W, R, qop.wtype3);
            }
        } else if (qop.wtype4 != null) {
            double eps;
            W = qop.wtype4.hasFourInputs() ? MatrixBlock.checkType(wm) : null;
            double d = eps = W != null && W.getNumRows() == 1 && W.getNumColumns() == 1 ? W.quickGetValue(0, 0) : qop.getScalar();
            if (k > 1) {
                LibMatrixMult.matrixMultWCeMM(X, U, V, eps, R, qop.wtype4, k);
            } else {
                LibMatrixMult.matrixMultWCeMM(X, U, V, eps, R, qop.wtype4);
            }
        } else if (qop.wtype5 != null) {
            if (k > 1) {
                LibMatrixMult.matrixMultWuMM(X, U, V, R, qop.wtype5, qop.fn, k);
            } else {
                LibMatrixMult.matrixMultWuMM(X, U, V, R, qop.wtype5, qop.fn);
            }
        }
        return R;
    }

    public static MatrixBlock randOperations(int rows, int cols, double sparsity, double min, double max, String pdf, long seed) {
        return MatrixBlock.randOperations(rows, cols, sparsity, min, max, pdf, seed, 1);
    }

    public static MatrixBlock randOperations(int rows, int cols, double sparsity, double min, double max, String pdf, long seed, int k) {
        RandomMatrixGenerator rgen = new RandomMatrixGenerator(pdf, rows, cols, ConfigurationManager.getBlocksize(), sparsity, min, max);
        if (k > 1) {
            return MatrixBlock.randOperations(rgen, seed, k);
        }
        return MatrixBlock.randOperations(rgen, seed);
    }

    public static MatrixBlock randOperations(RandomMatrixGenerator rgen, long seed) {
        return MatrixBlock.randOperations(rgen, seed, 1);
    }

    public static MatrixBlock randOperations(RandomMatrixGenerator rgen, long seed, int k) {
        MatrixBlock out = new MatrixBlock();
        Well1024a bigrand = null;
        if (!LibMatrixDatagen.isShortcutRandOperation(rgen._min, rgen._max, rgen._sparsity, rgen._pdf)) {
            bigrand = LibMatrixDatagen.setupSeedsForRand(seed);
        }
        if (k > 1) {
            out.randOperationsInPlace(rgen, bigrand, -1L, k);
        } else {
            out.randOperationsInPlace(rgen, bigrand, -1L);
        }
        return out;
    }

    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed) {
        LibMatrixDatagen.generateRandomMatrix(this, rgen, bigrand, bSeed);
        return this;
    }

    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed, int k) {
        LibMatrixDatagen.generateRandomMatrix(this, rgen, bigrand, bSeed, k);
        return this;
    }

    public static MatrixBlock seqOperations(double from, double to, double incr) {
        MatrixBlock out = new MatrixBlock();
        LibMatrixDatagen.generateSequence(out, from, to, incr);
        return out;
    }

    public MatrixBlock seqOperationsInPlace(double from, double to, double incr) {
        LibMatrixDatagen.generateSequence(this, from, to, incr);
        return this;
    }

    public static MatrixBlock sampleOperations(long range, int size, boolean replace, long seed) {
        MatrixBlock out = new MatrixBlock();
        LibMatrixDatagen.generateSample(out, range, size, replace, seed);
        return out;
    }

    private static MatrixBlock checkType(MatrixValue block) {
        if (block != null && !(block instanceof MatrixBlock)) {
            throw new RuntimeException("Unsupported matrix value: " + block.getClass().getSimpleName());
        }
        return (MatrixBlock)block;
    }

    public boolean isThreadSafe() {
        return !this.sparse || (this.sparseBlock != null ? this.sparseBlock.isThreadSafe() : DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR);
    }

    public static boolean isThreadSafe(boolean sparse) {
        return !sparse || DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR;
    }

    public void checkNaN() {
        if (this.isEmptyBlock(false)) {
            return;
        }
        if (this.sparse) {
            SparseBlock sblock = this.sparseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                if (sblock.isEmpty(i)) continue;
                int alen = sblock.size(i);
                int apos = sblock.pos(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!Double.isNaN(avals[k])) continue;
                    throw new DMLRuntimeException("NaN encountered at position [" + i + "," + aix[k] + "].");
                }
            }
        } else {
            DenseBlock dblock = this.denseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                int aix = dblock.pos(i);
                double[] avals = dblock.values(i);
                for (int j = 0; j < this.clen; ++j) {
                    if (!Double.isNaN(avals[aix + j])) continue;
                    throw new DMLRuntimeException("NaN encountered at position [" + i + "," + j + "].");
                }
            }
        }
    }

    public final int compareTo(Object arg0) {
        throw new RuntimeException("CompareTo should never be called for matrix blocks.");
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof MatrixBlock) {
            return LibMatrixEquals.equals(this, (MatrixBlock)arg0);
        }
        return false;
    }

    public final boolean equals(MatrixBlock arg0) {
        return LibMatrixEquals.equals(this, arg0);
    }

    public final int hashCode() {
        throw new RuntimeException("HashCode should never be called for matrix blocks.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sparse? = ");
        sb.append(this.sparse);
        sb.append("\n");
        sb.append("nonzeros = ");
        sb.append(this.nonZeros);
        sb.append("\n");
        sb.append("size: ");
        sb.append(this.rlen);
        sb.append(" X ");
        sb.append(this.clen);
        sb.append("\n");
        if (this.sparse && this.sparseBlock != null) {
            sb.append(this.sparseBlock.toString());
        } else if (!this.sparse && this.denseBlock != null) {
            sb.append(this.denseBlock.toString());
        }
        return sb.toString();
    }

    @Override
    public double getDouble(int r, int c) {
        return this.quickGetValue(r, c);
    }

    @Override
    public double getDoubleNaN(int r, int c) {
        return this.getDouble(r, c);
    }

    @Override
    public String getString(int r, int c) {
        double v = this.quickGetValue(r, c);
        if (Double.isNaN(v)) {
            return null;
        }
        return String.valueOf(v);
    }

    public static class SparsityEstimate {
        public long estimatedNonZeros = 0L;
        public boolean sparse = false;

        public SparsityEstimate(boolean sps, long nnzs) {
            this.sparse = sps;
            this.estimatedNonZeros = nnzs;
        }

        public SparsityEstimate() {
        }
    }
}

