/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.squareup.okhttp.internal.http;

import java.net.Proxy;
import org.apache.hadoop.shaded.com.squareup.okhttp.HttpUrl;
import org.apache.hadoop.shaded.com.squareup.okhttp.Request;

public final class RequestLine {
    private RequestLine() {
    }

    static String get(Request request, Proxy.Type proxyType) {
        StringBuilder result = new StringBuilder();
        result.append(request.method());
        result.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result.append(request.httpUrl());
        } else {
            result.append(RequestLine.requestPath(request.httpUrl()));
        }
        result.append(" HTTP/1.1");
        return result.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(HttpUrl url) {
        String path = url.encodedPath();
        String query = url.encodedQuery();
        return query != null ? path + '?' + query : path;
    }
}

