/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.ArrayList;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;

public class EncoderPassThrough
extends Encoder {
    private static final long serialVersionUID = -8473768154646831882L;

    protected EncoderPassThrough(int[] ptCols, int clen) {
        super(ptCols, clen);
    }

    public EncoderPassThrough() {
        this(new int[0], 0);
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int col = this._colList[j] - 1;
            Types.ValueType vt = in.getSchema()[col];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object val = in.get(i, col);
                out.quickSetValue(i, col, val == null || vt == Types.ValueType.STRING && val.toString().isEmpty() ? Double.NaN : UtilFunctions.objectToDouble(vt, val));
            }
        }
        return out;
    }

    @Override
    public Encoder subRangeEncoder(IndexRange ixRange) {
        ArrayList<Integer> colList = new ArrayList<Integer>();
        for (int col : this._colList) {
            if ((long)col < ixRange.colStart || (long)col >= ixRange.colEnd) continue;
            colList.add((int)((long)col - (ixRange.colStart - 1L)));
        }
        if (colList.isEmpty()) {
            return null;
        }
        return new EncoderPassThrough(colList.stream().mapToInt(i -> i).toArray(), (int)(ixRange.colEnd - ixRange.colStart));
    }

    @Override
    public void mergeAt(Encoder other, int row, int col) {
        if (other instanceof EncoderPassThrough) {
            this.mergeColumnInfo(other, col);
            return;
        }
        super.mergeAt(other, row, col);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }
}

