/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DecoderPassThrough
extends Decoder {
    private static final long serialVersionUID = -8525203889417422598L;
    private int[] _dcCols = null;
    private int[] _srcCols = null;

    protected DecoderPassThrough(Types.ValueType[] schema, int[] ptCols, int[] dcCols) {
        super(schema, ptCols);
        this._dcCols = dcCols;
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        out.ensureAllocatedColumns(in.getNumRows());
        int clen = Math.min(this._colList.length, out.getNumColumns());
        for (int i = 0; i < in.getNumRows(); ++i) {
            for (int j = 0; j < clen; ++j) {
                int srcColID = this._srcCols[j];
                int tgtColID = this._colList[j];
                double val = in.quickGetValue(i, srcColID - 1);
                out.set(i, tgtColID - 1, UtilFunctions.doubleToObject(this._schema[tgtColID - 1], val));
            }
        }
        return out;
    }

    @Override
    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        ArrayList<Integer> colList = new ArrayList<Integer>();
        ArrayList dcList = new ArrayList();
        ArrayList<Integer> srcList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this._colList.length; ++i2) {
            int colID = this._colList[i2];
            if (colID < colStart || colID >= colEnd) continue;
            colList.add(colID - (colStart - 1));
            srcList.add(this._srcCols[i2] - dummycodedOffset);
        }
        Arrays.stream(this._dcCols).filter(c -> c >= colStart && c < colEnd).forEach(c -> dcList.add(c));
        if (colList.isEmpty()) {
            return null;
        }
        DecoderPassThrough decoder = new DecoderPassThrough(Arrays.copyOfRange(this._schema, colStart - 1, colEnd - 1), colList.stream().mapToInt(i -> i).toArray(), dcList.stream().mapToInt(i -> i).toArray());
        decoder._srcCols = srcList.stream().mapToInt(i -> i).toArray();
        return decoder;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (this._dcCols.length > 0) {
            this._srcCols = new int[this._colList.length];
            int ix1 = 0;
            int ix2 = 0;
            int off = 0;
            while (ix1 < this._colList.length) {
                if (ix2 >= this._dcCols.length || this._colList[ix1] < this._dcCols[ix2]) {
                    this._srcCols[ix1] = this._colList[ix1] + off;
                    ++ix1;
                    continue;
                }
                off += (int)meta.getColumnMetadata()[this._dcCols[ix2] - 1].getNumDistinct() - 1;
                ++ix2;
            }
        } else {
            this._srcCols = this._colList;
        }
    }
}

