/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;

public class RewriteBlockSizeAndReblock
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        if (RewriteBlockSizeAndReblock.isReblockValid()) {
            state.setBlocksize(ConfigurationManager.getBlocksize());
        }
        for (Hop h : roots) {
            this.rule_BlockSizeAndReblock(h, ConfigurationManager.getBlocksize());
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return null;
        }
        if (RewriteBlockSizeAndReblock.isReblockValid()) {
            state.setBlocksize(ConfigurationManager.getBlocksize());
        }
        this.rule_BlockSizeAndReblock(root, ConfigurationManager.getBlocksize());
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rule_BlockSizeAndReblock(Hop hop, int blocksize) {
        block17: {
            boolean canReblock;
            block16: {
                DataOp dop;
                block19: {
                    block18: {
                        for (Hop hi : hop.getInput()) {
                            if (hi.isVisited()) continue;
                            this.rule_BlockSizeAndReblock(hi, blocksize);
                        }
                        canReblock = RewriteBlockSizeAndReblock.isReblockValid();
                        if (!(hop instanceof DataOp)) break block16;
                        dop = (DataOp)hop;
                        if (!canReblock || (dop.getDataType() != Types.DataType.MATRIX || dop.getBlocksize() == blocksize) && (dop.getDataType() != Types.DataType.FRAME || !OptimizerUtils.isSparkExecutionMode() || dop.getInputFormatType() != Types.FileFormat.TEXT && dop.getInputFormatType() != Types.FileFormat.CSV)) break block17;
                        if (dop.getOp() != Types.OpOpData.PERSISTENTREAD) break block18;
                        dop.setRequiresReblock(true);
                        dop.setBlocksize(blocksize);
                        break block17;
                    }
                    if (dop.getOp() != Types.OpOpData.PERSISTENTWRITE) break block19;
                    if (dop.getBlocksize() == -1) break block17;
                    if (dop.getInput().get(0).requiresReblock() && dop.getInput().get(0).getParent().size() == 1) {
                        dop.getInput().get(0).setBlocksize(dop.getBlocksize());
                    } else {
                        dop.setRequiresReblock(true);
                        dop.setBlocksize(blocksize);
                    }
                    break block17;
                }
                if (dop.getOp().isTransient()) {
                    if (DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE) {
                        dop.setBlocksize(hop.getInput().get(0).getBlocksize());
                    } else {
                        dop.setBlocksize(blocksize);
                    }
                } else {
                    if (dop.getOp() != Types.OpOpData.FEDERATED) throw new HopsException(hop.printErrorLocation() + "unexpected non-scalar Data HOP in reblock.\n");
                    dop.setBlocksize(blocksize);
                }
                break block17;
            }
            if (hop.requiresReblock()) {
                hop.setBlocksize(blocksize);
            } else if (hop.getDataType() == Types.DataType.SCALAR) {
                hop.setBlocksize(-1);
            } else {
                if (!canReblock) {
                    hop.setBlocksize(-1);
                } else {
                    FunctionOp fop;
                    hop.setBlocksize(blocksize);
                    if (hop instanceof FunctionOp && (fop = (FunctionOp)hop).getOutputs() != null) {
                        for (Hop out : fop.getOutputs()) {
                            out.setBlocksize(blocksize);
                        }
                    }
                }
                for (Hop h : hop.getInput()) {
                    if (h.getDataType() != Types.DataType.MATRIX || h.getBlocksize() != -1) continue;
                    hop.setBlocksize(-1);
                    break;
                }
            }
        }
        hop.setVisited();
    }

    private static boolean isReblockValid() {
        return DMLScript.getGlobalExecMode() != Types.ExecMode.SINGLE_NODE;
    }
}

