/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;

public class DataPartition
extends Lop {
    public static final String OPCODE = "partition";
    private ParForProgramBlock.PDataPartitionFormat _pformat = null;

    public DataPartition(Lop input, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, ParForProgramBlock.PDataPartitionFormat pformat) {
        super(Lop.Type.DataPartition, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._pformat = pformat;
        LopProperties.ExecLocation eloc = et == LopProperties.ExecType.MR ? LopProperties.ExecLocation.MapAndReduce : LopProperties.ExecLocation.ControlProgram;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = et == LopProperties.ExecType.MR;
        this.lps.addCompatibility(JobType.DATA_PARTITION);
        this.lps.setProperties(this.inputs, et, eloc, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "DataPartition";
    }

    @Override
    public String getInstructions(String input_index, String output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(input_index);
        sb.append("\u00b7");
        sb.append((Object)this.getInputs().get(0).getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getInputs().get(0).getValueType());
        sb.append("\u00b0");
        sb.append(output_index);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        sb.append("\u00b0");
        sb.append(this._pformat.toString());
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }
}

