/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@PublicEvolving
@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001E\u0011Q\u0003R1uCN#(/Z1n\u0007>tg/\u001a:tS>t7O\u0003\u0002\u0004\t\u0005)1oY1mC*\u0011QAB\u0001\u0007EJLGmZ3\u000b\u0005\u001dA\u0011aA1qS*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u0001QC\u0001\n%'\t\u00011\u0003\u0005\u0002\u0015-5\tQCC\u0001\u0004\u0013\t9RC\u0001\u0004B]f\u0014VM\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005QA-\u0019;b'R\u0014X-Y7\u0011\u0007m\u0001#%D\u0001\u001d\u0015\t\u0019QD\u0003\u0002\b=)\u0011qDC\u0001\ngR\u0014X-Y7j]\u001eL!!\t\u000f\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0002$I1\u0001A!B\u0013\u0001\u0005\u00041#!\u0001+\u0012\u0005\u001dR\u0003C\u0001\u000b)\u0013\tISCA\u0004O_RD\u0017N\\4\u0011\u0005QY\u0013B\u0001\u0017\u0016\u0005\r\te.\u001f\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004cA\u0019\u0001E5\t!\u0001C\u0003\u001a[\u0001\u0007!\u0004C\u00035\u0001\u0011\u0005Q'A\u0004u_R\u000b'\r\\3\u0015\u0005YR\u0004CA\u001c9\u001b\u00051\u0011BA\u001d\u0007\u0005\u0015!\u0016M\u00197f\u0011\u0015Y4\u00071\u0001=\u0003!!\u0018M\u00197f\u000b:4\bCA\u0019>\u0013\tq$A\u0001\fTiJ,\u0017-\u001c+bE2,WI\u001c<je>tW.\u001a8u\u0011\u0015!\u0004\u0001\"\u0001A)\r1\u0014I\u0011\u0005\u0006w}\u0002\r\u0001\u0010\u0005\u0006\u0007~\u0002\r\u0001R\u0001\u0007g\u000eDW-\\1\u0011\u0005]*\u0015B\u0001$\u0007\u0005\u0019\u00196\r[3nC\")\u0001\n\u0001C\u0001\u0013\u0006\u00192M]3bi\u0016$V-\u001c9pe\u0006\u0014\u0018PV5foR\u0019!*\u0014(\u0011\u0005QY\u0015B\u0001'\u0016\u0005\u0011)f.\u001b;\t\u000bm:\u0005\u0019\u0001\u001f\t\u000b=;\u0005\u0019\u0001)\u0002\tA\fG\u000f\u001b\t\u0003#bs!A\u0015,\u0011\u0005M+R\"\u0001+\u000b\u0005U\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002X+\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9V\u0003C\u0003I\u0001\u0011\u0005A\f\u0006\u0003K;z{\u0006\"B\u001e\\\u0001\u0004a\u0004\"B(\\\u0001\u0004\u0001\u0006\"B\"\\\u0001\u0004!\u0005\"B1\u0001\t\u0003\u0011\u0017\u0001\u0005;p\u0007\"\fgnZ3m_\u001e$\u0016M\u00197f)\t14\rC\u0003<A\u0002\u0007A\bC\u0003b\u0001\u0011\u0005Q\rF\u00027M\u001eDQa\u000f3A\u0002qBQa\u00113A\u0002\u0011CQ!\u0019\u0001\u0005\u0002%$BA\u000e6lY\")1\b\u001ba\u0001y!)1\t\u001ba\u0001\t\")Q\u000e\u001ba\u0001]\u0006i1\r[1oO\u0016dwnZ'pI\u0016\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0005\u0002\u0013\r|gN\\3di>\u0014\u0018BA:q\u00055\u0019\u0005.\u00198hK2|w-T8eK\")A\u0007\u0001C\u0001kR\u0019aG^<\t\u000bm\"\b\u0019\u0001\u001f\t\u000ba$\b\u0019A=\u0002\r\u0019LW\r\u001c3t!\r!\"\u0010`\u0005\u0003wV\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010C\u0001\fKb\u0004(/Z:tS>t7/C\u0002\u0002\u0004y\u0014!\"\u0012=qe\u0016\u001c8/[8oQ\r\u0001\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0005-!A\u0004)vE2L7-\u0012<pYZLgn\u001a\u0015\b\u0001\u0005U\u00111DA'!\r!\u0012qC\u0005\u0004\u00033)\"A\u00033faJ,7-\u0019;fIFB1\u0005UA\u000f\u0003S\ty\"\u0003\u0003\u0002 \u0005\u0005\u0012\u0001\u0005$M\u0013B{&GN\u001b`/\u0006\u0013f*\u0013(H\u0015\u0011\t\u0019#!\n\u0002\u000fA\f7m[1hK*\u00191!a\n\u000b\u0005\u001dQ\u0011'C\u0012\u0002,\u0005\u0005\u00131IA\u0012\u001d\u0011\ti#!\u0011\u000f\t\u0005=\u0012q\b\b\u0005\u0003c\tiD\u0004\u0003\u00024\u0005mb\u0002BA\u001b\u0003sq1aUA\u001c\u0013\u0005y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002\b\u0015%\u00191!a\n\n\t\u0005\r\u0012QE\u0019\tG\u00055\u0012qHA#\u0007EB1%a\f\u0002>\u0005\u001ds!\r\u0005$\u0003c\tY$!\u0013\fc!\u0019\u00131GA\u001d\u0003\u0017j\u0011G\u0002\u0013\u00026\u0005]r\"\t\u0002\u0002P\u00051\u0011GL\u00199]A\u0002")
public class DataStreamConversions<T> {
    private final DataStream<T> dataStream;

    public Table toTable(StreamTableEnvironment tableEnv) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        return tableEnv.fromDataStream(this.dataStream);
    }

    public Table toTable(StreamTableEnvironment tableEnv, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        return tableEnv.fromDataStream(this.dataStream, schema);
    }

    public void createTemporaryView(StreamTableEnvironment tableEnv, String path) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        tableEnv.createTemporaryView(path, this.dataStream);
    }

    public void createTemporaryView(StreamTableEnvironment tableEnv, String path, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        tableEnv.createTemporaryView(path, this.dataStream, schema);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.dataType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
        }
        return tableEnv.fromChangelogStream(this.dataStream);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.dataType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
        }
        return tableEnv.fromChangelogStream(this.dataStream, schema);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.dataType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
        }
        return tableEnv.fromChangelogStream(this.dataStream, schema, changelogMode);
    }

    public Table toTable(StreamTableEnvironment tableEnv, Seq<Expression> fields) {
        return fields.isEmpty() ? this.toTable(tableEnv) : tableEnv.fromDataStream(this.dataStream, fields);
    }

    public DataStreamConversions(DataStream<T> dataStream) {
        this.dataStream = dataStream;
    }
}

