/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cpconverter.maven.mojos;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstallerException;
import org.apache.sling.cpconverter.maven.mojos.AbstractBaseMojo;
import org.apache.sling.cpconverter.maven.mojos.ContentPackage;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.acl.AclManager;
import org.apache.sling.feature.cpconverter.acl.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.DefaultArtifactsDeployer;
import org.apache.sling.feature.cpconverter.features.DefaultFeaturesManager;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.handlers.DefaultEntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.vltpkg.DefaultPackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="convert-cp", requiresProject=true, threadSafe=true)
public class ConvertCPMojo
extends AbstractBaseMojo {
    public static final String CFG_STRICT_VALIDATION = "strictValidation";
    public static final String CFG_MERGE_CONFIGURATIONS = "mergeConfigurations";
    public static final String CFG_BUNDLE_START_ORDER = "bundleStartOrder";
    public static final String CFG_ARTIFACT_ID_OVERRIDE = "artifactIdOverride";
    public static final String CFG_INSTALL_CONVERTED_PACKAGE = "installConvertedContentPackage";
    public static final String CFG_FM_OUTPUT_DIRECTORY = "featureModelsOutputDirectory";
    public static final String CFG_CONVERTED_CP_OUTPUT_DIRECTORY = "convertedContentPackageOutputDirectory";
    public static final String CFG_CONVERTED_CP_FM_PREFIX = "fmPrefix";
    public static final String CFG_SYSTEM_PROPERTIES = "cpSystemProperties";
    public static final String CFG_CONTENT_PACKAGES = "packages";
    public static final String CFG_IS_CONTENT_PACKAGE = "isContentPackage";
    public static final String CFG_API_REGIONS = "apiRegions";
    public static final String CFP_EXPORT_TO_API_REGION = "exportToApiRegion";
    public static final boolean DEFAULT_STRING_VALIDATION = false;
    public static final boolean DEFAULT_MERGE_CONFIGURATIONS = false;
    public static final int DEFAULT_BUNDLE_START_ORDER = 20;
    public static final boolean DEFAULT_INSTALL_CONVERTED_PACKAGE = true;
    public static final String DEFAULT_CONVERTED_CP_OUTPUT_DIRECTORY = "${project.build.directory}/cp-conversion";
    public static final String DEFAULT_FM_OUTPUT_DIRECTORY = "${project.build.directory}/cp-conversion/fm.out";
    public static final boolean DEFAULT_IS_CONTENT_PACKAGE = false;
    @Parameter(property="strictValidation", defaultValue="false")
    private boolean strictValidation;
    @Parameter(property="mergeConfigurations", defaultValue="false")
    private boolean mergeConfigurations;
    @Parameter(property="bundleStartOrder", defaultValue="20")
    private int bundleStartOrder;
    @Parameter(property="artifactIdOverride")
    private String artifactIdOverride;
    @Parameter(property="featureModelsOutputDirectory", defaultValue="${project.build.directory}/cp-conversion/fm.out")
    private File fmOutput;
    @Parameter(property="convertedContentPackageOutputDirectory", defaultValue="${project.build.directory}/cp-conversion")
    private File convertedCPOutput;
    @Parameter(property="installConvertedContentPackage", defaultValue="true")
    private boolean installConvertedCP;
    @Parameter(property="fmPrefix")
    private String fmPrefix;
    @Parameter(property="cpSystemProperties")
    private List<String> systemProperties;
    @Parameter(property="packages")
    private List<ContentPackage> contentPackages;
    @Parameter(property="isContentPackage", defaultValue="false")
    private boolean isContentPackage;
    @Parameter(property="apiRegions")
    private List<String> apiRegions;
    @Parameter(property="exportToApiRegion")
    private String exportToApiRegion;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.artifactIdOverride != null) {
            String old = this.artifactIdOverride;
            this.artifactIdOverride = this.artifactIdOverride.replaceAll("\\$\\{\\{", "\\$\\{");
            this.artifactIdOverride = this.artifactIdOverride.replaceAll("}}", "}");
            this.getLog().info((CharSequence)("Replaced Old Artifact Id Override: '" + old + "', with new one: '" + this.artifactIdOverride + "'"));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.systemProperties != null) {
            for (String systemProperty : this.systemProperties) {
                int index;
                if (systemProperty == null || (index = systemProperty.indexOf("=")) <= 0 || index >= systemProperty.length() - 1) continue;
                String key = systemProperty.substring(0, index);
                String value = systemProperty.substring(index + 1);
                properties.put(key, value);
            }
        }
        try {
            DefaultFeaturesManager featuresManager = new DefaultFeaturesManager(this.mergeConfigurations, this.bundleStartOrder, this.fmOutput, this.artifactIdOverride, this.fmPrefix, properties);
            if (!this.apiRegions.isEmpty()) {
                featuresManager.setAPIRegions(this.apiRegions);
            }
            if (this.exportToApiRegion != null) {
                featuresManager.setExportToAPIRegion(this.exportToApiRegion);
            }
            ContentPackage2FeatureModelConverter converter = new ContentPackage2FeatureModelConverter(this.strictValidation).setFeaturesManager((FeaturesManager)featuresManager).setBundlesDeployer((ArtifactsDeployer)new DefaultArtifactsDeployer(this.convertedCPOutput)).setEntryHandlersManager((EntryHandlersManager)new DefaultEntryHandlersManager()).setAclManager((AclManager)new DefaultAclManager()).setEmitter((PackagesEventsEmitter)DefaultPackagesEventsEmitter.open((File)this.fmOutput));
            if (this.contentPackages == null || this.contentPackages.isEmpty()) {
                this.getLog().info((CharSequence)("Project Artifact File: " + this.project.getArtifact()));
                String targetPath = this.project.getModel().getBuild().getDirectory() + "/" + this.project.getModel().getBuild().getFinalName() + "." + "zip";
                File targetFile = new File(targetPath);
                if (targetFile.exists() && targetFile.isFile() && targetFile.canRead()) {
                    converter.convert(new File[]{this.project.getArtifact().getFile()});
                } else {
                    this.getLog().error((CharSequence)("Artifact is not found: " + targetPath));
                }
            } else {
                for (ContentPackage contentPackage : this.contentPackages) {
                    contentPackage.setExcludeTransitive(true);
                    contentPackage.setModuleIsContentPackage(this.isContentPackage);
                    this.getLog().info((CharSequence)("Content Package Artifact File: " + contentPackage.toString() + ", is module CP: " + this.isContentPackage));
                    Collection<Artifact> artifacts = contentPackage.getMatchingArtifacts(this.project, this.repoSystem, this.repoSession, this.remoteRepos);
                    if (artifacts.isEmpty()) {
                        this.getLog().warn((CharSequence)("No matching artifacts for " + contentPackage));
                        continue;
                    }
                    this.getLog().info((CharSequence)("Target Convert CP of --- " + contentPackage + " ---"));
                    for (Artifact artifact : artifacts) {
                        File source = artifact.getFile();
                        this.getLog().info((CharSequence)("Artifact: '" + artifact + "', source file: '" + source + "'"));
                        if (source != null && source.exists() && source.isFile() && source.canRead()) {
                            converter.convert(new File[]{source});
                            DefaultArtifact defaultArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "compile", "zip", "cp2fm-converted", this.artifactHandlerManager.getArtifactHandler("zip"));
                            continue;
                        }
                        this.getLog().error((CharSequence)("Artifact is not found: " + artifact));
                    }
                }
            }
            this.installGeneratedArtifacts();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Content Package Converter Exception", t);
        }
    }

    private void installGeneratedArtifacts() {
        File destFolder;
        File userHome;
        if (this.installConvertedCP && (userHome = new File(System.getProperty("user.home"))).isDirectory() && (destFolder = new File(userHome, ".m2/repository")).isDirectory()) {
            this.copyFiles(this.convertedCPOutput, destFolder);
            if (this.isContentPackage) {
                this.installFMDescriptor(this.project.getArtifact());
            }
        }
    }

    private void copyFiles(File source, File destination) {
        for (File file : source.listFiles()) {
            File newDest;
            String name = file.getName();
            if (file.isDirectory()) {
                newDest = new File(destination, name);
                if (!newDest.exists()) {
                    newDest.mkdirs();
                }
                if (newDest.isDirectory()) {
                    this.copyFiles(file, newDest);
                    continue;
                }
                this.getLog().warn((CharSequence)("Source File: '" + file.getAbsolutePath() + "' is a folder but its counterpart is a file: " + newDest.getAbsolutePath()));
                continue;
            }
            newDest = new File(destination, name);
            if (!newDest.exists()) {
                try {
                    Files.copy(file.toPath(), newDest.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Failed to copy File: '" + file.getAbsolutePath() + "' to File: " + newDest.getAbsolutePath()), (Throwable)e);
                }
                continue;
            }
            if (name.endsWith("cp2fm-converted.zip")) {
                try {
                    Files.copy(file.toPath(), newDest.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Failed to copy generated File: '" + file.getAbsolutePath() + "' to File: " + newDest.getAbsolutePath()), (Throwable)e);
                }
                continue;
            }
            this.getLog().info((CharSequence)("Ignore File: '" + file.getAbsolutePath()));
        }
    }

    private void installFMDescriptor(Artifact artifact) {
        if (this.installConvertedCP) {
            Collection<Artifact> artifacts = Collections.synchronizedCollection(new ArrayList());
            String fmDescriptorFilePath = this.fmPrefix + artifact.getArtifactId() + ".json";
            File fmDescriptorFile = new File(this.fmOutput, fmDescriptorFilePath);
            if (fmDescriptorFile.exists() && fmDescriptorFile.canRead()) {
                DefaultArtifactHandler fmArtifactHandler = new DefaultArtifactHandler("slingosgifeature");
                DefaultArtifact fmArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), "slingosgifeature", artifact.getArtifactId(), (ArtifactHandler)fmArtifactHandler);
                fmArtifact.setFile(fmDescriptorFile);
                artifacts.add((Artifact)fmArtifact);
                try {
                    this.installArtifact(this.mavenSession.getProjectBuildingRequest(), artifacts);
                }
                catch (MojoExecutionException | MojoFailureException e) {
                    this.getLog().error((CharSequence)"Failed to install FM Descriptor", e);
                }
            } else {
                this.getLog().error((CharSequence)("Could not find FM Descriptor File: " + fmDescriptorFile));
            }
        }
    }

    private void installArtifact(ProjectBuildingRequest pbr, Collection<Artifact> artifacts) throws MojoFailureException, MojoExecutionException {
        try {
            this.installer.install(pbr, artifacts);
        }
        catch (ArtifactInstallerException e) {
            throw new MojoExecutionException("ArtifactInstallerException", (Exception)((Object)e));
        }
    }
}

