/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.sling.scriptingbundle.plugin.capability.Capabilities;
import org.apache.sling.scriptingbundle.plugin.maven.MavenLogger;
import org.apache.sling.scriptingbundle.plugin.processor.Constants;
import org.jetbrains.annotations.NotNull;

@Mojo(name="metadata", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class MetadataMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="scriptingbundle.sourceDirectories")
    private Set<String> sourceDirectories;
    @Parameter(property="scriptingbundle.includes", defaultValue="**")
    private String[] includes;
    @Parameter(property="scriptingbundle.excludes")
    private String[] excludes;
    @Parameter
    private Map<String, String> scriptEngineMappings;
    @Parameter(property="scriptingbundle.searchPaths")
    private Set<String> searchPaths;
    @Parameter(property="scriptingbundle.missingRequirementsOptional", defaultValue="true")
    private boolean missingRequirementsOptional = true;
    private Capabilities capabilities;

    public void execute() {
        boolean inContentPackage = "content-package".equals(this.project.getPackaging());
        MavenLogger logger = new MavenLogger(this.getLog());
        Path workDirectory = Paths.get(this.project.getBuild().getDirectory(), "scriptingbundle-maven-plugin");
        try {
            Files.createDirectories(workDirectory, new FileAttribute[0]);
            if (this.sourceDirectories.isEmpty()) {
                this.sourceDirectories = new HashSet<String>(Constants.DEFAULT_SOURCE_DIRECTORIES);
            }
            this.sourceDirectories.stream().map(sourceDirectory -> {
                Path sourceDirectoryPath = Paths.get(sourceDirectory, new String[0]);
                if (!Files.exists(sourceDirectoryPath, new LinkOption[0])) {
                    sourceDirectoryPath = Paths.get(this.project.getBasedir().getAbsolutePath(), sourceDirectory);
                }
                return sourceDirectoryPath;
            }).filter(sourceDirectory -> Files.exists(sourceDirectory, new LinkOption[0]) && Files.isDirectory(sourceDirectory, new LinkOption[0])).forEach(sourceDirectoryPath -> {
                DirectoryScanner scanner = this.getDirectoryScanner(sourceDirectoryPath.toFile());
                Arrays.stream(scanner.getIncludedFiles()).map(sourceDirectoryPath::resolve).forEach(file -> {
                    try {
                        if (!Files.isDirectory(file, new LinkOption[0])) {
                            Path workingCopy = workDirectory.resolve(sourceDirectoryPath.relativize((Path)file));
                            Files.createDirectories(workingCopy.getParent(), new FileAttribute[0]);
                            Files.copy(file, workingCopy, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Cannot copy file into working directory.", e);
                    }
                });
            });
            HashMap<String, String> mappings = new HashMap<String, String>(Constants.DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING);
            if (this.scriptEngineMappings != null) {
                mappings.putAll(this.scriptEngineMappings);
            }
            this.scriptEngineMappings = mappings;
            if (this.searchPaths == null || this.searchPaths.isEmpty()) {
                this.searchPaths = Constants.DEFAULT_SEARCH_PATHS;
            }
            DirectoryScanner scanner = this.getDirectoryScanner(workDirectory.toFile());
            ArrayList<String> scannerPaths = new ArrayList<String>(Arrays.asList(scanner.getIncludedFiles()));
            for (String file : scanner.getIncludedFiles()) {
                scannerPaths.add(FilenameUtils.getFullPath((String)file));
            }
            this.capabilities = Capabilities.fromFileSystemTree(workDirectory, scannerPaths.stream().map(workDirectory::resolve), logger, this.searchPaths, this.scriptEngineMappings, this.missingRequirementsOptional, inContentPackage);
            String providedCapabilitiesDefinition = this.capabilities.getProvidedCapabilitiesString();
            String requiredCapabilitiesDefinition = this.capabilities.getRequiredCapabilitiesString();
            this.project.getProperties().put("org.apache.sling.scriptingbundle.maven.plugin.Provide-Capability", providedCapabilitiesDefinition);
            this.project.getProperties().put("org.apache.sling.scriptingbundle.maven.plugin.Require-Capability", requiredCapabilitiesDefinition);
        }
        catch (IOException e) {
            logger.error("Unable to generate working directory.", e);
        }
    }

    @NotNull
    private DirectoryScanner getDirectoryScanner(@NotNull File directory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (this.includes == null || this.includes.length == 0) {
            scanner.setIncludes(new String[]{"**"});
        } else {
            scanner.setIncludes(this.includes);
        }
        if (this.excludes == null || this.excludes.length == 0) {
            scanner.setExcludes(Constants.DEFAULT_EXCLUDES.toArray(new String[0]));
        } else {
            scanner.setExcludes(this.excludes);
        }
        scanner.scan();
        return scanner;
    }

    Capabilities getCapabilities() {
        return this.capabilities;
    }

    Map<String, String> getScriptEngineMappings() {
        return this.scriptEngineMappings;
    }
}

