/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidatorInvocation;

public class ResourcePropertyImpl
implements ResourceProperty {
    @Nonnull
    private final String name;
    private final boolean isMultiple;
    private final boolean isRequired;
    @Nonnull
    private final List<ValidatorInvocation> validators;
    private final Pattern namePattern;

    protected ResourcePropertyImpl(@Nonnull String name, String nameRegex, boolean isMultiple, boolean isRequired, @Nonnull List<ValidatorInvocation> validators) throws IllegalArgumentException {
        if (nameRegex != null) {
            try {
                this.namePattern = Pattern.compile(nameRegex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid regex given", e);
            }
        } else {
            this.namePattern = null;
        }
        this.name = name;
        this.isMultiple = isMultiple;
        this.isRequired = isRequired;
        this.validators = validators;
    }

    public String getName() {
        return this.name;
    }

    public Pattern getNamePattern() {
        return this.namePattern;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    @Nonnull
    public List<ValidatorInvocation> getValidatorInvocations() {
        return this.validators;
    }

    public String toString() {
        return "ResourcePropertyImpl [name=" + this.name + ", isMultiple=" + this.isMultiple + ", isRequired=" + this.isRequired + ", validators=" + this.validators + ", namePattern=" + this.namePattern + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isMultiple ? 1231 : 1237);
        result = 31 * result + (this.isRequired ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namePattern == null ? 0 : this.namePattern.hashCode());
        result = 31 * result + (this.validators == null ? 0 : this.validators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePropertyImpl other = (ResourcePropertyImpl)obj;
        if (this.isMultiple != other.isMultiple) {
            return false;
        }
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.namePattern == null ? other.namePattern != null : !this.namePattern.pattern().equals(other.namePattern.pattern())) {
            return false;
        }
        return this.validators.equals(other.validators);
    }
}

