/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.thumbnails.ThumbnailSupport;
import org.apache.sling.thumbnails.Transformer;
import org.apache.sling.thumbnails.extension.ThumbnailProvider;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.apache.sling.thumbnails.internal.TransformationCache;
import org.apache.sling.thumbnails.internal.TransformerImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Web Console Plugin for Apache Sling Thumbnails", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=thumbnails", "felix.webconsole.title=Sling Thumbnails", "felix.webconsole.configprinter.modes=always", "felix.webconsole.category=Status"}, service={Servlet.class})
public class ThumbnailsWebConsole
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 4819043498961127418L;
    public static final String CONSOLE_LABEL = "thumbnails";
    public static final String CONSOLE_TITLE = "Sling Thumbnails";
    private final Transformer transformer;
    private final ThumbnailSupport thumbnailSupport;
    private final TransformationCache transformationCache;

    @Activate
    public ThumbnailsWebConsole(@Reference ThumbnailSupport thumbnailSupport, @Reference Transformer transformer, @Reference TransformationCache transformationCache) {
        this.thumbnailSupport = thumbnailSupport;
        this.transformer = transformer;
        this.transformationCache = transformationCache;
    }

    public String getTitle() {
        return CONSOLE_TITLE;
    }

    public String getLabel() {
        return CONSOLE_LABEL;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter pw = httpServletResponse.getWriter();
        this.printSeparator(pw, "Supported Resource Types", true);
        pw.println("[Resource Type] => [MetaType Property Path]");
        this.thumbnailSupport.getSupportedTypes().forEach(st -> pw.println(st + " => " + this.thumbnailSupport.getMetaTypePropertyPath((String)st)));
        this.printSeparator(pw, "Persistable Resource Types", false);
        pw.println("[Resource Type] => [Rendition Path]");
        this.thumbnailSupport.getPersistableTypes().forEach(pt -> pw.println(pt + " => " + this.thumbnailSupport.getRenditionPath((String)pt)));
        this.printSeparator(pw, "Registered Thumbnail Providers", false);
        List<ThumbnailProvider> providers = ((TransformerImpl)this.transformer).getThumbnailProviders();
        Collections.reverse(providers);
        providers.forEach(p -> pw.println(p.getClass().getName()));
        this.printSeparator(pw, "Registered Transformation Providers", false);
        List<TransformationHandler> handlers = ((TransformerImpl)this.transformer).getHandlers();
        handlers.forEach(h -> pw.println(h.getResourceType() + "=" + h.getClass().getCanonicalName()));
        this.printSeparator(pw, "Cached Transformations", false);
        Set<Map.Entry<String, Optional<String>>> cache = this.transformationCache.getCacheEntries();
        cache.forEach(e -> pw.println((String)e.getKey() + " => " + (String)((Optional)e.getValue()).get()));
        pw.println("</pre>");
        pw.println("</div>");
    }

    private void printSeparator(PrintWriter pw, String title, boolean first) {
        if (!first) {
            pw.println("</pre><br/>");
        }
        pw.println("<pre>");
        pw.println(title);
        pw.println("========================");
    }
}

