/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import java.util.function.Predicate;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathConstraint
implements Predicate<Value>,
sling-mock-oak.com.google.common.base.Predicate<Value> {
    private static final Logger log = LoggerFactory.getLogger(PathConstraint.class);
    private final String requiredValue;

    public PathConstraint(String definition) {
        this.requiredValue = definition;
    }

    @Override
    public boolean test(@Nullable Value value) {
        try {
            if (value == null || this.requiredValue == null) {
                return false;
            }
            if ("*".equals(this.requiredValue)) {
                return true;
            }
            String actual = value.getString();
            String required = this.requiredValue;
            if (required.endsWith("/*") && PathUtils.isAncestor(required = required.substring(0, required.length() - 2), actual)) {
                return true;
            }
            return required.equals(actual);
        }
        catch (RepositoryException e) {
            log.warn("Error checking path constraint " + this, (Throwable)e);
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean apply(@Nullable Value value) {
        GuavaDeprecation.handleCall("OAK-8874");
        return this.test(value);
    }

    public String toString() {
        return '\'' + this.requiredValue + '\'';
    }
}

