/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Charsets;
import sling-mock-oak.com.google.common.base.Function;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Predicate;
import sling-mock-oak.com.google.common.base.Strings;
import sling-mock-oak.com.google.common.io.BaseEncoding;
import sling-mock-oak.com.google.common.io.Closeables;
import sling-mock-oak.com.google.common.io.Files;

public class OakFileDataStore
extends FileDataStore
implements SharedDataStore {
    public static final Logger LOG = LoggerFactory.getLogger(OakFileDataStore.class);
    private static final int DEFAULT_MIN_RECORD_LENGTH = 4096;
    private byte[] referenceKey;

    public OakFileDataStore() {
        this.inUse = new NoOpMap();
        this.setMinRecordLength(4096);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() {
        final String path = FilenameUtils.normalizeNoEndSeparator((String)new File(this.getPath()).getAbsolutePath());
        return Files.fileTreeTraverser().postOrderTraversal(new File(path)).filter(new Predicate<File>(){

            @Override
            public boolean apply(File input) {
                return input.isFile() && !input.getParent().equals(path);
            }
        }).transform(new Function<File, DataIdentifier>(){

            @Override
            public DataIdentifier apply(File input) {
                return new DataIdentifier(input.getName());
            }
        }).iterator();
    }

    @Override
    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        if (this.referenceKey != null) {
            return this.referenceKey;
        }
        return super.getOrCreateReferenceKey();
    }

    public void setReferenceKeyEncoded(String encodedKey) {
        this.referenceKey = BaseEncoding.base64().decode(encodedKey);
    }

    public void setReferenceKeyPlainText(String textKey) {
        this.referenceKey = textKey.getBytes(Charsets.UTF_8);
    }

    public void setReferenceKey(byte[] referenceKey) {
        this.referenceKey = referenceKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        Preconditions.checkArgument(input != null, "input should not be null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name should not be empty");
        try {
            File file = new File(this.getPath(), name);
            FileOutputStream os = new FileOutputStream(file);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)os);
            }
            finally {
                Closeables.close(os, true);
                Closeables.close(input, true);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record with name {}, {}", new Object[]{name, e});
            throw new DataStoreException("Could not add root record", e);
        }
    }

    @Override
    public void addMetadataRecord(File input, String name) throws DataStoreException {
        Preconditions.checkArgument(input != null, "input should not be null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name should not be empty");
        try {
            File file = new File(this.getPath(), name);
            FileUtils.copyFile((File)input, (File)file);
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record file {} with name {}, {}", new Object[]{input, name, e});
            throw new DataStoreException("Could not add root record", e);
        }
    }

    @Override
    public DataRecord getMetadataRecord(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filter((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])root.listFiles())) {
            if (file.isDirectory()) continue;
            return new FileDataRecord(this, new DataIdentifier(file.getName()), file);
        }
        return null;
    }

    @Override
    public boolean metadataRecordExists(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])root.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.exists()) {
                LOG.debug("File does not exist {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        Preconditions.checkArgument(null != prefix, "prefix should not be null");
        File root = new File(this.getPath());
        ArrayList<DataRecord> rootRecords = new ArrayList<DataRecord>();
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (File[])root.listFiles())) {
            if (file.isDirectory()) continue;
            rootRecords.add(new FileDataRecord(this, new DataIdentifier(file.getName()), file));
        }
        return rootRecords;
    }

    @Override
    public boolean deleteMetadataRecord(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])root.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.delete()) {
                LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteAllMetadataRecords(String prefix) {
        Preconditions.checkArgument(null != prefix, "prefix should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (File[])root.listFiles())) {
            if (file.isDirectory() || file.delete()) continue;
            LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
        }
    }

    @Override
    public Iterator<DataRecord> getAllRecords() {
        final String path = FilenameUtils.normalizeNoEndSeparator((String)new File(this.getPath()).getAbsolutePath());
        final OakFileDataStore store = this;
        return Files.fileTreeTraverser().postOrderTraversal(new File(path)).filter(new Predicate<File>(){

            @Override
            public boolean apply(File input) {
                return input.isFile() && !input.getParent().equals(path);
            }
        }).transform(new Function<File, DataRecord>(){

            @Override
            public DataRecord apply(File input) {
                return new FileDataRecord(store, new DataIdentifier(input.getName()), input);
            }
        }).iterator();
    }

    @Override
    public DataRecord getRecordForId(DataIdentifier id) throws DataStoreException {
        return this.getRecord(id);
    }

    @Override
    public SharedDataStore.Type getType() {
        return SharedDataStore.Type.SHARED;
    }

    static class NoOpMap<K, V>
    extends AbstractMap<K, V> {
        NoOpMap() {
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }
}

