/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.apache.jackrabbit.oak.spi.security.user.UserIdCredentials;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.sling.testing.mock.jcr.MockAuthorizable;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockUser
extends MockAuthorizable
implements User {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public MockUser(@Nullable String id, @Nullable Principal principal, @NotNull Node homeNode, @NotNull MockUserManager mockUserMgr) {
        super(id, principal, homeNode, mockUserMgr);
    }

    public boolean isAdmin() {
        boolean result;
        block2: {
            result = false;
            try {
                result = "admin".equals(this.getID());
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Failed to determine if this is admin", (Throwable)e);
            }
        }
        return result;
    }

    public boolean isSystemUser() {
        return this.principal instanceof SystemUserPrincipal;
    }

    @NotNull
    public Credentials getCredentials() throws RepositoryException {
        char[] pwd = this.homeNode.hasProperty("rep:password") ? this.homeNode.getProperty("rep:password").getString().toCharArray() : null;
        Object creds = pwd == null ? new UserIdCredentials(this.id) : new SimpleCredentials(this.id, pwd);
        return creds;
    }

    @NotNull
    public Impersonation getImpersonation() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void changePassword(@Nullable String password) throws RepositoryException {
        if (password == null) {
            throw new RepositoryException("Attempt to set 'null' password for user " + this.getID());
        }
        try {
            char[] hashedPwd = PasswordUtil.buildPasswordHash((String)password).toCharArray();
            this.homeNode.setProperty("rep:password", String.valueOf(hashedPwd));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RepositoryException("Failed to build the password hash", (Throwable)e);
        }
    }

    public void changePassword(@Nullable String password, @NotNull String oldPassword) throws RepositoryException {
        String hashedPwd;
        if (this.homeNode.hasProperty("rep:password")) {
            String pwd = this.homeNode.getProperty("rep:password").getString();
            hashedPwd = String.valueOf(pwd);
        } else {
            hashedPwd = null;
        }
        if (!PasswordUtil.isSame(hashedPwd, (char[])oldPassword.toCharArray())) {
            throw new RepositoryException("old password did not match");
        }
        this.changePassword(password);
    }

    public void disable(@Nullable String reason) throws RepositoryException {
        if (reason == null) {
            if (this.homeNode.hasProperty("rep:disabled")) {
                this.homeNode.getProperty("rep:disabled").remove();
            }
        } else {
            this.homeNode.setProperty("rep:disabled", reason);
        }
    }

    public boolean isDisabled() throws RepositoryException {
        return this.homeNode.hasProperty("rep:disabled");
    }

    @Nullable
    public String getDisabledReason() throws RepositoryException {
        String disabledReason = null;
        if (this.homeNode.hasProperty("rep:disabled")) {
            disabledReason = this.homeNode.getProperty("rep:disabled").getString();
        }
        return disabledReason;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MockUser [id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }
}

