/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Processor;
import org.apache.sling.rewriter.ProcessorConfiguration;
import org.apache.sling.rewriter.impl.FactoryCache;
import org.xml.sax.ContentHandler;

public class ProcessorWrapper
implements Processor {
    private final Processor delegatee;

    public ProcessorWrapper(ProcessorConfiguration config, FactoryCache factoryCache) throws IOException {
        this.delegatee = factoryCache.getProcessor(config.getType());
        if (this.delegatee == null) {
            throw new IOException("Unable to get processor component for type " + config.getType());
        }
    }

    @Override
    public void finished(boolean errorOccured) throws IOException {
        this.delegatee.finished(errorOccured);
    }

    @Override
    public PrintWriter getWriter() {
        return this.delegatee.getWriter();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.delegatee.getContentHandler();
    }

    @Override
    public void init(ProcessingContext context, ProcessorConfiguration config) throws IOException {
        this.delegatee.init(context, config);
    }

    public String toString() {
        return this.delegatee.toString();
    }
}

