/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jmx.provider.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jmx.provider.impl.AttributeResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapResource
extends AbstractResource {
    private final String path;
    private final ResourceResolver resolver;
    private final Map<String, Object> properties;
    private final ResourceMetadata metadata = new ResourceMetadata();
    private final AttributeResource parent;

    public MapResource(ResourceResolver resolver, String path, Map<String, Object> props, AttributeResource parent) {
        this.parent = parent;
        this.resolver = resolver;
        this.path = path;
        this.properties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (entry.getValue() instanceof Map) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public AttributeResource getAttributeResource() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return (String)this.properties.get("sling:resourceType");
    }

    public String getResourceSuperType() {
        return (String)this.properties.get("sling:resourceType");
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class || type == Map.class) {
            Map<String, Object> propMap = Collections.unmodifiableMap(this.properties);
            return (AdapterType)new DeepReadValueMapDecorator((Resource)this, (ValueMap)new ValueMapDecorator(propMap));
        }
        return (AdapterType)super.adaptTo(type);
    }
}

