/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.JsonConvert;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrivilegesHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessGetServlet;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;

public abstract class AbstractGetAceServlet
extends AbstractAccessGetServlet {
    @Override
    protected JsonObject internalJson(Session session, String resourcePath, String principalId) throws RepositoryException {
        return this.internalGetAce(session, resourcePath, principalId);
    }

    protected JsonObject internalGetAce(Session jcrSession, String resourcePath, String principalId) throws RepositoryException {
        HashMap<Principal, Map<DeclarationType, Set<String>>> principalToDeclaredAtPaths;
        Principal principal = this.validateArgs(jcrSession, resourcePath, principalId);
        Map<String, List<AccessControlEntry>> effectivePathToEntriesMap = this.getAccessControlEntriesMap(jcrSession, resourcePath, principal, principalToDeclaredAtPaths = new HashMap<Principal, Map<DeclarationType, Set<String>>>());
        if (effectivePathToEntriesMap == null || effectivePathToEntriesMap.isEmpty()) {
            throw new ResourceNotFoundException(resourcePath, "No access control entries were found");
        }
        Set supportedRestrictions = this.getRestrictionProvider().getSupportedRestrictions(resourcePath);
        HashMap<String, RestrictionDefinition> srMap = new HashMap<String, RestrictionDefinition>();
        for (Object restrictionDefinition : supportedRestrictions) {
            srMap.put(restrictionDefinition.getName(), (RestrictionDefinition)restrictionDefinition);
        }
        HashMap<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap = new HashMap<Privilege, LocalPrivilege>();
        for (List list : effectivePathToEntriesMap.values()) {
            for (AccessControlEntry accessControlEntry : list) {
                JackrabbitAccessControlEntry jrAccessControlEntry;
                Privilege[] privileges;
                if (!(accessControlEntry instanceof JackrabbitAccessControlEntry) || (privileges = (jrAccessControlEntry = (JackrabbitAccessControlEntry)accessControlEntry).getPrivileges()) == null) continue;
                this.processACE(srMap, jrAccessControlEntry, privileges, privilegeToLocalPrivilegesMap);
            }
        }
        AccessControlManager acm = jcrSession.getAccessControlManager();
        Map<Privilege, Integer> map = PrivilegesHelper.buildPrivilegeLongestDepthMap(acm.privilegeFromName("jcr:all"));
        PrivilegesHelper.consolidateAggregates(jcrSession, resourcePath, privilegeToLocalPrivilegesMap, map);
        JsonObjectBuilder principalObj = JsonConvert.convertToJson(principal, privilegeToLocalPrivilegesMap, -1);
        this.addExtraInfo(principalObj, principal, principalToDeclaredAtPaths);
        return principalObj.build();
    }

    protected void addExtraInfo(JsonObjectBuilder principalJson, Principal principal, Map<Principal, Map<DeclarationType, Set<String>>> principalToDeclaredAtPaths) {
    }

    protected abstract Map<String, List<AccessControlEntry>> getAccessControlEntriesMap(Session var1, String var2, Principal var3, Map<Principal, Map<DeclarationType, Set<String>>> var4) throws RepositoryException;
}

