/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.installer.api.serializer.ConfigurationSerializerFactory;
import org.apache.sling.installer.core.impl.console.AbstractWebConsolePlugin;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling OSGi Installer Configuration Serializer Web Console Plugin", "felix.webconsole.label=osgi-installer-config-printer", "felix.webconsole.title=OSGi Installer Configuration Printer", "felix.webconsole.category=OSGi"})
public class ConfigurationSerializerWebConsolePlugin
extends AbstractWebConsolePlugin {
    public static final String LABEL = "osgi-installer-config-printer";
    private static final String RES_LOC = "osgi-installer-config-printer/res/ui/";
    private static final String PARAMETER_PID = "pid";
    private static final String PARAMETER_FORMAT = "format";
    private static final String CONFIG_PATH_KEY = "org.apache.sling.installer.osgi.path";
    private static final String ALIAS_KEY = "org.apache.sling.installer.osgi.factoryaliaspid";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSerializerWebConsolePlugin.class);
    @Reference
    ConfigurationAdmin configurationAdmin;

    public void service(ServletRequest request, ServletResponse response) throws IOException {
        String pid = request.getParameter(PARAMETER_PID);
        String format = request.getParameter(PARAMETER_FORMAT);
        ConfigurationSerializerFactory.Format serializationFormat = ConfigurationSerializerFactory.Format.JSON;
        if (format != null && !format.trim().isEmpty()) {
            try {
                serializationFormat = ConfigurationSerializerFactory.Format.valueOf(format);
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.warn("Illegal parameter 'format' given, falling back to default '{}'", (Object)serializationFormat, (Object)e);
            }
        }
        PrintWriter pw = response.getWriter();
        pw.println("<script type=\"text/javascript\" src=\"osgi-installer-config-printer/res/ui/clipboard.js\"></script>");
        pw.print("<form method='get'>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        this.titleHtml(pw, "OSGi Installer Configuration Printer", "To emit the configuration properties just enter the configuration PID, select a <a href='https://sling.apache.org/documentation/bundles/configuration-installer-factory.html'>serialization format</a> and click 'Print'");
        this.tr(pw);
        this.tdLabel(pw, "PID");
        this.tdContent(pw);
        pw.print("<input type='text' name='");
        pw.print(PARAMETER_PID);
        pw.print("' value='");
        if (pid != null) {
            pw.print(this.escapeXml(pid));
        }
        pw.println("' class='input' size='120'>");
        this.closeTd(pw);
        this.closeTr(pw);
        this.closeTr(pw);
        this.tr(pw);
        this.tdLabel(pw, "Serialization Format");
        this.tdContent(pw);
        pw.print("<select name='");
        pw.print(PARAMETER_FORMAT);
        pw.println("'>");
        this.option(pw, "JSON", "OSGi Configurator JSON", format);
        this.option(pw, "CONFIG", "Apache Felix Config", format);
        this.option(pw, "PROPERTIES", "Java Properties", format);
        this.option(pw, "PROPERTIES_XML", "Java Properties (XML)", format);
        pw.println("</select>");
        pw.println("&nbsp;&nbsp;<input type='submit' value='Print' class='submit'>");
        this.closeTd(pw);
        this.closeTr(pw);
        if (pid != null && !pid.trim().isEmpty()) {
            this.tr(pw);
            this.tdLabel(pw, "Serialized Configuration Properties");
            this.tdContent(pw);
            Configuration configuration = this.configurationAdmin.getConfiguration(pid, null);
            Dictionary<String, Object> properties = configuration.getProperties();
            if (properties == null) {
                pw.print("<p class='ui-state-error-text'>");
                pw.print("No configuration properties for pid '" + this.escapeXml(pid) + "' found!");
                pw.println("</p>");
            } else {
                properties = ConfigurationSerializerWebConsolePlugin.cleanConfiguration(properties);
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ConfigurationSerializerFactory.create(serializationFormat).serialize(properties, baos);
                    pw.println("<textarea rows=\"20\" cols=\"120\" id=\"output\" readonly>");
                    pw.print(new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    pw.println("</textarea>");
                    pw.println("<button type='button' id='copy'>Copy to Clipboard</a>");
                }
                catch (Throwable e) {
                    pw.print("<p class='ui-state-error-text'>");
                    pw.print("Error serializing pid '" + this.escapeXml(pid) + "': " + e.getMessage());
                    pw.println("</p>");
                    this.LOGGER.warn("Error serializing pid '{}'", (Object)pid, (Object)e);
                }
            }
            this.closeTd(pw);
            this.closeTr(pw);
        }
        pw.println("</table>");
        pw.print("</form>");
    }

    public static Dictionary<String, Object> cleanConfiguration(Dictionary<String, Object> config) {
        Hashtable<String, Object> cleanedConfig = new Hashtable<String, Object>();
        Enumeration<String> e = config.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (IGNORED_PROPERTIES.contains(key)) continue;
            ((Dictionary)cleanedConfig).put(key, config.get(key));
        }
        return cleanedConfig;
    }

    private void tdContent(PrintWriter pw) {
        pw.print("<td class='content' colspan='2'>");
    }

    private void closeTd(PrintWriter pw) {
        pw.print("</td>");
    }

    private void closeTr(PrintWriter pw) {
        pw.println("</tr>");
    }

    private void tdLabel(PrintWriter pw, String label) {
        pw.print("<td class='content'>");
        pw.print(label);
        pw.println("</td>");
    }

    private void tr(PrintWriter pw) {
        pw.println("<tr class='content'>");
    }

    private void option(PrintWriter pw, String value, String label, String selectedValue) {
        pw.print("<option value='");
        pw.print(value);
        pw.print("'");
        if (value.equals(selectedValue)) {
            pw.print(" selected");
        }
        pw.print(">");
        pw.print(label);
        pw.println("</option>");
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        this.tr(pw);
        pw.print("<th colspan='3' class='content container'>");
        pw.print(this.escapeXml(title));
        pw.println("</th>");
        this.closeTr(pw);
        if (description != null) {
            this.tr(pw);
            pw.print("<td colspan='3' class='content'>");
            pw.print(description);
            pw.println("</th>");
            this.closeTr(pw);
        }
    }

    @Override
    String getRelativeResourcePrefix() {
        return RES_LOC;
    }

    static {
        IGNORED_PROPERTIES.add("service.pid");
        IGNORED_PROPERTIES.add(CONFIG_PATH_KEY);
        IGNORED_PROPERTIES.add(ALIAS_KEY);
        IGNORED_PROPERTIES.add("service.factoryPid");
    }
}

