/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.xml.jcr.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.xml.jcr.internal.JcrXmlValueConverter;
import org.osgi.service.component.annotations.Component;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Component(service={ContentParser.class}, property={"org.apache.sling.contentparser.content_type=jcr-xml"})
public final class JCRXMLContentParser
implements ContentParser {
    private final SAXParserFactory saxParserFactory;

    public JCRXMLContentParser() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            spf.setNamespaceAware(true);
            this.saxParserFactory = spf;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to enable secure processing.", e);
        }
    }

    @Override
    public void parse(ContentHandler handler, InputStream is, ParserOptions parserOptions) throws IOException {
        try {
            XmlHandler xmlHandler = new XmlHandler(handler, parserOptions);
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)xmlHandler);
            if (xmlHandler.hasError()) {
                throw xmlHandler.getError();
            }
        }
        catch (Exception ex) {
            throw new IOException("Error parsing JCR XML content.", ex);
        }
    }

    static String decodeName(String qname) {
        return ISO9075.decode((String)qname);
    }

    private static class XmlHandler
    extends DefaultHandler {
        private final ContentHandler contentHandler;
        private final ParserOptions parserOptions;
        private final Deque<String> paths = new ArrayDeque<String>();
        private final Set<String> ignoredPaths = new HashSet<String>();
        private SAXParseException error;

        XmlHandler(ContentHandler contentHandler, ParserOptions parserOptions) {
            this.contentHandler = contentHandler;
            this.parserOptions = parserOptions;
        }

        boolean hasError() {
            return this.error != null;
        }

        SAXParseException getError() {
            return this.error;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String path;
            String resourceName = JCRXMLContentParser.decodeName(qName);
            if (this.paths.isEmpty()) {
                path = "/";
            } else {
                String parentPath = this.paths.peek();
                String string = path = parentPath.endsWith("/") ? parentPath + resourceName : parentPath + "/" + resourceName;
                if (this.parserOptions.getIgnoreResourceNames().contains(resourceName)) {
                    this.ignoredPaths.add(path);
                }
            }
            this.paths.push(path);
            if (this.isIgnoredPath(path)) {
                return;
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Object value;
                String propertyName = this.removePrefixFromPropertyName(this.parserOptions.getRemovePropertyNamePrefixes(), JCRXMLContentParser.decodeName(attributes.getQName(i)));
                if (this.parserOptions.getIgnorePropertyNames().contains(propertyName) || (value = JcrXmlValueConverter.parseValue(propertyName, attributes.getValue(i))) == null) continue;
                properties.put(propertyName, value);
            }
            String defaultPrimaryType = this.parserOptions.getDefaultPrimaryType();
            if (defaultPrimaryType != null && !properties.containsKey("jcr:primaryType")) {
                properties.put("jcr:primaryType", defaultPrimaryType);
            }
            this.contentHandler.resource(path, properties);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.paths.pop();
        }

        @Override
        public void error(SAXParseException ex) {
            this.error = ex;
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.error = ex;
        }

        private boolean isIgnoredPath(String path) {
            if (path == null || path.isEmpty()) {
                return false;
            }
            if (this.ignoredPaths.contains(path)) {
                return true;
            }
            if (path.indexOf(47) > -1) {
                String parentPath = path.substring(0, path.lastIndexOf(47));
                return this.isIgnoredPath(parentPath);
            }
            return this.isIgnoredPath(path);
        }

        private String removePrefixFromPropertyName(Set<String> prefixes, String propertyName) {
            for (String prefix : prefixes) {
                if (!propertyName.startsWith(prefix)) continue;
                return propertyName.substring(prefix.length());
            }
            return propertyName;
        }
    }
}

