/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Traceable;
import org.apache.sling.provisioning.model.io.ModelWriter;

public class ModelArchiveWriter {
    public static final String MANIFEST_HEADER = "Model-Archive-Version";
    public static final int ARCHIVE_VERSION = 1;
    public static final String DEFAULT_EXTENSION = "mar";
    public static final String MODEL_NAME = "models/feature.model";
    public static final String ARTIFACTS_PREFIX = "artifacts/";

    public static JarOutputStream write(OutputStream out, Model model, Manifest baseManifest, ArtifactProvider provider) throws IOException {
        Map<Traceable, String> errors = ModelUtility.validate(model);
        if (errors != null) {
            throw new IOException("Model is not valid: " + errors);
        }
        Manifest manifest = baseManifest == null ? new Manifest() : new Manifest(baseManifest);
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue(MANIFEST_HEADER, String.valueOf(1));
        JarOutputStream jos = new JarOutputStream(out, manifest);
        JarEntry entry = new JarEntry(MODEL_NAME);
        jos.putNextEntry(entry);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, "UTF-8");
        ModelWriter.write(writer, model);
        ((Writer)writer).flush();
        jos.closeEntry();
        byte[] buffer = new byte[0x10000000];
        for (Feature f : model.getFeatures()) {
            for (RunMode rm : f.getRunModes()) {
                for (ArtifactGroup g : rm.getArtifactGroups()) {
                    for (Artifact a : g) {
                        JarEntry artifactEntry = new JarEntry(ARTIFACTS_PREFIX + a.getRepositoryPath());
                        jos.putNextEntry(artifactEntry);
                        try (InputStream is = provider.getInputStream(a);){
                            int l = 0;
                            while ((l = is.read(buffer)) > 0) {
                                jos.write(buffer, 0, l);
                            }
                        }
                        jos.closeEntry();
                    }
                }
            }
        }
        return jos;
    }

    public static interface ArtifactProvider {
        public InputStream getInputStream(Artifact var1) throws IOException;
    }
}

