/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.http.client.protocol;

import java.io.IOException;
import relocated_for_contentpackage.org.apache.commons.logging.Log;
import relocated_for_contentpackage.org.apache.commons.logging.LogFactory;
import relocated_for_contentpackage.org.apache.http.HttpException;
import relocated_for_contentpackage.org.apache.http.HttpRequest;
import relocated_for_contentpackage.org.apache.http.HttpRequestInterceptor;
import relocated_for_contentpackage.org.apache.http.annotation.Contract;
import relocated_for_contentpackage.org.apache.http.annotation.ThreadingBehavior;
import relocated_for_contentpackage.org.apache.http.client.protocol.HttpClientContext;
import relocated_for_contentpackage.org.apache.http.conn.routing.RouteInfo;
import relocated_for_contentpackage.org.apache.http.protocol.HttpContext;
import relocated_for_contentpackage.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

