/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMixinsOperation
extends Operation {
    private final List<String> paths;
    private final List<String> mixins;

    protected BaseMixinsOperation(List<String> mixins, List<String> paths) {
        this.mixins = mixins != null ? mixins : Collections.emptyList();
        this.paths = paths != null ? paths : Collections.emptyList();
    }

    protected String getParametersDescription(String operator) {
        StringBuilder sb = new StringBuilder();
        sb.append(BaseMixinsOperation.listToString(this.getMixins()));
        sb.append(" ").append(operator).append(" ");
        sb.append(BaseMixinsOperation.pathsToString(this.getPaths()));
        return sb.toString();
    }

    @NotNull
    protected String asRepoInitString(String action, String operator) {
        try (Formatter formatter = new Formatter();){
            formatter.format("%s mixin %s %s %s%n", action, BaseMixinsOperation.listToString(this.getMixins()), operator, BaseMixinsOperation.pathsToString(this.getPaths()));
            String string = formatter.toString();
            return string;
        }
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<String> getMixins() {
        return this.mixins;
    }
}

