/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jersey.v3;

import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.glassfish.jersey.server.ContainerRequest;

public class ApplicationHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ContainerRequest request = (ContainerRequest)allArguments[0];
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem items = carrier.items();
        while (items.hasNext()) {
            items = items.next();
            MultivaluedMap headerMap = request.getHeaders();
            List values = (List)headerMap.get(items.getHeadKey());
            if (CollectionUtil.isEmpty((Collection)values)) continue;
            items.setHeadValue((String)values.get(0));
        }
        String operationName = String.join((CharSequence)":", request.getMethod(), request.getPath(false));
        AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)carrier);
        String url = request.getRequestUri().toString();
        Tags.URL.set(span, url);
        Tags.HTTP.METHOD.set(span, request.getMethod());
        span.setComponent((Component)ComponentsDefine.JERSEY);
        SpanLayer.asHttp((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

