/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.micronaut.http.server;

import io.micronaut.http.HttpRequest;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.micronaut.http.server.MicronautHttpServerPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;

class MicronautCommons {
    static final String SPAN_KEY = "CORS_SPAN";
    static final String SKY_CONTEXT_SNAPSHOT_KEY = "CORS_SNAPSHOT";

    MicronautCommons() {
    }

    static void collectHttpParam(HttpRequest<?> httpRequest, AbstractSpan span) {
        String tag = httpRequest.getUri().getQuery();
        String string = tag = MicronautHttpServerPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tag, (int)MicronautHttpServerPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tag;
        if (StringUtil.isNotEmpty((String)tag)) {
            Tags.HTTP.PARAMS.set(span, tag);
        }
    }

    static void cleanup(HttpRequest<?> request) {
        request.removeAttribute((CharSequence)SKY_CONTEXT_SNAPSHOT_KEY, ContextSnapshot.class);
        request.removeAttribute((CharSequence)SPAN_KEY, AbstractSpan.class);
    }

    static void beginTrace(HttpRequest<?> request) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue((String)request.getHeaders().get((CharSequence)next.getHeadKey()));
        }
        String operationName = String.join((CharSequence)":", new CharSequence[]{request.getMethod(), request.getPath()});
        AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
        ContextSnapshot capture = ContextManager.capture();
        request.setAttribute((CharSequence)SPAN_KEY, (Object)span);
        request.setAttribute((CharSequence)SKY_CONTEXT_SNAPSHOT_KEY, (Object)capture);
        Tags.URL.set(span, String.format("%s://%s:%s%s", request.isSecure() ? "https" : "http", request.getServerName(), request.getServerAddress().getPort(), request.getUri().getPath()));
        Tags.HTTP.METHOD.set(span, request.getMethodName());
        span.setComponent((Component)ComponentsDefine.MICRONAUT);
        SpanLayer.asHttp((AbstractSpan)span);
        span.prepareForAsync();
        ContextManager.stopSpan((AbstractSpan)span);
        if (MicronautHttpServerPluginConfig.Plugin.MicronautHttpServer.COLLECT_HTTP_PARAMS) {
            MicronautCommons.collectHttpParam(request, span);
        }
    }
}

