/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.file.AggregatedHttpFileBuilder;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import com.linecorp.armeria.server.file.NonExistentAggregatedHttpFile;
import java.util.Objects;

public interface AggregatedHttpFile {
    public static AggregatedHttpFile of(HttpData data) {
        return AggregatedHttpFile.builder(data).build();
    }

    public static AggregatedHttpFile of(HttpData data, long lastModifiedMillis) {
        Objects.requireNonNull(data, "data");
        return AggregatedHttpFile.builder(data, lastModifiedMillis).build();
    }

    public static AggregatedHttpFile nonExistent() {
        return NonExistentAggregatedHttpFile.INSTANCE;
    }

    public static AggregatedHttpFileBuilder builder(HttpData data) {
        return AggregatedHttpFile.builder(data, System.currentTimeMillis());
    }

    public static AggregatedHttpFileBuilder builder(HttpData data, long lastModifiedMillis) {
        Objects.requireNonNull(data, "data");
        return new AggregatedHttpFileBuilder(data, lastModifiedMillis).autoDetectedContentType(false);
    }

    @Nullable
    public HttpFileAttributes attributes();

    @Nullable
    public ResponseHeaders headers();

    @Nullable
    default public AggregatedHttpResponse response() {
        ResponseHeaders headers = this.headers();
        if (headers == null) {
            return null;
        }
        HttpData content = this.content();
        if (!1.$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        return AggregatedHttpResponse.of(headers, content);
    }

    @Nullable
    public HttpData content();

    public HttpFile toHttpFile();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

