/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.JacksonObjectMapperProvider;
import com.linecorp.armeria.internal.common.DefaultJacksonObjectMapperProvider;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.IOException;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static final JacksonObjectMapperProvider provider;
    private static final ObjectMapper INSTANCE;

    public static ObjectMapper newDefaultObjectMapper() {
        ObjectMapper mapper = provider.newObjectMapper();
        if (mapper == null) {
            throw new NullPointerException(provider.getClass().getSimpleName() + ".newObjectMapper() returned null");
        }
        return mapper;
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return INSTANCE.writeValueAsBytes(value);
    }

    public static <T> T readValue(byte[] bytes, Class<T> clazz) throws IOException {
        return (T)INSTANCE.readValue(bytes, clazz);
    }

    public static <T> T readValue(byte[] bytes, TypeReference<T> typeRef) throws IOException {
        return (T)INSTANCE.readValue(bytes, typeRef);
    }

    private JacksonUtil() {
    }

    static {
        ImmutableList<JacksonObjectMapperProvider> providers = ImmutableList.copyOf(ServiceLoader.load(JacksonObjectMapperProvider.class, JacksonObjectMapperProvider.class.getClassLoader()));
        if (!providers.isEmpty()) {
            provider = (JacksonObjectMapperProvider)providers.get(0);
            if (providers.size() > 1) {
                logger.warn("Found {} {}s. The first provider found will be used among {}", new Object[]{providers.size(), JacksonObjectMapperProvider.class.getSimpleName(), providers});
            } else {
                logger.info("Using {} as a {}", (Object)provider.getClass().getSimpleName(), (Object)JacksonObjectMapperProvider.class.getSimpleName());
            }
        } else {
            provider = DefaultJacksonObjectMapperProvider.INSTANCE;
        }
        INSTANCE = JacksonUtil.newDefaultObjectMapper();
    }
}

