/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.healthcheck;

import com.linecorp.armeria.common.util.AbstractListenable;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.Futures;
import com.linecorp.armeria.server.healthcheck.HealthCheckStatus;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import com.linecorp.armeria.server.healthcheck.SettableHealthChecker;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ScheduledHealthChecker
extends AbstractListenable<HealthChecker>
implements ListenableHealthChecker {
    private final Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker;
    private final Duration fallbackTtl;
    private final EventExecutor eventExecutor;
    private final Consumer<HealthChecker> onHealthCheckerUpdate;
    private final AtomicBoolean isHealthy = new AtomicBoolean();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final AtomicReference<ScheduledHealthCheckerImpl> impl = new AtomicReference();

    ScheduledHealthChecker(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl, EventExecutor eventExecutor) {
        this.healthChecker = healthChecker;
        this.fallbackTtl = fallbackTtl;
        this.eventExecutor = eventExecutor;
        this.onHealthCheckerUpdate = latestValue -> {
            this.isHealthy.set(latestValue.isHealthy());
            this.notifyListeners(latestValue);
        };
    }

    @Override
    public boolean isHealthy() {
        return this.isHealthy.get();
    }

    void startHealthChecker() {
        if (this.requestCount.getAndIncrement() != 0) {
            return;
        }
        ScheduledHealthCheckerImpl newlyScheduled = new ScheduledHealthCheckerImpl(this.healthChecker, this.fallbackTtl, this.eventExecutor);
        while (!this.impl.compareAndSet(null, newlyScheduled)) {
        }
        newlyScheduled.startHealthChecker(this.onHealthCheckerUpdate);
    }

    void stopHealthChecker() {
        int currentCount = this.requestCount.decrementAndGet();
        assert (currentCount >= 0);
        if (currentCount != 0) {
            return;
        }
        ScheduledHealthCheckerImpl current = this.impl.getAndSet(null);
        assert (current != null);
        current.stopHealthChecker(this.onHealthCheckerUpdate);
    }

    int getRequestCount() {
        return this.requestCount.get();
    }

    boolean isActive() {
        return this.impl.get() != null;
    }

    private static final class ScheduledHealthCheckerImpl {
        private static final Logger logger = LoggerFactory.getLogger(ScheduledHealthCheckerImpl.class);
        private final Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker;
        private final Duration fallbackTtl;
        private final EventExecutor eventExecutor;
        private final SettableHealthChecker settableHealthChecker = new SettableHealthChecker(false);
        private volatile State state = State.INIT;
        private volatile Future<?> scheduledFuture = Futures.immediateVoidFuture();

        ScheduledHealthCheckerImpl(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl, EventExecutor eventExecutor) {
            this.healthChecker = healthChecker;
            this.fallbackTtl = fallbackTtl;
            this.eventExecutor = eventExecutor;
        }

        private void startHealthChecker(Consumer<? super HealthChecker> listener) {
            if (this.state != State.INIT) {
                return;
            }
            this.state = State.SCHEDULED;
            this.settableHealthChecker.addListener(listener);
            this.scheduledFuture = this.eventExecutor.submit(this::runHealthCheck);
        }

        private void stopHealthChecker(Consumer<?> listener) {
            if (this.state != State.SCHEDULED) {
                return;
            }
            this.state = State.FINISHED;
            this.scheduledFuture.cancel(true);
            this.settableHealthChecker.removeListener(listener);
        }

        private void runHealthCheck() {
            if (this.state != State.SCHEDULED) {
                return;
            }
            try {
                this.healthChecker.get().handle((result, throwable) -> {
                    long intervalMillis;
                    boolean isHealthy;
                    if (throwable != null) {
                        logger.warn("Health checker throws an exception, schedule the next check after {}ms.", (Object)this.fallbackTtl.toMillis(), throwable);
                        isHealthy = false;
                        intervalMillis = this.fallbackTtl.toMillis();
                    } else if (result == null) {
                        logger.warn("Health checker returns an unexpected null result, schedule the next check after {}ms.", (Object)this.fallbackTtl.toMillis());
                        isHealthy = false;
                        intervalMillis = this.fallbackTtl.toMillis();
                    } else {
                        isHealthy = result.isHealthy();
                        intervalMillis = result.ttlMillis();
                    }
                    this.settableHealthChecker.setHealthy(isHealthy);
                    this.scheduledFuture = this.eventExecutor.schedule(this::runHealthCheck, intervalMillis, TimeUnit.MILLISECONDS);
                    return null;
                });
            }
            catch (Throwable throwable2) {
                logger.warn("Health checker throws an exception, schedule the next check after {}ms.", (Object)this.fallbackTtl.toMillis(), (Object)throwable2);
                this.settableHealthChecker.setHealthy(false);
                this.scheduledFuture = this.eventExecutor.schedule(this::runHealthCheck, this.fallbackTtl.toMillis(), TimeUnit.MILLISECONDS);
            }
        }

        static enum State {
            INIT,
            SCHEDULED,
            FINISHED;

        }
    }
}

