/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.geom.AffineTransform;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.ParameterizedAffine;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Equirectangular
extends AbstractProvider {
    private static final long serialVersionUID = -278288251842178001L;
    public static final String NAME = "Equidistant Cylindrical (Spherical)";
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    static final ParameterDescriptorGroup PARAMETERS;
    private static final Equirectangular INSTANCE;

    public static Equirectangular provider() {
        return INSTANCE;
    }

    public Equirectangular() {
        super(Conversion.class, PARAMETERS, EllipsoidalCS.class, true, CartesianCS.class, false, (byte)2);
    }

    private static double getAndStore(Parameters source, ParameterValueGroup target, ParameterDescriptor<Double> descriptor) throws IllegalArgumentException {
        double value = source.doubleValue(descriptor);
        MapProjection.validate(descriptor, value);
        if (value != 0.0) {
            target.parameter(descriptor.getName().getCode()).setValue(value);
        }
        return value;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context c) throws FactoryException {
        Parameters p = Parameters.castOrWrap(c.getCompletedParameters());
        ContextualParameters context = new ContextualParameters(PARAMETERS, 2, 2);
        double a = Equirectangular.getAndStore(p, context, MapProjection.SEMI_MAJOR);
        double b = Equirectangular.getAndStore(p, context, MapProjection.SEMI_MINOR);
        double \u03bb0 = Equirectangular.getAndStore(p, context, LONGITUDE_OF_ORIGIN);
        double \u03c60 = Equirectangular.getAndStore(p, context, LATITUDE_OF_ORIGIN);
        double \u03c61 = Equirectangular.getAndStore(p, context, STANDARD_PARALLEL);
        double fe = Equirectangular.getAndStore(p, context, FALSE_EASTING);
        double fn = Equirectangular.getAndStore(p, context, FALSE_NORTHING);
        \u03c61 = Math.toRadians(\u03c61);
        MatrixSIS normalize = context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.convertBefore(0, Math.cos(\u03c61), null);
        context.normalizeGeographicInputs(\u03bb0).convertBefore(1, null, -\u03c60);
        if (a != b) {
            double rs = b / a;
            double sin\u03c61 = Math.sin(\u03c61);
            a = b / (1.0 - (1.0 - rs * rs) * (sin\u03c61 * sin\u03c61));
        }
        DoubleDouble k = DoubleDouble.of((double)a, (boolean)true);
        MatrixSIS denormalize = context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertAfter(0, (Number)k, (Number)DoubleDouble.of((double)fe, (boolean)true));
        denormalize.convertAfter(1, (Number)k, (Number)DoubleDouble.of((double)fn, (boolean)true));
        MathTransform mt = context.completeTransform(c.getFactory(), MathTransforms.identity(2));
        if (mt instanceof AffineTransform) {
            mt = new ParameterizedAffine((AffineTransform)mt, context, true);
        }
        return MapProjection.maybe3D(c, mt);
    }

    static {
        ParameterBuilder builder = Equirectangular.builder();
        STANDARD_PARALLEL = Equirectangular.createLatitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8823")).addIdentifier((Citation)Citations.GEOTIFF, "3078")).addName("Latitude of 1st standard parallel")).addName((Citation)Citations.OGC, "standard_parallel_1")).addName((Citation)Citations.ESRI, "Standard_Parallel_1")).addName((Citation)Citations.NETCDF, "standard_parallel")).addName((Citation)Citations.GEOTIFF, "StdParallel1")).addName((Citation)Citations.PROJ4, "lat_ts"), false);
        LONGITUDE_OF_ORIGIN = Equirectangular.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8802")).addIdentifier((Citation)Citations.GEOTIFF, "3088")).addName("Longitude of natural origin")).addName("Central Meridian")).addName("CM")).addName((Citation)Citations.OGC, "central_meridian")).addName((Citation)Citations.ESRI, "Central_Meridian")).addName((Citation)Citations.NETCDF, "longitude_of_projection_origin")).addName((Citation)Citations.GEOTIFF, "CenterLong")).addName((Citation)Citations.PROJ4, "lon_0"));
        FALSE_EASTING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8806")).addIdentifier((Citation)Citations.GEOTIFF, "3082")).addName("False easting")).addName("False westing")).addName((Citation)Citations.OGC, "false_easting")).addName((Citation)Citations.ESRI, "False_Easting")).addName((Citation)Citations.NETCDF, "false_easting")).addName((Citation)Citations.GEOTIFF, "FalseEasting")).addName((Citation)Citations.PROJ4, "x_0"));
        FALSE_NORTHING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8807")).addIdentifier((Citation)Citations.GEOTIFF, "3083")).addName("False northing")).addName("False southing")).addName((Citation)Citations.OGC, "false_northing")).addName((Citation)Citations.ESRI, "False_Northing")).addName((Citation)Citations.NETCDF, "false_northing")).addName((Citation)Citations.GEOTIFF, "FalseNorthing")).addName((Citation)Citations.PROJ4, "y_0"));
        LATITUDE_OF_ORIGIN = Equirectangular.createZeroConstant(((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8801")).addIdentifier((Citation)Citations.GEOTIFF, "3089")).addName("Latitude of natural origin")).addName((Citation)Citations.OGC, "latitude_of_origin")).addName((Citation)Citations.ESRI, "Latitude_Of_Origin")).addName((Citation)Citations.NETCDF, "latitude_of_projection_origin")).addName((Citation)Citations.GEOTIFF, "CenterLat")).addName((Citation)Citations.PROJ4, "lat_0")).setRemarks((CharSequence)Resources.formatInternational((short)12, (Object)0))).setRequired(false));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)Equirectangular.addIdentifierAndLegacy(builder, "1029", "9823").addName(NAME)).addName((Citation)Citations.OGC, "Equirectangular")).addName((Citation)Citations.ESRI, "Plate_Carree")).addName(Citations.SIS, "Plate Carr\u00e9e")).createGroupForMapProjection(STANDARD_PARALLEL, LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING);
        INSTANCE = new Equirectangular();
    }
}

