/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.StandardDefinitions;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.TransverseMercator;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.system.Fallback;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;

@Fallback
final class EPSGFactoryFallback
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    static final EPSGFactoryFallback INSTANCE = new EPSGFactoryFallback();
    private String installationURL;
    private final ProjectedCRS[] cache = new ProjectedCRS[2];
    private static final int CRS = 1;
    private static final int DATUM = 2;
    private static final int ENSEMBLE = 4;
    private static final int ELLIPSOID = 8;
    private static final int PRIME_MERIDIAN = 16;
    private static final int UNIT = 32;
    private static final int AXIS = 64;
    private static final int CS = 128;

    private EPSGFactoryFallback() {
    }

    @Override
    public Citation getAuthority() {
        return StandardDefinitions.AUTHORITY;
    }

    private String getAuthorityTitle() {
        return this.getAuthority().getTitle().toString();
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Set.of("EPSG");
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) {
        boolean pm = type.isAssignableFrom(PrimeMeridian.class);
        boolean ellipsoid = type.isAssignableFrom(Ellipsoid.class);
        boolean datum = type.isAssignableFrom(GeodeticDatum.class);
        boolean geographic = type.isAssignableFrom(GeographicCRS.class);
        boolean geocentric = type.isAssignableFrom(GeocentricCRS.class);
        boolean projected = type.isAssignableFrom(ProjectedCRS.class);
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        if (pm) {
            codes.add("8901");
        }
        for (CommonCRS crs : CommonCRS.values()) {
            if (ellipsoid) {
                EPSGFactoryFallback.add(codes, crs.ellipsoid);
            }
            if (datum) {
                EPSGFactoryFallback.add(codes, crs.datum);
            }
            if (geocentric) {
                EPSGFactoryFallback.add(codes, crs.geocentric);
            }
            if (geographic) {
                EPSGFactoryFallback.add(codes, crs.geographic);
                EPSGFactoryFallback.add(codes, crs.geo3D);
            }
            if (!projected) continue;
            EPSGFactoryFallback.add(codes, crs.northUPS);
            EPSGFactoryFallback.add(codes, crs.southUPS);
            if (crs.northUTM == 0 && crs.southUTM == 0) continue;
            for (int zone = crs.firstZone; zone <= crs.lastZone; ++zone) {
                if (crs.northUTM != 0) {
                    codes.add(Integer.toString(crs.northUTM + zone));
                }
                if (crs.southUTM == 0) continue;
                codes.add(Integer.toString(crs.southUTM + zone));
            }
        }
        boolean vertical = type.isAssignableFrom(VerticalCRS.class);
        boolean vdatum = type.isAssignableFrom(VerticalDatum.class);
        if (vertical || vdatum) {
            for (CommonCRS.Vertical candidate : CommonCRS.Vertical.values()) {
                if (!candidate.isEPSG) continue;
                if (vertical) {
                    EPSGFactoryFallback.add(codes, candidate.crs);
                }
                if (!vdatum) continue;
                EPSGFactoryFallback.add(codes, candidate.datum);
            }
        }
        if (type.isAssignableFrom(EllipsoidalCS.class)) {
            EPSGFactoryFallback.add(codes, (short)6422);
            EPSGFactoryFallback.add(codes, (short)6423);
        }
        if (type.isAssignableFrom(SphericalCS.class)) {
            EPSGFactoryFallback.add(codes, (short)6404);
        }
        if (type.isAssignableFrom(CartesianCS.class)) {
            EPSGFactoryFallback.add(codes, (short)6500);
            EPSGFactoryFallback.add(codes, (short)4400);
            EPSGFactoryFallback.add(codes, (short)1026);
            EPSGFactoryFallback.add(codes, (short)1027);
        }
        if (type.isAssignableFrom(Unit.class)) {
            EPSGFactoryFallback.add(codes, (short)9001);
            EPSGFactoryFallback.add(codes, (short)9122);
        }
        return codes;
    }

    private static void add(Set<String> codes, short value) {
        if (value != 0) {
            codes.add(Short.toString(value));
        }
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws NoSuchAuthorityCodeException {
        return (PrimeMeridian)this.predefined(code, 16);
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws NoSuchAuthorityCodeException {
        return (Ellipsoid)this.predefined(code, 8);
    }

    @Override
    public Datum createDatum(String code) throws NoSuchAuthorityCodeException {
        return (Datum)this.predefined(code, 6);
    }

    @Override
    public DefaultDatumEnsemble<?> createDatumEnsemble(String code) throws NoSuchAuthorityCodeException {
        return (DefaultDatumEnsemble)this.predefined(code, 4);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException {
        return (CoordinateReferenceSystem)this.predefined(code, 1);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws NoSuchAuthorityCodeException {
        return (CoordinateSystem)this.predefined(code, 128);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws NoSuchAuthorityCodeException {
        return (CoordinateSystemAxis)this.predefined(code, 64);
    }

    @Override
    public Unit<?> createUnit(String code) throws NoSuchAuthorityCodeException {
        return (Unit)this.predefined(code, 32);
    }

    @Override
    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException {
        return (IdentifiedObject)this.predefined(code, -33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object predefined(String code, int kind) throws NoSuchAuthorityCodeException {
        try {
            Unit unit;
            CoordinateSystemAxis axis;
            CoordinateSystem cs;
            int s = Math.max(code.lastIndexOf(58), code.lastIndexOf(35));
            code = CharSequences.trimWhitespaces((CharSequence)code, (int)(s + 1), (int)code.length()).toString();
            short n = Short.parseShort(code);
            if ((kind & 1) != 0) {
                boolean pseudo;
                boolean bl = pseudo = n == 3857;
                if (pseudo || n == 3395) {
                    int index = pseudo ? 1 : 0;
                    ProjectedCRS[] projectedCRSArray = this.cache;
                    synchronized (this.cache) {
                        ProjectedCRS crs = this.cache[index];
                        if (crs == null) {
                            this.cache[index] = crs = StandardDefinitions.createMercator(n, CommonCRS.WGS84.geographic(), pseudo);
                        }
                        // ** MonitorExit[projectedCRSArray] (shouldn't be in output)
                        return crs;
                    }
                }
            }
            if ((kind & 0xF) != 0) {
                for (CommonCRS commonCRS : CommonCRS.values()) {
                    double latitude;
                    int zone;
                    if ((kind & 8) != 0 && n == commonCRS.ellipsoid) {
                        return commonCRS.ellipsoid();
                    }
                    if ((kind & 2) != 0 && n == commonCRS.datum) {
                        return commonCRS.datum((kind & 4) != 0);
                    }
                    if ((kind & 4) != 0 && n == commonCRS.datum) {
                        return commonCRS.datumEnsemble();
                    }
                    if ((kind & 1) == 0) continue;
                    if (n == commonCRS.geographic) {
                        return commonCRS.geographic();
                    }
                    if (n == commonCRS.geocentric) {
                        return commonCRS.geocentric();
                    }
                    if (n == commonCRS.geo3D) {
                        return commonCRS.geographic3D();
                    }
                    if (commonCRS.northUTM != 0 && (zone = n - commonCRS.northUTM) >= commonCRS.firstZone && zone <= commonCRS.lastZone) {
                        latitude = 1.0;
                    } else if (commonCRS.southUTM != 0 && (zone = n - commonCRS.southUTM) >= commonCRS.firstZone && zone <= commonCRS.lastZone) {
                        latitude = -1.0;
                    } else if (n == commonCRS.northUPS) {
                        latitude = 90.0;
                        zone = 30;
                    } else {
                        if (n != commonCRS.southUPS) continue;
                        latitude = -90.0;
                        zone = 30;
                    }
                    return commonCRS.universal(latitude, TransverseMercator.Zoner.UTM.centralMeridian(zone));
                }
                if ((kind & 7) != 0) {
                    for (Enum enum_ : CommonCRS.Vertical.values()) {
                        if (!((CommonCRS.Vertical)enum_).isEPSG) continue;
                        if ((kind & 2) != 0 && ((CommonCRS.Vertical)enum_).datum == n) {
                            return ((CommonCRS.Vertical)enum_).datum();
                        }
                        if ((kind & 4) != 0 && ((CommonCRS.Vertical)enum_).datum == n) {
                            return null;
                        }
                        if ((kind & 1) == 0 || ((CommonCRS.Vertical)enum_).crs != n) continue;
                        return ((CommonCRS.Vertical)enum_).crs();
                    }
                }
            }
            if ((kind & 0x10) != 0 && n == 8901) {
                return CommonCRS.WGS84.primeMeridian();
            }
            if ((kind & 0x80) != 0 && (cs = StandardDefinitions.createCoordinateSystem(n, false)) != null) {
                return cs;
            }
            if ((kind & 0x40) != 0 && (axis = StandardDefinitions.createAxis(n, false)) != null) {
                return axis;
            }
            if ((kind & 0x20) != 0 && (unit = Units.valueOfEPSG((int)n)) != null) {
                return unit;
            }
        }
        catch (NumberFormatException cause) {
            NoSuchAuthorityCodeException e = new NoSuchAuthorityCodeException(Resources.format((short)49, "EPSG", EPSGFactoryFallback.toClass(kind), code), this.getAuthorityTitle(), code);
            e.initCause((Throwable)cause);
            throw e;
        }
        throw new NoSuchAuthorityCodeException(Resources.format((short)48, "EPSG", EPSGFactoryFallback.toClass(kind), code, this.getInstallationURL()), this.getAuthorityTitle(), code);
    }

    private synchronized String getInstallationURL() {
        if (this.installationURL == null) {
            this.installationURL = "https://sis.apache.org/epsg.html";
            ServiceLoader services = InstallationResources.load();
            boolean embedded = false;
            do {
                String authority = embedded ? "Embedded" : "EPSG";
                for (InstallationResources res : services) {
                    String url;
                    if (!res.getAuthorities().contains(authority) || (url = res.getInstructionURL()) == null) continue;
                    this.installationURL = url;
                    return url;
                }
            } while (embedded = !embedded);
        }
        return this.installationURL;
    }

    private static Class<?> toClass(int kind) {
        switch (kind) {
            case 1: {
                return CoordinateReferenceSystem.class;
            }
            case 2: {
                return Datum.class;
            }
            case 4: {
                return DefaultDatumEnsemble.class;
            }
            case 8: {
                return Ellipsoid.class;
            }
            case 16: {
                return PrimeMeridian.class;
            }
            case 32: {
                return Unit.class;
            }
            case 64: {
                return CoordinateSystemAxis.class;
            }
            case 128: {
                return CoordinateSystem.class;
            }
        }
        return IdentifiedObject.class;
    }
}

