/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.AxisType;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Variable;

final class VariableTransformer {
    private final Decoder decoder;
    private Matcher[] matchers;

    VariableTransformer(Decoder decoder) {
        this.decoder = decoder;
    }

    final void analyze(Variable variable) throws IOException, DataStoreException {
        switch (variable.getNumDimensions()) {
            default: {
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                if (variable.getDataType() == DataType.CHAR) break;
                return;
            }
        }
        String units = variable.getUnitsString();
        if (units != null) {
            UnitPattern[] candidates = UnitPattern.values();
            if (this.matchers == null) {
                this.matchers = new Matcher[candidates.length];
            }
            for (UnitPattern candidate : candidates) {
                int[] fieldBases;
                if (candidate.requireTimeAxis && AxisType.valueOf(variable, false) != AxisType.T) continue;
                Matcher matcher = this.matchers[candidate.ordinal()];
                if (matcher == null) {
                    this.matchers[candidate.ordinal()] = matcher = candidate.pattern.matcher(units);
                } else {
                    matcher.reset(units);
                }
                if (!matcher.matches() || (fieldBases = candidate.fieldBases.apply(matcher)) == null) continue;
                this.datesToTimeSinceEpoch(variable, candidate.unit, fieldBases, candidate == UnitPattern.CLIMATOLOGICAL);
            }
        }
    }

    private void datesToTimeSinceEpoch(Variable variable, Unit<Time> unit, int[] fieldBases, boolean climatological) throws IOException, DataStoreException {
        Unit unitOfLast;
        switch (fieldBases.length) {
            case 2: {
                unitOfLast = Units.DAY;
                break;
            }
            case 3: {
                unitOfLast = Units.HOUR;
                break;
            }
            case 4: {
                unitOfLast = Units.MINUTE;
                break;
            }
            case 5: {
                unitOfLast = Units.SECOND;
                break;
            }
            default: {
                return;
            }
        }
        Instant epoch = Instant.EPOCH;
        Variable axis = this.decoder.findVariable(variable.getGridDimensions().get(0).getName());
        if (axis != variable && axis != null) {
            Unit<?> t = axis.getUnit();
            if (unit == null) {
                try {
                    unit = t.asType(Time.class);
                }
                catch (ClassCastException e) {
                    this.decoder.illegalAttributeValue("units", axis.getUnitsString(), e);
                }
            }
            if (axis.epoch != null) {
                epoch = axis.epoch;
            }
        }
        if (unit == null) {
            unit = Units.DAY;
        }
        variable.setUnit(unit, epoch);
        int year = climatological ? LocalDate.ofInstant(epoch, ZoneOffset.UTC).getYear() : 0;
        double offset = epoch.toEpochMilli() + (long)(1000 * this.decoder.getTimeZone().getTotalSeconds());
        offset = Units.MILLISECOND.getConverterTo(unit).convert(offset);
        UnitConverter toUnit = unitOfLast.getConverterTo(unit);
        int[] fields = new int[fieldBases.length];
        Vector values = variable.read();
        double[] times = new double[values.size()];
        for (int i = 0; i < times.length; ++i) {
            double value = values.doubleValue(i);
            long time = (long)value;
            value -= (double)time;
            int j = fields.length;
            while (--j >= 0) {
                int base = fieldBases[j];
                fields[j] = Math.abs((int)(time % (long)base));
                time /= (long)base;
            }
            LocalDate date = LocalDate.of(Math.toIntExact((long)year + time), fields[0], fields[1]);
            time = date.toEpochDay();
            for (int j2 = 2; j2 < fields.length; ++j2) {
                time *= j2 == 2 ? 24L : 60L;
                time += (long)fields[j2];
            }
            times[i] = toUnit.convert(value += (double)time - offset);
        }
        variable.setValues(times, true);
    }

    /*
     * Exception performing whole class analysis.
     */
    private static final class UnitPattern
    extends Enum<UnitPattern> {
        public static final /* enum */ UnitPattern HYCOM;
        public static final /* enum */ UnitPattern CLIMATOLOGICAL;
        final Pattern pattern;
        final Unit<Time> unit;
        final Function<Matcher, int[]> fieldBases;
        final boolean requireTimeAxis;
        private static final /* synthetic */ UnitPattern[] $VALUES;

        public static UnitPattern[] values() {
            return (UnitPattern[])$VALUES.clone();
        }

        public static UnitPattern valueOf(String name) {
            return Enum.valueOf(UnitPattern.class, name);
        }

        private UnitPattern(String regex, Unit<Time> unit, boolean requireTimeAxis, Function<Matcher, int[]> fieldBases) {
            super(string, n);
            this.pattern = Pattern.compile(regex, 2);
            this.requireTimeAxis = requireTimeAxis;
            this.fieldBases = fieldBases;
            this.unit = unit;
        }

        private static /* synthetic */ int[] lambda$static$1(Matcher matcher) {
            String order = "MDHMS";
            int count = matcher.groupCount();
            int[] bases = new int[count];
            for (int i = 0; i < count; ++i) {
                String value = matcher.group(i + 1);
                int n = value.length();
                if (--n < 0 || Character.toUpperCase(value.charAt(0)) != "MDHMS".charAt(i)) {
                    return null;
                }
                int base = 10;
                while (--n >= 0) {
                    if ((base *= 10) >= 0) continue;
                    return null;
                }
                bases[i] = base;
            }
            return bases;
        }

        private static /* synthetic */ UnitPattern[] $values() {
            return new UnitPattern[]{HYCOM, CLIMATOLOGICAL};
        }

        /*
         * Exception decompiling
         */
        static {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

