/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.style.se1.ColorReplacement;
import org.apache.sis.style.se1.GraphicalSymbol;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="ExternalGraphicType", propOrder={"format", "colorReplacements"})
@XmlRootElement(name="ExternalGraphic")
public class ExternalGraphic<R>
extends GraphicalSymbol<R> {
    @XmlElement(name="ColorReplacement")
    protected List<ColorReplacement<R>> colorReplacements;

    private ExternalGraphic() {
    }

    public ExternalGraphic(StyleFactory<R> factory) {
        super(factory);
    }

    public ExternalGraphic(ExternalGraphic<R> source) {
        super(source);
        List<ColorReplacement<R>> value = source.colorReplacements;
        if (value != null) {
            this.colorReplacements = new ArrayList<ColorReplacement<R>>(value);
        }
    }

    public List<ColorReplacement<R>> colorReplacements() {
        if (this.colorReplacements == null) {
            this.colorReplacements = new ArrayList<ColorReplacement<R>>();
        }
        return this.colorReplacements;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.onlineResource, this.inlineContent, this.format, this.colorReplacements};
    }

    @Override
    public ExternalGraphic<R> clone() {
        ExternalGraphic clone = (ExternalGraphic)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.colorReplacements != null) {
            this.colorReplacements = new ArrayList<ColorReplacement<R>>(this.colorReplacements);
            this.colorReplacements.replaceAll(ColorReplacement::clone);
        }
    }
}

